/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.passenger.ck.service.Impl;

import com.ovopark.passenger.ck.dto.TagDepPeriodDto;
import com.ovopark.passenger.ck.mapper.FlowHourlyCkMapper;
import com.ovopark.passenger.ck.service.FlowQueryService;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service
public class FlowQueryServiceImpl
implements FlowQueryService {
    private final FlowHourlyCkMapper ckMapper;
    private final FlowHourlyCkMapper passengerFlowTelemetryMapper;

    public FlowQueryServiceImpl(FlowHourlyCkMapper ckMapper, FlowHourlyCkMapper passengerFlowTelemetryMapper) {
        this.ckMapper = ckMapper;
        this.passengerFlowTelemetryMapper = passengerFlowTelemetryMapper;
    }

    @Override
    public List<TagDepPeriodDto> queryTagDepAgg(Integer enterpriseId, List<Integer> depIds, Integer type, String startTime, String endTime, Integer startHour, Integer endHour, Integer isOnBusinessTime) {
        if (enterpriseId == null) {
            throw new IllegalArgumentException("enterpriseId required");
        }
        if (type == null) {
            throw new IllegalArgumentException("type required");
        }
        if (startTime == null || endTime == null) {
            throw new IllegalArgumentException("startTime/endTime required");
        }
        if (startHour == null) {
            startHour = 0;
        }
        if (endHour == null) {
            endHour = 23;
        }
        List<TagDepPeriodDto> result = this.ckMapper.selectTagDepAgg(enterpriseId, depIds, type, startTime, endTime, startHour, endHour, isOnBusinessTime);
        List<String> timeSlots = this.generateTimeSlots(startTime, endTime, type, startHour, endHour);
        Map resultMap = result.stream().collect(Collectors.toMap(dto -> dto.getDepId() + "_" + dto.getTagId() + "_" + dto.getPeriod(), Function.identity()));
        HashSet<String> seenCombinations = new HashSet<String>();
        ArrayList<TagDepPeriodDto> finalResult = new ArrayList<TagDepPeriodDto>();
        for (Integer depId : depIds) {
            List<Integer> tagIds = this.getTagIdsForDepId(result, depId);
            for (String timeSlot : timeSlots) {
                for (Integer tagId : tagIds) {
                    String key = depId + "_" + tagId + "_" + timeSlot;
                    if (seenCombinations.contains(key)) continue;
                    TagDepPeriodDto existingDto = (TagDepPeriodDto)resultMap.get(key);
                    if (existingDto == null) {
                        TagDepPeriodDto newDto = new TagDepPeriodDto();
                        newDto.setDepId(depId);
                        newDto.setTagId(tagId);
                        newDto.setPeriod(timeSlot);
                        newDto.setInTotalNum(0L);
                        newDto.setInTotalPeople(0L);
                        finalResult.add(newDto);
                    } else {
                        finalResult.add(existingDto);
                    }
                    seenCombinations.add(key);
                }
            }
        }
        finalResult.sort(Comparator.comparing(TagDepPeriodDto::getDepId).thenComparing(TagDepPeriodDto::getTagId).thenComparing(TagDepPeriodDto::getPeriod));
        return finalResult;
    }

    @Override
    public Optional<Integer> getMaxRecordNum(Integer enterpriseId, Integer depId, List<String> macs, Integer tagId, String faceId, LocalDateTime startTime, LocalDateTime endTime) {
        Integer maxCount = this.passengerFlowTelemetryMapper.selectMaxRecordNum(enterpriseId, depId, macs, tagId, faceId, startTime, endTime);
        return Optional.ofNullable(maxCount);
    }

    private List<Integer> getTagIdsForDepId(List<TagDepPeriodDto> result, Integer depId) {
        return result.stream().filter(dto -> dto.getDepId().equals(depId)).map(TagDepPeriodDto::getTagId).distinct().collect(Collectors.toList());
    }

    private List<String> generateTimeSlots(String startTime, String endTime, Integer timeType, Integer startHour, Integer endHour) {
        ArrayList<String> timeSlots = new ArrayList<String>();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        LocalDateTime start = LocalDateTime.parse(startTime, formatter);
        LocalDateTime end = LocalDateTime.parse(endTime, formatter);
        block8: while (!start.isAfter(end)) {
            String period = this.generatePeriod(start, timeType);
            timeSlots.add(period);
            switch (timeType) {
                case 1: {
                    start = start.plusHours(1L);
                    continue block8;
                }
                case 2: {
                    start = start.plusDays(1L);
                    continue block8;
                }
                case 3: {
                    start = start.plusWeeks(1L);
                    continue block8;
                }
                case 4: {
                    start = start.plusMonths(1L);
                    continue block8;
                }
                case 5: {
                    start = start.plusMonths(3L);
                    continue block8;
                }
                case 6: {
                    start = start.plusYears(1L);
                    continue block8;
                }
            }
            start = start.plusHours(1L);
        }
        return timeSlots;
    }

    private String generatePeriod(LocalDateTime start, Integer timeType) {
        switch (timeType) {
            case 1: {
                return start.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:00:00"));
            }
            case 2: {
                return start.format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
            }
            case 3: {
                return start.format(DateTimeFormatter.ofPattern("yyyy-ww"));
            }
            case 4: {
                return start.format(DateTimeFormatter.ofPattern("yyyy-MM"));
            }
            case 5: {
                int quarter = (start.getMonthValue() - 1) / 3 + 1;
                return start.format(DateTimeFormatter.ofPattern("yyyy")) + "-Q" + quarter;
            }
            case 6: {
                return start.format(DateTimeFormatter.ofPattern("yyyy"));
            }
        }
        return start.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:00:00"));
    }
}

