/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.passenger.feign;

import com.alibaba.fastjson.JSONObject;
import com.alicp.jetcache.anno.Cached;
import com.ovopark.organize.common.base.BaseResult;
import com.ovopark.organize.common.model.mo.DepIdsAndUserMo;
import com.ovopark.organize.common.model.mo.UserIdAndOrgIdMo;
import com.ovopark.organize.common.model.pojo.DepartmentPojo;
import com.ovopark.organize.sdk.api.DepartmentApi;
import com.ovopark.organize.sdk.api.UserDepartmentApi;
import com.ovopark.pojo.dto.DepartmentDto;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DepartmentFeign {
    private static final Logger log = LoggerFactory.getLogger(DepartmentFeign.class);
    @Resource
    private UserDepartmentApi userDepartmentApi;
    @Resource
    private DepartmentApi departmentApi;

    @Cached(expire=300)
    public Map<Integer, String> listSimpleDepartmentByOrgIdAndUserId(Integer orgId, Integer userId, Integer enterpriseId) {
        if (Objects.isNull(orgId) || Objects.isNull(userId) || Objects.isNull(enterpriseId)) {
            return new HashMap<Integer, String>();
        }
        UserIdAndOrgIdMo param = new UserIdAndOrgIdMo();
        param.setGroupId(enterpriseId);
        param.setOrganizeId(orgId);
        param.setUserId(userId);
        BaseResult departmentRes = this.userDepartmentApi.getDepartmentByUserIdAndOrgId(param);
        if (departmentRes != null && !departmentRes.getIsError().booleanValue() && departmentRes.getData() != null) {
            return (Map)departmentRes.getData();
        }
        return new HashMap<Integer, String>();
    }

    public List<Integer> getDepIdsByOrganizeIds(List<Integer> orgIds, Integer userId, Integer enterpriseId) {
        if (CollectionUtils.isEmpty(orgIds) || Objects.isNull(userId) || Objects.isNull(enterpriseId)) {
            return new ArrayList<Integer>();
        }
        DepIdsAndUserMo param = new DepIdsAndUserMo();
        param.setOrganizeId(StringUtils.join(orgIds, (String)","));
        param.setUserGroupId(enterpriseId);
        param.setUserId(userId);
        BaseResult depIdsRes = this.userDepartmentApi.getDepIdsByOrganizeIds(param);
        if (depIdsRes != null && !depIdsRes.getIsError().booleanValue() && depIdsRes.getData() != null) {
            return (List)depIdsRes.getData();
        }
        return new ArrayList<Integer>();
    }

    public DepartmentDto getById(Integer id) {
        if (id == null) {
            return null;
        }
        BaseResult departmentRes = this.userDepartmentApi.getDepartmentById(id);
        if (departmentRes != null && !departmentRes.getIsError().booleanValue() && departmentRes.getData() != null) {
            return this.copyDepartmentPojo2Dto((DepartmentPojo)departmentRes.getData());
        }
        return null;
    }

    private DepartmentDto copyDepartmentPojo2Dto(DepartmentPojo pojo) {
        return new DepartmentDto().setId(pojo.getId()).setName(pojo.getName()).setShopId(pojo.getShopId()).setGroupId(pojo.getGroupId()).setOrganizeId(pojo.getOrganizeId()).setCreateTime(pojo.getCreateTime());
    }

    public List<Integer> getDepIdsByIdsAndStatus(List<Integer> ids, String status) {
        if (CollectionUtils.isEmpty(ids) || StringUtils.isBlank((CharSequence)status)) {
            return new ArrayList<Integer>();
        }
        BaseResult depIdsRes = this.departmentApi.getDeptByIdAndStatus(ids, status);
        if (depIdsRes != null && !depIdsRes.getIsError().booleanValue() && depIdsRes.getData() != null) {
            return (List)depIdsRes.getData();
        }
        return new ArrayList<Integer>();
    }

    public Map<Integer, String> getDepIdAndNamesByDepIds(List<Integer> depIds) {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        if (CollectionUtils.isEmpty(depIds)) {
            return result;
        }
        try {
            List data;
            BaseResult baseRes = this.departmentApi.getDepartmentByIds(depIds);
            log.info("getDepartmentByIds baseRes:{}", (Object)JSONObject.toJSONString((Object)baseRes));
            if (Objects.nonNull(baseRes) && !baseRes.getIsError().booleanValue() && Objects.nonNull(baseRes.getData()) && CollectionUtils.isNotEmpty((Collection)(data = (List)baseRes.getData()))) {
                return data.stream().collect(Collectors.toMap(DepartmentPojo::getId, DepartmentPojo::getName));
            }
            return result;
        }
        catch (Exception e) {
            log.error("getDepartmentByIds fail", (Throwable)e);
            return result;
        }
    }

    public Date getLocalDate(Integer deptId) {
        BaseResult res = this.departmentApi.getDepartmentById(deptId);
        if (res == null || res.getData() == null || ((DepartmentPojo)res.getData()).getLocalTime() == null) {
            return new Date();
        }
        return ((DepartmentPojo)res.getData()).getLocalTime();
    }
}

