/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.passenger.feign;

import com.alibaba.fastjson.JSONObject;
import com.ovopark.organize.common.base.BaseResult;
import com.ovopark.organize.common.model.mo.EnterpriseGroupMo;
import com.ovopark.organize.sdk.api.EnterpriseGroupsApi;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class EnterpriseGroupsFeign {
    private static final Logger log = LoggerFactory.getLogger(EnterpriseGroupsFeign.class);
    @Resource
    private EnterpriseGroupsApi enterpriseGroupsApi;

    public List<EnterpriseGroupMo> getEnterpriseByIds(List<Integer> enterpriseIds) {
        ArrayList<EnterpriseGroupMo> result = new ArrayList<EnterpriseGroupMo>();
        if (CollectionUtils.isEmpty(enterpriseIds)) {
            return result;
        }
        try {
            BaseResult baseRes = this.enterpriseGroupsApi.getEnterpriseByIdsApi(enterpriseIds);
            log.info("getEnterpriseByIdsApi baseRes:{}", (Object)JSONObject.toJSONString((Object)baseRes));
            if (Objects.nonNull(baseRes) && !baseRes.getIsError().booleanValue() && Objects.nonNull(baseRes.getData())) {
                return (List)baseRes.getData();
            }
            return result;
        }
        catch (Exception e) {
            log.error("getEnterpriseByIdsApi fail", (Throwable)e);
            return result;
        }
    }

    public Map<Integer, EnterpriseGroupMo> getEnterpriseGroupMap(List<Integer> enterpriseIds) {
        HashMap<Integer, EnterpriseGroupMo> result = new HashMap<Integer, EnterpriseGroupMo>();
        if (CollectionUtils.isEmpty(enterpriseIds)) {
            return result;
        }
        List<EnterpriseGroupMo> enterpriseGroupMoList = this.getEnterpriseByIds(enterpriseIds);
        if (CollectionUtils.isEmpty(enterpriseGroupMoList)) {
            return result;
        }
        return enterpriseGroupMoList.stream().collect(Collectors.toMap(EnterpriseGroupMo::getId, e -> e));
    }
}

