/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.passenger.redis;

import com.alicp.jetcache.Cache;
import com.alicp.jetcache.anno.CreateCache;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class HourSummaryLockHelper {
    private static final Logger log = LoggerFactory.getLogger(HourSummaryLockHelper.class);
    @CreateCache(name="hourSummary", expire=100)
    private Cache<String, String> cache;

    public void tryLockAndRun(String mac, String dateStr, Integer tagId, Integer productId, Runnable runnable) {
        String key = HourSummaryLockHelper.getKey(mac, dateStr, tagId, productId);
        boolean getLock = this.cache.tryLockAndRun((Object)key, 100L, TimeUnit.SECONDS, () -> {
            log.info("\u6211{}\u5728{}\u83b7\u53d6\u5230\u9501{}\u4e86", new Object[]{Thread.currentThread().getName(), System.currentTimeMillis(), key});
            runnable.run();
        });
        int n = 1;
        while (!getLock) {
            try {
                Thread.sleep(20L);
            }
            catch (InterruptedException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            log.info("\u6211{}\u5728{}\u9501{}\u83b7\u53d6\u91cd\u8bd5\u4e86{}\u6b21", new Object[]{Thread.currentThread().getName(), System.currentTimeMillis(), key, n++});
            getLock = this.cache.tryLockAndRun((Object)key, 100L, TimeUnit.SECONDS, () -> {
                log.info("\u6211{}\u5728{}\u83b7\u53d6\u5230\u9501{}\u4e86", new Object[]{Thread.currentThread().getName(), System.currentTimeMillis(), key});
                runnable.run();
            });
        }
    }

    public boolean tryLockOnceAndRun(String mac, String dateStr, Integer tagId, Integer productId, Runnable runnable) {
        String key = HourSummaryLockHelper.getKey(mac, dateStr, tagId, productId);
        return this.cache.tryLockAndRun((Object)key, 100L, TimeUnit.SECONDS, () -> runnable.run());
    }

    private static String getKey(String mac, String dateStr, Integer tagId, Integer productId) {
        StringBuilder sb = new StringBuilder(mac);
        sb.append(dateStr).append("T").append(tagId != null ? tagId : "").append("P").append(productId != null ? productId : "");
        return sb.toString();
    }
}

