/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.passenger.repository.impl;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.ovopark.passenger.common.Aggregate;
import com.ovopark.passenger.common.DataObjDiffUtils;
import com.ovopark.passenger.common.Diff;
import com.ovopark.passenger.model.OccupancyCombinationAreaModel;
import com.ovopark.passenger.model.OccupancyRegionalCombinationModel;
import com.ovopark.passenger.occupancy.entity.OccupancyCombinationArea;
import com.ovopark.passenger.occupancy.entity.OccupancyRegionalCombination;
import com.ovopark.passenger.occupancy.entity.OccupancyRegionalCombinationRepository;
import com.ovopark.passenger.pojo.Authenticator;
import com.ovopark.passenger.service.OccupancyCombinationAreaService;
import com.ovopark.passenger.service.OccupancyRegionalCombinationService;
import com.ovopark.pojo.UserPojo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

@Service(value="occupancyRegionalCombinationRepository")
public class OccupancyRegionalCombinationRepositoryImpl
implements OccupancyRegionalCombinationRepository {
    @Resource
    private OccupancyRegionalCombinationService occupancyRegionalCombinationService;
    @Resource
    private OccupancyCombinationAreaService occupancyCombinationAreaService;

    public List<OccupancyRegionalCombination> listByVirtualSpaceId(Integer virtualSpaceId) {
        if (virtualSpaceId == null) {
            return Collections.emptyList();
        }
        List<OccupancyRegionalCombinationModel> combinations = this.occupancyRegionalCombinationService.listByVirtualSpaceId(virtualSpaceId);
        if (CollectionUtils.isEmpty(combinations)) {
            return Collections.emptyList();
        }
        List<Integer> combinationIds = combinations.stream().map(OccupancyRegionalCombinationModel::getId).collect(Collectors.toList());
        List<OccupancyCombinationAreaModel> areaModels = this.occupancyCombinationAreaService.listByCombinationIds(combinationIds);
        Map<Integer, List<OccupancyCombinationAreaModel>> areasMap = areaModels.stream().collect(Collectors.groupingBy(OccupancyCombinationAreaModel::getCombinationId));
        return combinations.stream().map(c -> this.combinationPo2Entity((OccupancyRegionalCombinationModel)((Object)c), (List)areasMap.get(c.getId()))).collect(Collectors.toList());
    }

    public boolean save(Aggregate<OccupancyRegionalCombination> aggregate) {
        if (aggregate == null) {
            return false;
        }
        Optional<UserPojo> userOptional = Optional.of(Authenticator.getInstance().getCurrentUser());
        Integer userId = userOptional.map(UserPojo::getId).orElse(1);
        OccupancyRegionalCombinationModel snapCombinationModel = this.getSnapCombinationModel(aggregate);
        OccupancyRegionalCombinationModel combinationModel = this.getCombinationModel(aggregate);
        Optional<Diff<OccupancyRegionalCombinationModel>> diffOptional = DataObjDiffUtils.getDiff(snapCombinationModel, combinationModel);
        diffOptional.ifPresent(diff -> {
            diff.onAdd(m -> {
                m.setCreateBy(userId);
                m.setCreateAt(new Date());
                this.occupancyRegionalCombinationService.save(m);
                List occupancyCombinationAreas = ((OccupancyRegionalCombination)aggregate.getRoot()).getOccupancyCombinationAreas();
                if (CollectionUtils.isNotEmpty((Collection)occupancyCombinationAreas)) {
                    occupancyCombinationAreas.forEach(area -> area.setCombinationId(m.getId()));
                }
            });
            diff.onChange(m -> {
                m.setUpdateBy(userId);
                m.setUpdateAt(new Date());
                this.occupancyRegionalCombinationService.updateById(m);
            });
            diff.onDelete(m -> {
                m.setUpdateBy(userId);
                m.setUpdateAt(new Date());
                m.setIsDelete(true);
                this.occupancyRegionalCombinationService.updateById(m);
            });
        });
        ArrayList<OccupancyCombinationAreaModel> snapAreaModels = new ArrayList<OccupancyCombinationAreaModel>();
        ArrayList<OccupancyCombinationAreaModel> areaModels = new ArrayList<OccupancyCombinationAreaModel>();
        this.fillAreaModels(aggregate, snapAreaModels, areaModels);
        List<Diff<OccupancyCombinationAreaModel>> areaDiffs = DataObjDiffUtils.getDiff(snapAreaModels, areaModels);
        for (Diff<OccupancyCombinationAreaModel> diff2 : areaDiffs) {
            diff2.onAdd(m -> {
                m.setCreateBy(userId);
                m.setCreateAt(new Date());
                this.occupancyCombinationAreaService.save(m);
            });
            diff2.onChange(m -> {
                m.setUpdateBy(userId);
                m.setUpdateAt(new Date());
                this.occupancyCombinationAreaService.updateById(m);
            });
            diff2.onDelete(m -> {
                m.setUpdateBy(userId);
                m.setUpdateAt(new Date());
                m.setIsDelete(true);
                this.occupancyCombinationAreaService.updateById(m);
            });
        }
        return true;
    }

    private void fillAreaModels(Aggregate<OccupancyRegionalCombination> aggregate, List<OccupancyCombinationAreaModel> snapAreaModels, List<OccupancyCombinationAreaModel> areaModels) {
        OccupancyRegionalCombination root;
        List occupancyCombinationAreas;
        OccupancyRegionalCombination snapshot = (OccupancyRegionalCombination)aggregate.getSnapshot();
        if (snapshot != null && CollectionUtils.isNotEmpty((Collection)(occupancyCombinationAreas = snapshot.getOccupancyCombinationAreas()))) {
            occupancyCombinationAreas.forEach(x -> {
                OccupancyCombinationAreaModel model = OccupancyRegionalCombinationRepositoryImpl.getOccupancyCombinationAreaModel(x);
                snapAreaModels.add(model);
            });
        }
        if ((root = (OccupancyRegionalCombination)aggregate.getRoot()) != null && CollectionUtils.isNotEmpty((Collection)(occupancyCombinationAreas = root.getOccupancyCombinationAreas()))) {
            occupancyCombinationAreas.forEach(x -> {
                OccupancyCombinationAreaModel model = OccupancyRegionalCombinationRepositoryImpl.getOccupancyCombinationAreaModel(x);
                areaModels.add(model);
            });
        }
    }

    private static OccupancyCombinationAreaModel getOccupancyCombinationAreaModel(OccupancyCombinationArea x) {
        OccupancyCombinationAreaModel model = new OccupancyCombinationAreaModel();
        model.setId(x.getId());
        model.setCombinationId(x.getCombinationId());
        model.setRegionalPlanId(x.getRegionalPlanId());
        model.setProductAreaId(x.getProductAreaId());
        model.setAreaType(x.getAreaType());
        model.setIsDelete(x.getIsDelete());
        return model;
    }

    private OccupancyRegionalCombinationModel getCombinationModel(Aggregate<OccupancyRegionalCombination> aggregate) {
        OccupancyRegionalCombination combination = (OccupancyRegionalCombination)aggregate.getRoot();
        return OccupancyRegionalCombinationRepositoryImpl.getOccupancyRegionalCombinationModel(combination);
    }

    private static OccupancyRegionalCombinationModel getOccupancyRegionalCombinationModel(OccupancyRegionalCombination combination) {
        if (combination == null) {
            return null;
        }
        OccupancyRegionalCombinationModel model = new OccupancyRegionalCombinationModel();
        model.setId(combination.getId());
        model.setName(combination.getName());
        model.setTopCoords(combination.getTopCoords());
        model.setLeftCoords(combination.getLeftCoords());
        model.setWidth(combination.getWidth());
        model.setHeight(combination.getHeight());
        model.setVirtualSpaceId(combination.getVirtualSpaceId());
        model.setIsDelete(combination.getIsDelete());
        return model;
    }

    private OccupancyRegionalCombinationModel getSnapCombinationModel(Aggregate<OccupancyRegionalCombination> aggregate) {
        OccupancyRegionalCombination combination = (OccupancyRegionalCombination)aggregate.getSnapshot();
        return OccupancyRegionalCombinationRepositoryImpl.getOccupancyRegionalCombinationModel(combination);
    }

    public boolean save(OccupancyRegionalCombination root) {
        return false;
    }

    public Aggregate<OccupancyRegionalCombination> get(Integer id) {
        if (id == null) {
            return null;
        }
        OccupancyRegionalCombinationModel combination = (OccupancyRegionalCombinationModel)((Object)this.occupancyRegionalCombinationService.getById(id));
        if (combination == null) {
            return null;
        }
        List areas = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.occupancyCombinationAreaService.lambdaQuery().eq(OccupancyCombinationAreaModel::getCombinationId, (Object)combination.getId())).eq(OccupancyCombinationAreaModel::getIsDelete, (Object)false)).list();
        return Aggregate.of((Serializable)this.combinationPo2Entity(combination, areas));
    }

    private OccupancyRegionalCombination combinationPo2Entity(OccupancyRegionalCombinationModel po, List<OccupancyCombinationAreaModel> areas) {
        if (po == null) {
            return null;
        }
        OccupancyRegionalCombination entity = new OccupancyRegionalCombination();
        entity.setId(po.getId());
        entity.setName(po.getName());
        entity.setTopCoords(po.getTopCoords());
        entity.setLeftCoords(po.getLeftCoords());
        entity.setWidth(po.getWidth());
        entity.setHeight(po.getHeight());
        entity.setVirtualSpaceId(po.getVirtualSpaceId());
        entity.setIsDelete(po.getIsDelete());
        if (CollectionUtils.isNotEmpty(areas)) {
            ArrayList<OccupancyCombinationArea> occupancyCombinationAreas = new ArrayList<OccupancyCombinationArea>();
            for (OccupancyCombinationAreaModel area : areas) {
                OccupancyCombinationArea combinationArea = new OccupancyCombinationArea();
                combinationArea.setId(area.getId());
                combinationArea.setCombinationId(area.getCombinationId());
                combinationArea.setRegionalPlanId(area.getRegionalPlanId());
                combinationArea.setProductAreaId(area.getProductAreaId());
                combinationArea.setAreaType(area.getAreaType());
                combinationArea.setIsDelete(area.getIsDelete());
                occupancyCombinationAreas.add(combinationArea);
            }
            entity.setOccupancyCombinationAreas(occupancyCombinationAreas);
        } else {
            entity.setOccupancyCombinationAreas(new ArrayList());
        }
        return entity;
    }

    public void removeByCombinationAreaIds(List<Integer> combinationAreaIds) {
        if (CollectionUtils.isEmpty(combinationAreaIds)) {
            return;
        }
        Integer userId = Optional.ofNullable(Authenticator.getInstance().getCurrentUser()).map(UserPojo::getId).orElse(1);
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.occupancyCombinationAreaService.lambdaUpdate().set(OccupancyCombinationAreaModel::getIsDelete, (Object)true)).set(OccupancyCombinationAreaModel::getUpdateBy, (Object)userId)).set(OccupancyCombinationAreaModel::getUpdateAt, (Object)new Date())).in(OccupancyCombinationAreaModel::getId, combinationAreaIds)).update();
    }
}

