/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.passenger.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.google.common.collect.Lists;
import com.ovopark.passenger.mapper.ActionMapper;
import com.ovopark.passenger.model.ActionModel;
import com.ovopark.passenger.service.ActionService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ActionServiceImpl
extends ServiceImpl<ActionMapper, ActionModel>
implements ActionService {
    @Autowired
    private ActionMapper actionMapper;

    @Override
    public List<ActionModel> listCompleteAction(List<String> macs, Date startTime, Date endTime, Integer deviceGroupId, String sessionId) {
        ActionModel next;
        if (CollectionUtils.isEmpty(macs) || startTime == null || endTime == null || StringUtils.isBlank((CharSequence)sessionId) || deviceGroupId == null) {
            return new ArrayList<ActionModel>();
        }
        QueryWrapper wrapper = new QueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.lambda().eq(ActionModel::getSessionId, (Object)sessionId)).between(ActionModel::getRecordTime, (Object)startTime, (Object)endTime)).eq(ActionModel::getDeviceGroupId, (Object)deviceGroupId)).in(ActionModel::getMac, macs)).in(ActionModel::getProductType, (Collection)Lists.newArrayList((Object[])new Integer[]{1, 2}))).likeRight(ActionModel::getActionName, (Object)"enter")).orderByDesc(ActionModel::getRecordTime);
        wrapper.last("limit 1");
        ActionModel one = (ActionModel)((Object)this.getOne((Wrapper)wrapper));
        if (one == null) {
            return new ArrayList<ActionModel>();
        }
        wrapper = new QueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.lambda().eq(ActionModel::getSessionId, (Object)sessionId)).between(ActionModel::getRecordTime, (Object)one.getRecordTime(), (Object)endTime)).eq(ActionModel::getDeviceGroupId, (Object)deviceGroupId)).in(ActionModel::getMac, macs)).orderByAsc(ActionModel::getRecordTime);
        List<ActionModel> res = this.list((Wrapper)wrapper);
        Iterator iterator = res.iterator();
        while (iterator.hasNext() && !(next = (ActionModel)((Object)iterator.next())).getId().equals(one.getId())) {
            iterator.remove();
        }
        res = res.stream().filter(actionModel -> actionModel.getProductType() == 0).collect(Collectors.toList());
        res.add(0, one);
        return res;
    }

    @Override
    public List<ActionModel> getActionList(List<Integer> depIds, Date startTime, Date endTime, Integer timeType, Integer startHour, Integer endHour) {
        List<ActionModel> res = new ArrayList<ActionModel>();
        if (CollectionUtils.isEmpty(depIds) || startTime == null || endTime == null) {
            return res;
        }
        res = this.actionMapper.listActions(depIds, startTime, endTime, timeType, startHour, endHour);
        return res;
    }
}

