/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.passenger.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ovopark.passenger.mapper.CustomerGroupPushMapper;
import com.ovopark.passenger.model.CustomerGroupPushModel;
import com.ovopark.passenger.service.CustomerGroupPushService;
import com.ovopark.passenger.util.TimeUtils;
import java.util.Date;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="customerGroupPushService")
public class CustomerGroupPushServiceImpl
extends ServiceImpl<CustomerGroupPushMapper, CustomerGroupPushModel>
implements CustomerGroupPushService {
    private static final Logger log = LoggerFactory.getLogger(CustomerGroupPushServiceImpl.class);

    @Override
    public boolean updateCustomerGroupPush(Integer enterpriseId, Integer depId, Date recordTime) {
        Date realTime;
        Date realHourDate;
        Date realPreviousHourDate;
        if (enterpriseId == null || depId == null || recordTime == null) {
            return false;
        }
        Date recordHourDate = TimeUtils.getHourDate(recordTime);
        if (Objects.equals(recordHourDate, realPreviousHourDate = TimeUtils.reduceOneHour(realHourDate = TimeUtils.getHourDate(realTime = new Date()))) && TimeUtils.getMinute(realTime) < 6) {
            this.merge(enterpriseId, depId, recordHourDate, realPreviousHourDate);
            return true;
        }
        this.merge(enterpriseId, depId, recordHourDate, realHourDate);
        return true;
    }

    private void merge(Integer enterpriseId, Integer depId, Date recordTime, Date realTime) {
        CustomerGroupPushModel po = this.getUniquePo(enterpriseId, depId, recordTime, realTime);
        if (po == null) {
            po = new CustomerGroupPushModel().setEnterpriseId(enterpriseId).setDepId(depId).setRecordTime(recordTime).setRealTime(realTime);
            try {
                this.save((Object)po);
            }
            catch (Exception e) {
                log.warn("\u4fdd\u5b58\u5931\u8d25", (Throwable)e);
            }
        }
    }

    private CustomerGroupPushModel getUniquePo(Integer enterpriseId, Integer depId, Date recordTime, Date realTime) {
        QueryWrapper wrapper = new QueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.lambda().eq(CustomerGroupPushModel::getEnterpriseId, (Object)enterpriseId)).eq(CustomerGroupPushModel::getDepId, (Object)depId)).eq(CustomerGroupPushModel::getRecordTime, (Object)recordTime)).eq(CustomerGroupPushModel::getRealTime, (Object)realTime);
        return (CustomerGroupPushModel)((Object)this.getOne((Wrapper)wrapper));
    }
}

