/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.passenger.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ovopark.passenger.mapper.DepCommonConfigMapper;
import com.ovopark.passenger.mapper.DepDictConfigMapper;
import com.ovopark.passenger.model.DepCommonConfigModel;
import com.ovopark.passenger.model.DepDictConfigModel;
import com.ovopark.passenger.pojo.dto.DepCommonConfigDto;
import com.ovopark.passenger.pojo.enums.CommonConfigKeyEnum;
import com.ovopark.passenger.pojo.enums.TimeUnitCommonEnum;
import com.ovopark.passenger.pojo.vo.DepCommonConfigVo;
import com.ovopark.passenger.pojo.vo.DepValidConfigVo;
import com.ovopark.passenger.pojo.vo.ValidStayTimeConfigVo;
import com.ovopark.passenger.pojo.vo.WanderingStayTimeConfigDetailVo;
import com.ovopark.passenger.service.DepCommonConfigService;
import com.ovopark.passenger.service.DepDictConfigService;
import com.ovopark.passenger.service.PassengerCommonConfigService;
import com.ovopark.passenger.support.User;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DepCommonConfigServiceImpl
extends ServiceImpl<DepCommonConfigMapper, DepCommonConfigModel>
implements DepCommonConfigService {
    @Resource
    private PassengerCommonConfigService commonConfigService;
    @Resource
    private DepDictConfigService depDictConfigService;
    @Resource
    private DepDictConfigMapper depDictConfigMapper;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveDepCommonConfigDto(User user, DepCommonConfigDto dto) {
        DepDictConfigModel needSaveDepDictConfigModel;
        LambdaUpdateWrapper lambdaUpdateWrapper;
        DepDictConfigModel existDepDictConfigModel;
        List models;
        Integer depId = dto.getDepId();
        List depIdConfigs = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(DepCommonConfigModel::getConfigKey, (Object)dto.getConfigKey())).eq(DepCommonConfigModel::getDepId, (Object)depId)).list();
        if (CollectionUtils.isNotEmpty((Collection)depIdConfigs)) {
            this.removeByIds(depIdConfigs.stream().map(DepCommonConfigModel::getId).collect(Collectors.toList()));
        }
        Date now = new Date();
        if (dto.getEnableEnterprise().booleanValue() && CollectionUtils.isNotEmpty((Collection)(models = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(DepCommonConfigModel::getEnterpriseId, (Object)user.getEnterpriseId())).eq(DepCommonConfigModel::getConfigKey, (Object)dto.getConfigKey())).list()))) {
            for (DepCommonConfigModel model : models) {
                model.setConfigValue(dto.getConfigValue());
                model.setEnableEnterprise(true);
                model.setUpdateUserId(user.getId());
                model.setUpdateTime(now);
                this.updateById((Object)model);
            }
        }
        DepCommonConfigModel model = new DepCommonConfigModel();
        model.setDepId(depId);
        model.setConfigKey(dto.getConfigKey());
        model.setConfigValue(dto.getConfigValue());
        model.setEnableEnterprise(dto.getEnableEnterprise());
        model.setEnterpriseId(user.getEnterpriseId());
        model.setCreateUserId(user.getId());
        model.setCreateTime(now);
        this.save((Object)model);
        if (dto.getEnableEnterprise().booleanValue()) {
            existDepDictConfigModel = (DepDictConfigModel)((Object)((LambdaQueryChainWrapper)this.depDictConfigService.lambdaQuery().eq(DepDictConfigModel::getEnterpriseId, (Object)user.getEnterpriseId())).one());
            if (Objects.nonNull((Object)existDepDictConfigModel)) {
                this.getDepDictConfigModel(existDepDictConfigModel, dto);
                lambdaUpdateWrapper = null;
                if (StringUtils.equals((CharSequence)dto.getConfigKey(), (CharSequence)CommonConfigKeyEnum.DEP_VALID_PASSENGER_FLOW.getKey())) {
                    lambdaUpdateWrapper = (LambdaUpdateWrapper)Wrappers.lambdaUpdate().set(DepDictConfigModel::getValidFlowStayTime, (Object)existDepDictConfigModel.getValidFlowStayTime());
                } else if (StringUtils.equals((CharSequence)dto.getConfigKey(), (CharSequence)CommonConfigKeyEnum.DEP_WANDERING_PASSENGER_FLOW.getKey())) {
                    lambdaUpdateWrapper = (LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().set(DepDictConfigModel::getHoldStayTime, (Object)existDepDictConfigModel.getHoldStayTime())).set(DepDictConfigModel::getWanderingLeftStayTime, (Object)existDepDictConfigModel.getWanderingLeftStayTime())).set(DepDictConfigModel::getWanderingRightStayTime, (Object)existDepDictConfigModel.getWanderingRightStayTime())).set(DepDictConfigModel::getLikeLeftStayTime, (Object)existDepDictConfigModel.getLikeLeftStayTime())).set(DepDictConfigModel::getLikeRightStayTime, (Object)existDepDictConfigModel.getLikeRightStayTime())).set(DepDictConfigModel::getWantBuyLeftStayTime, (Object)existDepDictConfigModel.getWantBuyLeftStayTime())).set(DepDictConfigModel::getWantBuyRightStayTime, (Object)existDepDictConfigModel.getWantBuyRightStayTime());
                }
                this.depDictConfigService.update(null, (Wrapper)lambdaUpdateWrapper.eq(DepDictConfigModel::getEnterpriseId, (Object)user.getEnterpriseId()));
            } else {
                needSaveDepDictConfigModel = new DepDictConfigModel();
                needSaveDepDictConfigModel.setEnterpriseId(user.getEnterpriseId());
                this.getDepDictConfigModel(needSaveDepDictConfigModel, dto);
                this.depDictConfigService.save((Object)needSaveDepDictConfigModel);
            }
            DepDictConfigModel depDictConfigModel = (DepDictConfigModel)((Object)((LambdaQueryChainWrapper)this.depDictConfigService.lambdaQuery().eq(DepDictConfigModel::getDepId, (Object)dto.getDepId())).one());
            if (Objects.nonNull((Object)depDictConfigModel)) {
                if (StringUtils.equals((CharSequence)dto.getConfigKey(), (CharSequence)CommonConfigKeyEnum.DEP_VALID_PASSENGER_FLOW.getKey())) {
                    this.depDictConfigMapper.updateValidFlowStayTimeByDepId(depId);
                } else if (StringUtils.equals((CharSequence)dto.getConfigKey(), (CharSequence)CommonConfigKeyEnum.DEP_WANDERING_PASSENGER_FLOW.getKey())) {
                    this.depDictConfigMapper.updateWanderingByDepId(depId);
                }
            }
        } else {
            existDepDictConfigModel = (DepDictConfigModel)((Object)((LambdaQueryChainWrapper)this.depDictConfigService.lambdaQuery().eq(DepDictConfigModel::getDepId, (Object)dto.getDepId())).one());
            if (Objects.nonNull((Object)existDepDictConfigModel)) {
                this.getDepDictConfigModel(existDepDictConfigModel, dto);
                lambdaUpdateWrapper = null;
                if (StringUtils.equals((CharSequence)dto.getConfigKey(), (CharSequence)CommonConfigKeyEnum.DEP_VALID_PASSENGER_FLOW.getKey())) {
                    lambdaUpdateWrapper = (LambdaUpdateWrapper)Wrappers.lambdaUpdate().set(DepDictConfigModel::getValidFlowStayTime, (Object)existDepDictConfigModel.getValidFlowStayTime());
                } else if (StringUtils.equals((CharSequence)dto.getConfigKey(), (CharSequence)CommonConfigKeyEnum.DEP_WANDERING_PASSENGER_FLOW.getKey())) {
                    lambdaUpdateWrapper = (LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().set(DepDictConfigModel::getHoldStayTime, (Object)existDepDictConfigModel.getHoldStayTime())).set(DepDictConfigModel::getWanderingLeftStayTime, (Object)existDepDictConfigModel.getWanderingLeftStayTime())).set(DepDictConfigModel::getWanderingRightStayTime, (Object)existDepDictConfigModel.getWanderingRightStayTime())).set(DepDictConfigModel::getLikeLeftStayTime, (Object)existDepDictConfigModel.getLikeLeftStayTime())).set(DepDictConfigModel::getLikeRightStayTime, (Object)existDepDictConfigModel.getLikeRightStayTime())).set(DepDictConfigModel::getWantBuyLeftStayTime, (Object)existDepDictConfigModel.getWantBuyLeftStayTime())).set(DepDictConfigModel::getWantBuyRightStayTime, (Object)existDepDictConfigModel.getWantBuyRightStayTime());
                }
                this.depDictConfigService.update(null, (Wrapper)lambdaUpdateWrapper.eq(DepDictConfigModel::getDepId, (Object)dto.getDepId()));
            } else {
                needSaveDepDictConfigModel = new DepDictConfigModel();
                needSaveDepDictConfigModel.setDepId(dto.getDepId());
                this.getDepDictConfigModel(needSaveDepDictConfigModel, dto);
                this.depDictConfigService.save((Object)needSaveDepDictConfigModel);
            }
        }
    }

    private void getDepDictConfigModel(DepDictConfigModel depDictConfigModel, DepCommonConfigDto dto) {
        WanderingStayTimeConfigDetailVo wanderingVo;
        if (StringUtils.equals((CharSequence)dto.getConfigKey(), (CharSequence)CommonConfigKeyEnum.DEP_VALID_PASSENGER_FLOW.getKey())) {
            DepValidConfigVo depValidConfigVo = (DepValidConfigVo)JSONObject.parseObject((String)dto.getConfigValue(), DepValidConfigVo.class);
            if (Objects.nonNull(depValidConfigVo) && Objects.nonNull(depValidConfigVo.getStayTime())) {
                depDictConfigModel.setValidFlowStayTime(depValidConfigVo.getValidFlowEnable() != false ? depValidConfigVo.getStayTime() : null);
            }
        } else if (StringUtils.equals((CharSequence)dto.getConfigKey(), (CharSequence)CommonConfigKeyEnum.DEP_WANDERING_PASSENGER_FLOW.getKey()) && Objects.nonNull(wanderingVo = (WanderingStayTimeConfigDetailVo)JSONObject.parseObject((String)dto.getConfigValue(), WanderingStayTimeConfigDetailVo.class)) && Objects.nonNull(wanderingVo.getHoldStayTime()) && Objects.nonNull(wanderingVo.getWanderingLeftStayTime()) && Objects.nonNull(wanderingVo.getWanderingRightStayTime()) && Objects.nonNull(wanderingVo.getLikeLeftStayTime()) && Objects.nonNull(wanderingVo.getLikeRightStayTime()) && Objects.nonNull(wanderingVo.getWantBuyLeftStayTime()) && Objects.nonNull(wanderingVo.getWantBuyRightStayTime())) {
            depDictConfigModel.setHoldStayTime(wanderingVo.getHoldStayTime()).setWanderingLeftStayTime(wanderingVo.getWanderingLeftStayTime()).setWanderingRightStayTime(wanderingVo.getWanderingRightStayTime()).setLikeLeftStayTime(wanderingVo.getLikeLeftStayTime()).setLikeRightStayTime(wanderingVo.getLikeRightStayTime()).setWantBuyLeftStayTime(wanderingVo.getWantBuyLeftStayTime()).setWantBuyRightStayTime(wanderingVo.getWantBuyRightStayTime());
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public DepCommonConfigVo getDepCommonConfigDto(Integer enterpriseId, Integer depId, String configKey) {
        DepCommonConfigVo result = new DepCommonConfigVo();
        if (Objects.isNull(depId) || StringUtils.isBlank((CharSequence)configKey)) {
            return result;
        }
        DepCommonConfigModel model = (DepCommonConfigModel)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(DepCommonConfigModel::getConfigKey, (Object)configKey)).eq(DepCommonConfigModel::getDepId, (Object)depId)).one());
        if (Objects.isNull((Object)model)) {
            List enterpriseConfigs = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(DepCommonConfigModel::getConfigKey, (Object)configKey)).eq(DepCommonConfigModel::getEnterpriseId, (Object)enterpriseId)).list();
            if (CollectionUtils.isNotEmpty((Collection)enterpriseConfigs)) {
                Optional<DepCommonConfigModel> optional = enterpriseConfigs.stream().filter(DepCommonConfigModel::getEnableEnterprise).findFirst();
                boolean present = optional.isPresent();
                if (present) {
                    model = optional.get();
                    result.setDepId(depId).setConfigKey(model.getConfigKey()).setConfigValue(model.getConfigValue()).setEnableEnterprise(model.getEnableEnterprise());
                } else {
                    result = this.getDefaultDepCommonConfigVo(enterpriseId, depId, configKey);
                }
            } else {
                result = this.getDefaultDepCommonConfigVo(enterpriseId, depId, configKey);
            }
        } else {
            result.setDepId(depId).setConfigKey(model.getConfigKey()).setConfigValue(model.getConfigValue()).setEnableEnterprise(model.getEnableEnterprise());
        }
        return result;
    }

    private DepCommonConfigVo getDefaultDepCommonConfigVo(Integer enterpriseId, Integer depId, String configKey) {
        DepCommonConfigVo result = new DepCommonConfigVo();
        if (CommonConfigKeyEnum.DEP_WANDERING_PASSENGER_FLOW.getKey().equals(configKey)) {
            WanderingStayTimeConfigDetailVo vo = new WanderingStayTimeConfigDetailVo();
            vo.setHoldStayTime(5).setWanderingLeftStayTime(11).setWanderingRightStayTime(60).setLikeLeftStayTime(61).setLikeRightStayTime(300).setWantBuyLeftStayTime(301).setWantBuyRightStayTime(99999);
            result.setDepId(depId).setConfigKey(configKey).setConfigValue(JSONObject.toJSONString((Object)vo)).setEnableEnterprise(true);
        } else if (CommonConfigKeyEnum.DEP_VALID_PASSENGER_FLOW.getKey().equals(configKey)) {
            String value = this.commonConfigService.getEnterpriseIdCommonConfig(enterpriseId, CommonConfigKeyEnum.VALID_PASSENGER_FLOW.getKey());
            DepValidConfigVo vo = new DepValidConfigVo();
            if (StringUtils.isNotBlank((CharSequence)value)) {
                ValidStayTimeConfigVo config = (ValidStayTimeConfigVo)JSONObject.parseObject((String)value, ValidStayTimeConfigVo.class);
                if (Objects.nonNull(config) && Objects.nonNull(config.getStayTime()) && Objects.nonNull(config.getTimeUnitType())) {
                    Integer stayTime = config.getStayTime();
                    Integer timeUnitType = config.getTimeUnitType();
                    vo.setValidFlowEnable(true).setStayTime(Objects.equals(timeUnitType, TimeUnitCommonEnum.SECOND.getType()) ? stayTime : stayTime * 60);
                    result.setEnableEnterprise(true);
                } else {
                    vo.setValidFlowEnable(false);
                    result.setEnableEnterprise(false);
                }
            } else {
                vo.setValidFlowEnable(false);
                result.setEnableEnterprise(false);
            }
            result.setDepId(depId).setConfigKey(configKey).setConfigValue(JSONObject.toJSONString((Object)vo));
        }
        return result;
    }

    @Override
    public <T> T getConfigVo(Integer enterpriseId, Integer depId, String configKey, Class<T> clazz) {
        try {
            DepCommonConfigVo depCommonConfigVo = this.getDepCommonConfigDto(enterpriseId, depId, configKey);
            if (StringUtils.isNotBlank((CharSequence)depCommonConfigVo.getConfigValue())) {
                return (T)JSONObject.parseObject((String)depCommonConfigVo.getConfigValue(), clazz);
            }
            return clazz.newInstance();
        }
        catch (Exception e) {
            try {
                return clazz.newInstance();
            }
            catch (Exception ex) {
                throw new RuntimeException("Failed to create instance", ex);
            }
        }
    }

    @Override
    public <T> Map<Integer, T> getDepIdsConfigVo(Integer enterpriseId, List<Integer> depIds, String configKey, Class<T> clazz) {
        HashMap<Integer, T> result = new HashMap<Integer, T>();
        if (Objects.isNull(enterpriseId) || CollectionUtils.isEmpty(depIds) || StringUtils.isBlank((CharSequence)configKey) || Objects.isNull(clazz)) {
            return result;
        }
        for (Integer depId : depIds) {
            T configVo = this.getConfigVo(enterpriseId, depId, configKey, clazz);
            result.put(depId, configVo);
        }
        return result;
    }
}

