/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.passenger.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ovopark.device.cloud.common.model.mo.DeviceStatusMo;
import com.ovopark.passenger.core.entity.DeviceFlowTag;
import com.ovopark.passenger.feign.DeviceFeign;
import com.ovopark.passenger.mapper.DeviceFlowTagMapper;
import com.ovopark.passenger.model.DeviceFlowTagModel;
import com.ovopark.passenger.model.ShopFlowTagModel;
import com.ovopark.passenger.pojo.dto.StoreDeviceNumDto;
import com.ovopark.passenger.pojo.dto.StoreTagDeviceNumDto;
import com.ovopark.passenger.pojo.dto.TagStoreDeviceNumDto;
import com.ovopark.passenger.service.DeviceFlowTagService;
import com.ovopark.passenger.service.ShopFlowTagService;
import com.ovopark.pojo.DeviceFlowTagFeignVo;
import com.ovopark.pojo.DeviceFlowTagPojo;
import com.ovopark.pojo.ShopFlowTagPojo;
import com.ovopark.pojo.dto.DeviceFlowTagDto;
import com.ovopark.util.FlowTagUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="deviceFlowTagService")
public class DeviceFlowTagServiceImpl
extends ServiceImpl<DeviceFlowTagMapper, DeviceFlowTagModel>
implements DeviceFlowTagService {
    private static final Logger log = LoggerFactory.getLogger(DeviceFlowTagServiceImpl.class);
    @Resource
    private DeviceFlowTagMapper deviceFlowTagMapper;
    @Resource
    private DeviceFeign deviceFeign;
    @Resource
    private ShopFlowTagService shopFlowTagService;
    @Resource
    private MessageSource messageSource;

    @Override
    public List<DeviceFlowTagModel> listAllByTagId(Integer tagId) {
        if (tagId == null) {
            return new ArrayList<DeviceFlowTagModel>();
        }
        return ((LambdaQueryChainWrapper)this.lambdaQuery().eq(DeviceFlowTagModel::getTagId, (Object)tagId)).list();
    }

    @Override
    public void saveOrUpdateDomains(List<DeviceFlowTag> domains) {
        domains.stream().map(d -> this.deviceFlowTagDomain2Po((DeviceFlowTag)d)).forEach(arg_0 -> ((DeviceFlowTagServiceImpl)this).saveOrUpdate(arg_0));
    }

    public DeviceFlowTagModel deviceFlowTagDomain2Po(DeviceFlowTag dto) {
        if (dto == null) {
            return null;
        }
        DeviceFlowTagModel po = new DeviceFlowTagModel();
        po.setId(dto.getId()).setDeviceId(dto.getDeviceId()).setTagId(dto.getTagId()).setIsDelete(Optional.ofNullable(dto.getIsDelete()).map(b -> b != false ? 1 : 0).orElse(null)).setIsPrimaryPort(Optional.ofNullable(dto.getIsPrimaryPort()).map(b -> b != false ? 1 : 0).orElse(null)).setDepId(dto.getDepId()).setMac(dto.getMac()).setDataType(dto.getDataType()).setCreateTime(dto.getCreateTime()).setCreateUserId(dto.getCreateUserId()).setDeviceName(dto.getDeviceName()).setOperateType(dto.getOperateType()).setProductId(dto.getProductId()).setDeleteTime(dto.getDeleteTime()).setDeviceGroupId(dto.getDeviceGroupId());
        return po;
    }

    @Override
    public List<DeviceFlowTagPojo> findDeviceFlowTagsByDeviceId(Integer deviceId, Integer dataType) {
        List<Map<String, Object>> list = this.deviceFlowTagMapper.findDeviceFlowTagsMapByDeviceId(deviceId, dataType);
        ArrayList<DeviceFlowTagPojo> result = new ArrayList<DeviceFlowTagPojo>();
        for (Map<String, Object> map : list) {
            DeviceFlowTagPojo bo = new DeviceFlowTagPojo();
            bo.setId(map.get("id") == null ? null : Integer.valueOf(Integer.parseInt(map.get("id").toString())));
            bo.setDeviceId(map.get("deviceId") == null ? null : Integer.valueOf(Integer.parseInt(map.get("deviceId").toString())));
            bo.setTagId(map.get("tagId") == null ? null : Integer.valueOf(Integer.parseInt(map.get("tagId").toString())));
            bo.setTagName(map.get("tagName") == null ? null : map.get("tagName").toString());
            bo.setIsDelete(map.get("isDelete") == null ? null : Integer.valueOf(Integer.parseInt(map.get("isDelete").toString())));
            bo.setIsPrimaryPort(map.get("isPrimaryPort") == null ? null : Integer.valueOf(Integer.parseInt(map.get("isPrimaryPort").toString())));
            bo.setDataType(map.get("dataType") == null ? null : Integer.valueOf(Integer.parseInt(map.get("dataType").toString())));
            bo.setDepId(map.get("depId") == null ? null : Integer.valueOf(Integer.parseInt(map.get("depId").toString())));
            result.add(bo);
        }
        return result;
    }

    @Override
    public List<DeviceFlowTagPojo> findTagByMac(String mac, Integer depId, Integer dataType) {
        return this.deviceFlowTagMapper.findTagByMac(mac, depId, dataType);
    }

    @Override
    public List<DeviceFlowTagPojo> getDeviceFlowTagsByDepId(Integer depId, Integer dataType) {
        List<DeviceFlowTagPojo> list = this.deviceFlowTagMapper.getDeviceFlowTagsByDepId(depId, dataType);
        List<DeviceFlowTagPojo> reList = this.getDeviceFlowTagPojos(list);
        return reList;
    }

    @Override
    public List<DeviceFlowTagPojo> getDeviceFlowTagByDeviceId(Integer deviceId) {
        List<Map<String, Object>> list = this.deviceFlowTagMapper.getDeviceFlowTagByDeviceId(deviceId);
        ArrayList<DeviceFlowTagPojo> result = new ArrayList<DeviceFlowTagPojo>();
        for (Map<String, Object> map : list) {
            DeviceFlowTagPojo bo = new DeviceFlowTagPojo();
            bo.setId(map.get("id") == null ? null : Integer.valueOf(Integer.parseInt(map.get("id").toString())));
            bo.setDeviceId(map.get("deviceId") == null ? null : Integer.valueOf(Integer.parseInt(map.get("deviceId").toString())));
            bo.setTagId(map.get("tagId") == null ? null : Integer.valueOf(Integer.parseInt(map.get("tagId").toString())));
            bo.setTagName(map.get("tagName") == null ? null : map.get("tagName").toString());
            bo.setIsDelete(map.get("isDelete") == null ? null : Integer.valueOf(Integer.parseInt(map.get("isDelete").toString())));
            bo.setIsPrimaryPort(map.get("isPrimaryPort") == null ? null : Integer.valueOf(Integer.parseInt(map.get("isPrimaryPort").toString())));
            bo.setDataType(map.get("dataType") == null ? null : Integer.valueOf(Integer.parseInt(map.get("dataType").toString())));
            result.add(bo);
        }
        return result;
    }

    @Override
    public DeviceFlowTagPojo getDeviceFlowTagByTagIdAndDeviceId(Integer tagId, Integer deviceId) {
        DeviceFlowTagPojo pojo;
        DeviceStatusMo status;
        List<DeviceFlowTagPojo> deviceFlowTags = this.deviceFlowTagMapper.getDeviceFlowTagByTagIdAndDeviceId(tagId, deviceId);
        if (!CollectionUtils.isEmpty(deviceFlowTags) && Objects.nonNull(status = this.deviceFeign.getDeviceStatusById((pojo = deviceFlowTags.get(0)).getDeviceId())) && status.getIsDelete() == 0) {
            pojo.setDeviceName(status.getDeviceName());
            return pojo;
        }
        return null;
    }

    @Override
    public List<DeviceFlowTagPojo> getValidDeviceFlowTagsByTagId(Integer tagId) {
        List<DeviceFlowTagPojo> list = this.deviceFlowTagMapper.getValidDeviceFlowTagsByTagId(tagId);
        List<DeviceFlowTagPojo> reList = this.getDeviceFlowTagPojos(list);
        return reList;
    }

    private List<DeviceFlowTagPojo> getDeviceFlowTagPojos(List<DeviceFlowTagPojo> list) {
        List<DeviceStatusMo> deviceStatusMos = this.deviceFeign.getDeviceStatusListByIds(list.stream().map(DeviceFlowTagPojo::getDeviceId).collect(Collectors.toList()));
        Map<Integer, String> idNameMap = deviceStatusMos.stream().filter(a -> a.getIsDelete() == 0).collect(Collectors.toMap(a -> a.getId(), a -> a.getDeviceName()));
        ArrayList<DeviceFlowTagPojo> reList = new ArrayList<DeviceFlowTagPojo>();
        for (DeviceFlowTagPojo pojo : list) {
            if (!idNameMap.keySet().contains(pojo.getDeviceId())) continue;
            pojo.setDeviceName(idNameMap.get(pojo.getDeviceId()));
            reList.add(pojo);
        }
        return reList;
    }

    @Override
    public List<DeviceFlowTagPojo> getDeviceFlowTagsByTagId(Integer tagId) {
        List deviceFlowTags = ((LambdaQueryChainWrapper)this.lambdaQuery().eq(DeviceFlowTagModel::getTagId, (Object)tagId)).list();
        ArrayList<DeviceFlowTagPojo> pojos = new ArrayList<DeviceFlowTagPojo>();
        if (!CollectionUtils.isEmpty((Collection)deviceFlowTags)) {
            for (DeviceFlowTagModel tag : deviceFlowTags) {
                DeviceFlowTagPojo pojo = new DeviceFlowTagPojo();
                BeanUtils.copyProperties((Object)((Object)tag), (Object)pojo);
                pojos.add(pojo);
            }
        }
        return pojos;
    }

    @Override
    public List<DeviceFlowTagDto> getDeviceFlowTagsByDeviceIds(List<Integer> deviceIds) {
        if (CollectionUtils.isEmpty(deviceIds)) {
            return new ArrayList<DeviceFlowTagDto>();
        }
        return this.deviceFlowTagMapper.getDeviceFlowTagsByDeviceIds(deviceIds);
    }

    @Override
    public List<DeviceFlowTagPojo> getDeviceFlowTagsByTagIds(List<Integer> tagIds) {
        List deviceFlowTags = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(DeviceFlowTagModel::getTagId, tagIds)).eq(DeviceFlowTagModel::getIsDelete, (Object)0)).list();
        ArrayList<DeviceFlowTagPojo> res = new ArrayList<DeviceFlowTagPojo>();
        if (!CollectionUtils.isEmpty((Collection)deviceFlowTags)) {
            for (DeviceFlowTagModel tag : deviceFlowTags) {
                DeviceFlowTagPojo pojo = new DeviceFlowTagPojo();
                BeanUtils.copyProperties((Object)((Object)tag), (Object)pojo);
                res.add(pojo);
            }
        }
        return res;
    }

    @Override
    public List<DeviceFlowTagPojo> listValidDeviceFlowTagByMac(String mac) {
        List<DeviceFlowTagPojo> list = this.deviceFlowTagMapper.listValidDeviceFlowTagByMac(mac);
        List<DeviceFlowTagPojo> reList = this.getDeviceFlowTagPojos(list);
        return reList;
    }

    @Override
    public List<DeviceFlowTagPojo> listUnboundDeviceFlowTagByDepId(Integer depId) {
        return this.deviceFlowTagMapper.listUnboundDeviceFlowTagByDepId(depId);
    }

    @Override
    public void deleteByDeviceIdAndProductIds(Integer deviceId, List<Integer> productIds, Integer userId, String deviceName) {
        List deleteDeviceFlowTags = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(DeviceFlowTagModel::getDeviceId, (Object)deviceId)).in(DeviceFlowTagModel::getProductId, productIds)).eq(DeviceFlowTagModel::getIsDelete, (Object)0)).list();
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty((Collection)deleteDeviceFlowTags)) {
            return;
        }
        Date now = new Date();
        ArrayList<DeviceFlowTagModel> untieDeviceFlowTags = new ArrayList<DeviceFlowTagModel>();
        for (DeviceFlowTagModel tag : deleteDeviceFlowTags) {
            DeviceFlowTagModel untieTag = new DeviceFlowTagModel();
            BeanUtils.copyProperties((Object)((Object)tag), (Object)((Object)untieTag));
            untieTag.setId(null);
            untieTag.setIsDelete(1);
            untieTag.setOperateType(1);
            untieTag.setCreateTime(now);
            untieTag.setDeviceName(deviceName);
            untieTag.setCreateUserId(userId);
            untieDeviceFlowTags.add(untieTag);
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(DeviceFlowTagModel::getDeviceId, (Object)deviceId)).in(DeviceFlowTagModel::getProductId, productIds)).eq(DeviceFlowTagModel::getIsDelete, (Object)0)).set(DeviceFlowTagModel::getIsDelete, (Object)1)).set(DeviceFlowTagModel::getDeleteTime, (Object)now)).update();
        this.saveBatch(untieDeviceFlowTags);
    }

    @Override
    public List<DeviceFlowTagModel> listDeviceFlowTagByTagId(Integer tagId) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(DeviceFlowTagModel::getTagId, (Object)tagId)).eq(DeviceFlowTagModel::getIsDelete, (Object)0)).list();
    }

    @Override
    public void deleteByDeviceIdsAndProductId(List<Integer> deviceIds, Integer productId, Integer userId) {
        List deleteDeviceFlowTags = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(DeviceFlowTagModel::getDeviceId, deviceIds)).eq(DeviceFlowTagModel::getProductId, (Object)productId)).eq(DeviceFlowTagModel::getIsDelete, (Object)0)).list();
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty((Collection)deleteDeviceFlowTags)) {
            return;
        }
        List<Integer> deleteDeviceIds = deleteDeviceFlowTags.stream().map(DeviceFlowTagModel::getDeviceId).collect(Collectors.toList());
        Map<Integer, String> deviceNameMap = this.deviceFeign.getDeviceName(deleteDeviceIds);
        Date now = new Date();
        ArrayList<DeviceFlowTagModel> untieDeviceFlowTags = new ArrayList<DeviceFlowTagModel>();
        for (DeviceFlowTagModel tag : deleteDeviceFlowTags) {
            DeviceFlowTagModel untieTag = new DeviceFlowTagModel();
            BeanUtils.copyProperties((Object)((Object)tag), (Object)((Object)untieTag));
            untieTag.setId(null);
            untieTag.setIsDelete(1);
            untieTag.setOperateType(1);
            untieTag.setCreateTime(now);
            untieTag.setDeviceName(deviceNameMap.get(tag.getDeviceId()));
            untieTag.setCreateUserId(userId);
            untieDeviceFlowTags.add(untieTag);
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(DeviceFlowTagModel::getDeviceId, deviceIds)).eq(DeviceFlowTagModel::getProductId, (Object)productId)).eq(DeviceFlowTagModel::getIsDelete, (Object)0)).set(DeviceFlowTagModel::getIsDelete, (Object)1)).set(DeviceFlowTagModel::getDeleteTime, (Object)now)).update();
        this.saveBatch(untieDeviceFlowTags);
    }

    @Override
    public void deleteDeviceFlowTags(List<DeviceFlowTag> tags, Map<Integer, String> deviceNameMap, Integer userId) {
        List ids = tags.stream().map(DeviceFlowTag::getId).collect(Collectors.toList());
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty(ids)) {
            return;
        }
        Date now = new Date();
        ArrayList<DeviceFlowTagModel> untieDeviceFlowTags = new ArrayList<DeviceFlowTagModel>();
        for (DeviceFlowTag tag : tags) {
            DeviceFlowTagModel untieTag = new DeviceFlowTagModel();
            untieTag.setDeviceId(tag.getDeviceId());
            untieTag.setTagId(tag.getTagId());
            untieTag.setIsDelete(1);
            untieTag.setIsPrimaryPort(Optional.ofNullable(tag.getIsPrimaryPort()).map(isPrimaryPort -> isPrimaryPort != false ? 1 : 0).orElse(null));
            untieTag.setDepId(tag.getDepId());
            untieTag.setMac(tag.getMac());
            untieTag.setDataType(tag.getDataType());
            untieTag.setCreateTime(now);
            untieTag.setCreateUserId(userId);
            untieTag.setOperateType(1);
            untieTag.setDeviceName(deviceNameMap.get(tag.getDeviceId()));
            untieTag.setProductId(tag.getProductId());
            untieTag.setDeleteTime(now);
            untieTag.setDeviceGroupId(tag.getDeviceGroupId());
            untieDeviceFlowTags.add(untieTag);
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(DeviceFlowTagModel::getId, ids)).eq(DeviceFlowTagModel::getIsDelete, (Object)0)).set(DeviceFlowTagModel::getIsDelete, (Object)1)).set(DeviceFlowTagModel::getDeleteTime, (Object)now)).update();
        this.saveBatch(untieDeviceFlowTags);
    }

    @Override
    public void insertDevice2PrimaryPort(Integer depId, Integer deviceId, String mac, Integer dataType, Integer userId) {
        ShopFlowTagPojo primaryPort = this.shopFlowTagService.getPrimaryPortByDeptId(depId);
        if (primaryPort != null) {
            this.insertPrimaryDeviceFlowTag(depId, deviceId, mac, dataType, userId, primaryPort);
        } else {
            this.shopFlowTagService.correctFailedToCreatePrimaryPortTag(depId);
            primaryPort = this.shopFlowTagService.getPrimaryPortByDeptId(depId);
            this.insertPrimaryDeviceFlowTag(depId, deviceId, mac, dataType, userId, primaryPort);
        }
    }

    private void insertPrimaryDeviceFlowTag(Integer depId, Integer deviceId, String mac, Integer dataType, Integer userId, ShopFlowTagPojo primaryPort) {
        DeviceFlowTagModel repeatDeviceFlowTag = this.getRepeatDeviceFlowTag(depId, deviceId, mac, primaryPort.getId(), dataType);
        if (repeatDeviceFlowTag == null) {
            DeviceFlowTagModel tag = new DeviceFlowTagModel();
            tag.setDepId(depId);
            tag.setCreateTime(new Date());
            tag.setDataType(dataType);
            tag.setDeviceId(deviceId);
            tag.setMac(mac);
            tag.setCreateUserId(userId);
            tag.setIsDelete(0);
            tag.setOperateType(0);
            tag.setTagId(primaryPort.getId());
            tag.setIsPrimaryPort(1);
            DeviceStatusMo deviceStatus = this.deviceFeign.getDeviceStatusById(tag.getDeviceId());
            tag.setDeviceName(deviceStatus != null ? deviceStatus.getDeviceName() : null);
            this.deviceFlowTagMapper.insert((Object)tag);
        }
    }

    private DeviceFlowTagModel getRepeatDeviceFlowTag(Integer depId, Integer deviceId, String mac, Integer tagId, Integer dataType) {
        List deviceFlowTags = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(DeviceFlowTagModel::getDeviceId, (Object)deviceId)).eq(DeviceFlowTagModel::getTagId, (Object)tagId)).eq(DeviceFlowTagModel::getDepId, (Object)depId)).eq(DeviceFlowTagModel::getMac, (Object)mac)).eq(DeviceFlowTagModel::getDataType, (Object)dataType)).eq(DeviceFlowTagModel::getIsDelete, (Object)0)).list();
        if (!CollectionUtils.isEmpty((Collection)deviceFlowTags)) {
            return (DeviceFlowTagModel)((Object)deviceFlowTags.get(0));
        }
        return null;
    }

    @Override
    public void deleteDeviceFlowTagByMac(String mac, Integer userId) {
        List<DeviceFlowTagModel> deviceFlowTags = this.getValidDeviceFlowTagByMac(mac);
        this.deleteDeviceFlowTags(userId, deviceFlowTags);
    }

    @Override
    public void deleteDeviceFlowTagByDeviceId(Integer deviceId, Integer userId) {
        List deviceFlowTags = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(DeviceFlowTagModel::getDeviceId, (Object)deviceId)).eq(DeviceFlowTagModel::getIsDelete, (Object)0)).list();
        this.deleteDeviceFlowTags(userId, deviceFlowTags);
    }

    private void deleteDeviceFlowTags(Integer userId, List<DeviceFlowTagModel> deviceFlowTags) {
        if (!CollectionUtils.isEmpty(deviceFlowTags)) {
            for (DeviceFlowTagModel tag : deviceFlowTags) {
                DeviceStatusMo status = this.deviceFeign.getDeviceStatusById(tag.getDeviceId());
                String deviceName = status != null ? status.getDeviceName() : null;
                this.delete(tag, userId, deviceName);
            }
        }
    }

    @Override
    public List<StoreDeviceNumDto> listDeviceNum(List<Integer> depIds) {
        ArrayList<StoreDeviceNumDto> res = new ArrayList<StoreDeviceNumDto>();
        List<StoreTagDeviceNumDto> tagDeviceNums = this.deviceFlowTagMapper.listTagDeviceNum(depIds);
        Map<Integer, List<StoreTagDeviceNumDto>> depTagDeviceNumMap = tagDeviceNums.stream().collect(Collectors.groupingBy(StoreTagDeviceNumDto::getDepId));
        for (Integer depId : depIds) {
            StoreDeviceNumDto dto = new StoreDeviceNumDto();
            dto.setDepId(depId);
            List<StoreTagDeviceNumDto> tagDeviceNum = depTagDeviceNumMap.get(depId);
            if (!CollectionUtils.isEmpty(tagDeviceNum)) {
                for (StoreTagDeviceNumDto tag : tagDeviceNum) {
                    int tagCode = FlowTagUtils.getTagCode((Integer)tag.getTagType(), (Integer)tag.getIsPrimaryPort(), (Integer)tag.getCanDelete());
                    if (tagCode == 1) {
                        dto.setPrimaryDeviceNum(tag.getDeviceNum());
                        continue;
                    }
                    if (tagCode != 2) continue;
                    dto.setOutsideDeviceNum(tag.getDeviceNum());
                }
            }
            res.add(dto);
        }
        return res;
    }

    private List<DeviceFlowTagModel> getValidDeviceFlowTagByMac(String mac) {
        List deviceFlowTags = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(DeviceFlowTagModel::getMac, (Object)mac)).eq(DeviceFlowTagModel::getIsDelete, (Object)0)).list();
        return deviceFlowTags;
    }

    @Override
    public Boolean haveDevicesByTagId(Integer tagId, Integer tagType) {
        if (tagId == null) {
            return false;
        }
        List<DeviceFlowTagFeignVo> list = this.deviceFlowTagMapper.haveDevicesByTagId(tagId, tagType);
        return !CollectionUtils.isEmpty(list);
    }

    @Override
    public List<DeviceFlowTagFeignVo> getDeviceTagByTagIdAndType(Integer tagId, Integer tagType) {
        if (tagId == null) {
            return new ArrayList<DeviceFlowTagFeignVo>();
        }
        return this.deviceFlowTagMapper.haveDevicesByTagId(tagId, tagType);
    }

    @Override
    public List<Integer> checkDeviceIdList(List<Integer> deviceIdList) {
        return this.deviceFlowTagMapper.checkDeviceIdList(deviceIdList);
    }

    @Override
    public void insertDevice2Pass(Integer depId, Integer deviceId, String mac, Integer dataType, Integer userId) {
        ShopFlowTagPojo tag = this.shopFlowTagService.findShopFlowTagByDeptIdAndTagType(depId, 6);
        if (tag == null) {
            if (!this.shopFlowTagService.hasInit(depId, 0).booleanValue()) {
                this.shopFlowTagService.setDefaultTag(depId, 0);
            }
            this.shopFlowTagService.insertSubLevleTag(depId, "\u533a\u57df", "\u8fc7\u5e97\u5ba2\u6d41", 0, 0, 6);
        }
        if ((tag = this.shopFlowTagService.findShopFlowTagByDeptIdAndTagType(depId, 6)) != null) {
            this.insertPassDeviceFlowTag(depId, deviceId, mac, dataType, userId, tag);
        }
    }

    private void insertPassDeviceFlowTag(Integer depId, Integer deviceId, String mac, Integer dataType, Integer userId, ShopFlowTagPojo passTag) {
        DeviceFlowTagModel repeatDeviceFlowTag = this.getRepeatDeviceFlowTag(depId, deviceId, mac, passTag.getId(), dataType);
        if (repeatDeviceFlowTag == null) {
            DeviceFlowTagModel tag = new DeviceFlowTagModel();
            tag.setDepId(depId);
            tag.setCreateTime(new Date());
            tag.setDataType(dataType);
            tag.setDeviceId(deviceId);
            tag.setMac(mac);
            tag.setCreateUserId(userId);
            tag.setIsDelete(0);
            tag.setOperateType(0);
            tag.setTagId(passTag.getId());
            tag.setIsPrimaryPort(0);
            DeviceStatusMo status = this.deviceFeign.getDeviceStatusById(tag.getDeviceId());
            tag.setDeviceName(status != null ? status.getDeviceName() : null);
            this.deviceFlowTagMapper.insert((Object)tag);
        }
    }

    @Override
    public List<DeviceFlowTagModel> listBoundByTagId(Integer tagId, Date time) {
        if (tagId == null || time == null) {
            return new ArrayList<DeviceFlowTagModel>();
        }
        return this.deviceFlowTagMapper.listBoundByTagId(tagId, time);
    }

    @Override
    public List<DeviceFlowTagModel> listPeriodBoundByTagIds(List<Integer> tagIds, String startTime, String endTime) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(tagIds) || StringUtils.isBlank((CharSequence)startTime) || StringUtils.isBlank((CharSequence)endTime)) {
            return new ArrayList<DeviceFlowTagModel>();
        }
        return this.deviceFlowTagMapper.listPeriodBoundByTagIds(tagIds, startTime, endTime);
    }

    @Override
    public List<TagStoreDeviceNumDto> listTagStoreDeviceNum(List<Integer> depIds, Integer enterpriseId, Locale locale) {
        List<TagStoreDeviceNumDto> res = this.listTagStoreDeviceNumByEnterpriseId(enterpriseId, locale);
        if (CollectionUtils.isEmpty(res)) {
            return res;
        }
        List<StoreTagDeviceNumDto> tagDeviceNums = this.deviceFlowTagMapper.listTagDeviceNum(depIds);
        if (CollectionUtils.isEmpty(tagDeviceNums)) {
            return res;
        }
        HashMap tagStoreDeviceNumMap = new HashMap();
        tagDeviceNums.stream().forEach(t -> {
            TagStoreDeviceNumDto dto = new TagStoreDeviceNumDto();
            int tagCode = FlowTagUtils.getTagCode((Integer)t.getTagType(), (Integer)t.getIsPrimaryPort(), (Integer)t.getCanDelete());
            if (tagCode == -1) {
                dto.setTagName(t.getTagName());
            } else {
                dto.setTagName(this.messageSource.getMessage("shop.flow.tag.type." + t.getTagType(), null, locale));
            }
            dto.setTagCode(Integer.valueOf(tagCode));
            HashMap<Integer, Integer> storeDeviceNumMap = (HashMap<Integer, Integer>)tagStoreDeviceNumMap.get(dto);
            if (storeDeviceNumMap == null) {
                storeDeviceNumMap = new HashMap<Integer, Integer>();
                tagStoreDeviceNumMap.put(dto, storeDeviceNumMap);
            }
            storeDeviceNumMap.put(t.getDepId(), t.getDeviceNum());
        });
        res.stream().forEach(t -> {
            Map storeDeviceNumMap = (Map)tagStoreDeviceNumMap.get(t);
            if (storeDeviceNumMap != null) {
                t.setStoreDeviceNumMap(storeDeviceNumMap);
            }
        });
        return res;
    }

    private List<TagStoreDeviceNumDto> listTagStoreDeviceNumByEnterpriseId(Integer enterpriseId, Locale locale) {
        List<ShopFlowTagModel> shopFlowTags = this.shopFlowTagService.listTagCategoryByEnterpriseId(enterpriseId);
        return shopFlowTags.stream().map(t -> {
            TagStoreDeviceNumDto dto = new TagStoreDeviceNumDto();
            int tagCode = FlowTagUtils.getTagCode((Integer)t.getTagType(), (Integer)t.getIsPrimaryPort(), (Integer)t.getCanDelete());
            if (tagCode == -1) {
                dto.setTagName(t.getName());
            } else {
                dto.setTagName(this.messageSource.getMessage("shop.flow.tag.type." + t.getTagType(), null, locale));
            }
            dto.setTagCode(Integer.valueOf(tagCode));
            return dto;
        }).collect(Collectors.toList());
    }

    @Override
    public List<DeviceFlowTagDto> listDeviceFlowTagDtoByDeviceId(Integer deviceId, Integer dataType) {
        return this.deviceFlowTagMapper.listDeviceFlowTagDtoByDeviceId(deviceId, dataType);
    }

    @Override
    public List<DeviceFlowTagDto> listDeviceFlowTagDtoByDepId(Integer depId, Integer dataType) {
        return this.deviceFlowTagMapper.listDeviceFlowTagDtoByDepId(depId, dataType);
    }

    @Override
    public List<DeviceFlowTagDto> listDeviceFlowTagDtoByProductId(Integer productId, Integer deviceId) {
        return this.deviceFlowTagMapper.listDeviceFlowTagDtoByProductId(deviceId, productId);
    }

    @Override
    public List<DeviceFlowTagDto> listDeviceFlowTagDtoByMac(String mac, Integer productId) {
        if (StringUtils.isBlank((CharSequence)mac)) {
            return new ArrayList<DeviceFlowTagDto>();
        }
        return this.deviceFlowTagMapper.listDeviceFlowTagDtoByMac(mac, productId);
    }

    @Override
    public List<DeviceFlowTagDto> listDeviceFlowTagDtoByProductIds(List<Integer> deviceIds, List<Integer> productIds) {
        if (CollectionUtils.isEmpty(deviceIds) || CollectionUtils.isEmpty(productIds)) {
            return new ArrayList<DeviceFlowTagDto>();
        }
        return this.deviceFlowTagMapper.listDeviceFlowTagDtoByProductIds(deviceIds, productIds);
    }

    @Override
    public List<DeviceFlowTagDto> listDeviceFlowTagDtoByDeviceGroup(Integer deviceGroupId, List<Integer> productIds, List<Integer> deviceIds) {
        return this.deviceFlowTagMapper.listDeviceFlowTagDtoByDeviceGroup(deviceGroupId, deviceIds, productIds);
    }

    @Override
    public List<DeviceFlowTagModel> listByDeviceGroups(List<Integer> deviceGroupIds, List<Integer> productIds, List<Integer> deviceIds) {
        if (CollectionUtils.isEmpty(deviceGroupIds) || CollectionUtils.isEmpty(productIds) || CollectionUtils.isEmpty(deviceIds)) {
            return new ArrayList<DeviceFlowTagModel>();
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(DeviceFlowTagModel::getDeviceId, deviceIds)).in(DeviceFlowTagModel::getDeviceGroupId, deviceGroupIds)).in(DeviceFlowTagModel::getProductId, productIds)).eq(DeviceFlowTagModel::getIsDelete, (Object)0)).list();
    }

    @Override
    public List<DeviceFlowTagDto> listDeviceFlowTagDtoByTagId(Integer tagId) {
        log.info("listDeviceFlowTagDtoByTagId tagId:{}", (Object)tagId);
        if (tagId == null) {
            return new ArrayList<DeviceFlowTagDto>();
        }
        QueryWrapper wrapper = new QueryWrapper();
        ((LambdaQueryWrapper)wrapper.lambda().eq(DeviceFlowTagModel::getTagId, (Object)tagId)).eq(DeviceFlowTagModel::getIsDelete, (Object)0);
        return this.list((Wrapper)wrapper).stream().map(d -> this.deviceFlowTagPo2Dto((DeviceFlowTagModel)((Object)d))).collect(Collectors.toList());
    }

    public DeviceFlowTagDto deviceFlowTagPo2Dto(DeviceFlowTagModel po) {
        if (po == null) {
            return null;
        }
        DeviceFlowTagDto dto = new DeviceFlowTagDto();
        dto.setId(po.getId()).setDeviceId(po.getDeviceId()).setTagId(po.getTagId()).setIsDelete(po.getIsDelete()).setIsPrimaryPort(po.getIsPrimaryPort()).setDepId(po.getDepId()).setMac(po.getMac()).setDataType(po.getDataType()).setCreateTime(po.getCreateTime()).setCreateUserId(po.getCreateUserId()).setDeviceName(po.getDeviceName()).setOperateType(po.getOperateType()).setProductId(po.getProductId());
        return dto;
    }

    @Override
    public void delete(DeviceFlowTagModel m, Integer userId, String deviceName) {
        Date now = new Date();
        m.setDeleteTime(now);
        m.setIsDelete(1);
        if (deviceName != null) {
            m.setDeviceName(deviceName);
        }
        this.updateById((Object)m);
        DeviceFlowTagModel model = new DeviceFlowTagModel();
        BeanUtils.copyProperties((Object)((Object)m), (Object)((Object)model));
        model.setId(null);
        model.setOperateType(1);
        model.setCreateTime(now);
        model.setCreateUserId(userId);
        this.save((Object)model);
    }

    @Override
    public List<DeviceFlowTagModel> listByDeviceGroupIds(Integer depId, List<Integer> deviceGroupIds) {
        if (CollectionUtils.isEmpty(deviceGroupIds) || depId == null) {
            return new ArrayList<DeviceFlowTagModel>();
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(DeviceFlowTagModel::getDepId, (Object)depId)).in(DeviceFlowTagModel::getDeviceGroupId, deviceGroupIds)).eq(DeviceFlowTagModel::getIsDelete, (Object)0)).list();
    }

    @Override
    public List<DeviceFlowTagModel> getDepIdsHaveEnterDeviceDep(List<Integer> depIds) {
        ArrayList<DeviceFlowTagModel> models = new ArrayList<DeviceFlowTagModel>();
        if (CollectionUtils.isEmpty(depIds)) {
            return models;
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(DeviceFlowTagModel::getDepId, depIds)).in(DeviceFlowTagModel::getIsPrimaryPort, new Object[]{1})).eq(DeviceFlowTagModel::getIsDelete, (Object)0)).list();
    }

    @Override
    public List<Integer> getDepIdsByDepIdsAndTagType(List<Integer> depIds, Integer tagType) {
        List<Integer> result = new ArrayList<Integer>();
        if (org.apache.commons.collections.CollectionUtils.isEmpty(depIds) || Objects.isNull(tagType)) {
            return result;
        }
        result = this.deviceFlowTagMapper.getDepIdsByDepIdsAndTagType(depIds, tagType);
        return result;
    }
}

