/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.passenger.service.impl;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ovopark.passenger.mapper.DeviceGroupMapper;
import com.ovopark.passenger.model.DeviceGroupModel;
import com.ovopark.passenger.model.GroupDeviceModel;
import com.ovopark.passenger.service.DeviceGroupService;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DeviceGroupServiceImpl
extends ServiceImpl<DeviceGroupMapper, DeviceGroupModel>
implements DeviceGroupService {
    private static final Logger log = LoggerFactory.getLogger(DeviceGroupServiceImpl.class);
    @Resource
    private DeviceGroupMapper deviceGroupMapper;

    @Override
    public DeviceGroupModel getByIdAndMasterMac(String masterMac, Integer id) {
        if (masterMac == null || id == null) {
            return null;
        }
        List<DeviceGroupModel> list = this.deviceGroupMapper.getByIdAndMasterMac(masterMac, id);
        if (list == null || list.isEmpty()) {
            return null;
        }
        list.get(0).getDevices().removeIf(GroupDeviceModel::getIsDelete);
        return list.get(0);
    }

    @Override
    public List<DeviceGroupModel> listByDepId(Integer depId) {
        if (depId == null) {
            return new ArrayList<DeviceGroupModel>();
        }
        List<DeviceGroupModel> deviceGroupModels = this.deviceGroupMapper.listByDepId(depId);
        deviceGroupModels.forEach(deviceGroupModel -> {
            List<GroupDeviceModel> groupDeviceModels = deviceGroupModel.getDevices();
            this.removeDeletedDevices(groupDeviceModels);
        });
        return deviceGroupModels;
    }

    @Override
    public List<DeviceGroupModel> listByMasterMac(String masterMac) {
        if (masterMac == null) {
            return new ArrayList<DeviceGroupModel>();
        }
        List<DeviceGroupModel> deviceGroupModels = this.deviceGroupMapper.listByMasterMac(masterMac);
        deviceGroupModels.forEach(deviceGroupModel -> {
            List<GroupDeviceModel> groupDeviceModels = deviceGroupModel.getDevices();
            this.removeDeletedDevices(groupDeviceModels);
        });
        return deviceGroupModels;
    }

    @Override
    public List<DeviceGroupModel> listByMasterMacs(List<String> masterMacs) {
        if (CollectionUtils.isEmpty(masterMacs)) {
            return new ArrayList<DeviceGroupModel>();
        }
        List<DeviceGroupModel> deviceGroupModels = this.deviceGroupMapper.listByMasterMacs(masterMacs);
        deviceGroupModels.forEach(deviceGroupModel -> {
            List<GroupDeviceModel> groupDeviceModels = deviceGroupModel.getDevices();
            this.removeDeletedDevices(groupDeviceModels);
        });
        return deviceGroupModels;
    }

    private void removeDeletedDevices(List<GroupDeviceModel> groupDeviceModels) {
        if (CollectionUtils.isEmpty(groupDeviceModels)) {
            return;
        }
        groupDeviceModels.removeIf(GroupDeviceModel::getIsDelete);
    }

    @Override
    public List<DeviceGroupModel> listDeviceGroup(List<String> masterMacs) {
        if (CollectionUtils.isEmpty(masterMacs)) {
            return new ArrayList<DeviceGroupModel>();
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(DeviceGroupModel::getMasterMac, masterMacs)).eq(DeviceGroupModel::getIsDelete, (Object)false)).list();
    }
}

