/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.passenger.service.impl;

import com.ovopark.device.cloud.common.model.mo.SetMultiReidCfgMo;
import com.ovopark.device.signalling.model.response.SetMultiReidCfgRes;
import com.ovopark.passenger.common.Aggregate;
import com.ovopark.passenger.core.entity.DeviceFlowTag;
import com.ovopark.passenger.core.entity.DeviceGroup;
import com.ovopark.passenger.core.entity.DeviceGroupRepository;
import com.ovopark.passenger.core.entity.DeviceProductArea;
import com.ovopark.passenger.core.entity.GroupDevice;
import com.ovopark.passenger.core.entity.Product;
import com.ovopark.passenger.exception.BizException;
import com.ovopark.passenger.exception.ResultCodeEnum;
import com.ovopark.passenger.feign.DeviceFeign;
import com.ovopark.passenger.model.DeviceGroupModel;
import com.ovopark.passenger.model.ShopFlowTagModel;
import com.ovopark.passenger.pojo.bo.DeviceConfigItemBo;
import com.ovopark.passenger.pojo.bo.DeviceProductAreaBo;
import com.ovopark.passenger.service.DeviceFlowTagService;
import com.ovopark.passenger.service.DeviceGroupService;
import com.ovopark.passenger.service.DeviceProductAreaService;
import com.ovopark.passenger.service.NvrReidConfigService;
import com.ovopark.passenger.service.ShopFlowTagService;
import com.ovopark.passenger.support.DeviceStatus;
import com.ovopark.pojo.dto.DeviceStatusDto;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="nvrReidConfigService")
public class NvrReidConfigServiceImpl
implements NvrReidConfigService {
    private static final Logger log = LoggerFactory.getLogger(NvrReidConfigServiceImpl.class);
    @Resource
    private DeviceGroupRepository deviceGroupRepository;
    @Resource
    private DeviceFeign deviceFeign;
    @Resource
    private ShopFlowTagService shopFlowTagService;
    @Resource
    private DeviceProductAreaService deviceProductAreaService;
    @Resource
    private DeviceFlowTagService deviceFlowTagService;
    @Resource
    private DeviceGroupService deviceGroupService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveAndIssued(List<Aggregate<DeviceGroup>> aggregates, Map<SetMultiReidCfgRes.GroupsDTO, DeviceGroup> deviceGroupMap, Map<SetMultiReidCfgRes.GroupsDTO.ChannelCfgsDTO.AreasDTO, DeviceProductArea> areaMap, Map<SetMultiReidCfgRes.GroupsDTO.ChannelCfgsDTO.LinesDTO, DeviceProductArea> lineMap, List<DeviceGroup> addGroups, List<Aggregate<DeviceGroup>> reconfigureGroups, SetMultiReidCfgMo setMultiReidCfgMo, Map<Integer, DeviceStatus> channelIdDeviceMap, List<GroupDevice> addAreaDevices) {
        boolean success;
        List masterDeviceGroupIds;
        this.deviceGroupRepository.saveBatch(aggregates);
        deviceGroupMap.forEach((deviceGroupDto, deviceGroup) -> deviceGroupDto.setGroupId(deviceGroup.getId()));
        areaMap.forEach((areaDto, deviceProductArea) -> areaDto.setId(String.valueOf(deviceProductArea.getProductId())));
        lineMap.forEach((lineDto, deviceProductArea) -> lineDto.setId(String.valueOf(deviceProductArea.getProductId())));
        ArrayList<DeviceFlowTag> addTags = new ArrayList<DeviceFlowTag>();
        if (CollectionUtils.isNotEmpty(addGroups)) {
            this.autoConfig(addGroups, channelIdDeviceMap, addTags, setMultiReidCfgMo.getUserId());
        }
        if (CollectionUtils.isNotEmpty(reconfigureGroups)) {
            this.autoReconfigure(reconfigureGroups, channelIdDeviceMap, addTags, setMultiReidCfgMo.getUserId());
        }
        if (CollectionUtils.isNotEmpty(addTags)) {
            this.deviceFlowTagService.saveOrUpdateDomains(addTags);
        }
        if (CollectionUtils.isNotEmpty(addAreaDevices) && CollectionUtils.isNotEmpty(masterDeviceGroupIds = addAreaDevices.stream().filter(d -> d.getIsMasterInUse() != null && d.getIsMasterInUse() != false).map(GroupDevice::getMasterDeviceGroupId).filter(Objects::nonNull).collect(Collectors.toList()))) {
            List deviceGroupModels = this.deviceGroupService.listByIds(masterDeviceGroupIds);
            Map nvrDeviceGroupIdsMap = deviceGroupModels.stream().collect(Collectors.groupingBy(DeviceGroupModel::getMasterMac, Collectors.mapping(DeviceGroupModel::getId, Collectors.toList())));
            nvrDeviceGroupIdsMap.forEach((masterMac, deviceGroupIds) -> this.reconfigure((String)masterMac, (List<Integer>)deviceGroupIds, setMultiReidCfgMo.getUserId()));
        }
        if (!(success = this.deviceFeign.setMultiReidCfg(setMultiReidCfgMo))) {
            log.error("\u4e0b\u53d1\u8bbe\u5907\u914d\u7f6e\u5931\u8d25,setMultiReidCfgMo:{}", (Object)setMultiReidCfgMo);
            throw new BizException(ResultCodeEnum.DEVICE_ISSUANCE_FAILED.getCode(), ResultCodeEnum.DEVICE_ISSUANCE_FAILED.getMessage());
        }
    }

    private void autoReconfigure(List<Aggregate<DeviceGroup>> reconfigureGroups, Map<Integer, DeviceStatus> channelIdDeviceMap, List<DeviceFlowTag> addTags, Integer userId) {
        if (CollectionUtils.isEmpty(reconfigureGroups)) {
            return;
        }
        List snapDeviceGroups = reconfigureGroups.stream().map(Aggregate::getSnapshot).filter(Objects::nonNull).collect(Collectors.toList());
        List<DeviceGroup> deviceGroups = reconfigureGroups.stream().map(Aggregate::getRoot).filter(Objects::nonNull).collect(Collectors.toList());
        HashMap<Integer, Boolean> tagIdMap = new HashMap<Integer, Boolean>();
        for (DeviceGroup deviceGroup : snapDeviceGroups) {
            List devices = deviceGroup.getDevices();
            if (!CollectionUtils.isNotEmpty((Collection)devices)) continue;
            for (GroupDevice groupDevice : devices) {
                List deviceProductAreas;
                if (groupDevice.getIsMasterInUse() != null && groupDevice.getIsMasterInUse().booleanValue() || !CollectionUtils.isNotEmpty((Collection)(deviceProductAreas = groupDevice.getDeviceProductAreas()))) continue;
                for (DeviceProductArea deviceProductArea : deviceProductAreas) {
                    List deviceFlowTags;
                    if (Objects.equals(0, deviceProductArea.getProductType()) || !CollectionUtils.isNotEmpty((Collection)(deviceFlowTags = deviceProductArea.getDeviceFlowTags()))) continue;
                    for (DeviceFlowTag deviceFlowTag : deviceFlowTags) {
                        if (tagIdMap.containsKey(deviceFlowTag.getTagId())) continue;
                        tagIdMap.put(deviceFlowTag.getTagId(), deviceFlowTag.getIsPrimaryPort());
                    }
                }
            }
        }
        ArrayList<DeviceConfigItemBo> primaryDeviceItems = new ArrayList<DeviceConfigItemBo>();
        ArrayList<DeviceConfigItemBo> productDeviceItems = new ArrayList<DeviceConfigItemBo>();
        NvrReidConfigServiceImpl.fillConfigItems(deviceGroups, channelIdDeviceMap, primaryDeviceItems, productDeviceItems);
        if (CollectionUtils.isNotEmpty(primaryDeviceItems) && !tagIdMap.isEmpty()) {
            for (DeviceConfigItemBo item : primaryDeviceItems) {
                for (Map.Entry entry : tagIdMap.entrySet()) {
                    Integer tagId = (Integer)entry.getKey();
                    Boolean isPrimaryPort = (Boolean)entry.getValue();
                    addTags.add(this.getDeviceFlowTag(item, tagId, isPrimaryPort, userId));
                }
            }
        }
        this.autoProductAreaBindTag(addTags, userId, productDeviceItems);
    }

    private void autoProductAreaBindTag(List<DeviceFlowTag> addTags, Integer userId, List<DeviceConfigItemBo> productDeviceItems) {
        if (CollectionUtils.isNotEmpty(productDeviceItems)) {
            List<Integer> deviceIds = productDeviceItems.stream().map(DeviceConfigItemBo::getDeviceId).distinct().collect(Collectors.toList());
            List<Integer> productIds = productDeviceItems.stream().map(DeviceConfigItemBo::getProductId).distinct().collect(Collectors.toList());
            Map<Integer, Map<Integer, List<DeviceProductAreaBo>>> areaMap = this.deviceProductAreaService.listDeviceProductAreaByDeviceIdsAndProductIds(deviceIds, productIds).stream().collect(Collectors.groupingBy(DeviceProductAreaBo::getDeviceId, Collectors.groupingBy(DeviceProductAreaBo::getProductId)));
            for (DeviceConfigItemBo item : productDeviceItems) {
                List<DeviceProductAreaBo> areas;
                Map<Integer, List<DeviceProductAreaBo>> productAreas = areaMap.get(item.getDeviceId());
                if (productAreas == null || (areas = productAreas.get(item.getProductId())) == null) continue;
                for (DeviceProductAreaBo area : areas) {
                    if (area.getTagId() == null || area.getTagId() <= 0) continue;
                    addTags.add(this.getDeviceFlowTag(item, area.getTagId(), false, userId));
                }
            }
        }
    }

    private void autoConfig(List<DeviceGroup> deviceGroups, Map<Integer, DeviceStatus> channelIdDeviceMap, List<DeviceFlowTag> addTags, Integer userId) {
        if (CollectionUtils.isEmpty(deviceGroups)) {
            return;
        }
        ArrayList<DeviceConfigItemBo> primaryDeviceItems = new ArrayList<DeviceConfigItemBo>();
        ArrayList<DeviceConfigItemBo> productDeviceItems = new ArrayList<DeviceConfigItemBo>();
        NvrReidConfigServiceImpl.fillConfigItems(deviceGroups, channelIdDeviceMap, primaryDeviceItems, productDeviceItems);
        if (CollectionUtils.isNotEmpty(primaryDeviceItems)) {
            Integer depId = ((DeviceConfigItemBo)primaryDeviceItems.get(0)).getDepId();
            Integer tagId = Optional.ofNullable(this.shopFlowTagService.getPrimaryTag(depId)).map(ShopFlowTagModel::getId).orElse(null);
            if (tagId == null) {
                this.shopFlowTagService.repairMainEntrance(depId);
                tagId = Optional.ofNullable(this.shopFlowTagService.getPrimaryTag(depId)).map(ShopFlowTagModel::getId).orElse(null);
                if (tagId == null) {
                    log.error("autoConfig\u95e8\u5e97\u6ca1\u6709\u4e3b\u51fa\u5165\u53e3\u6807\u7b7e,deviceGroups:{}", deviceGroups);
                    throw new BizException(ResultCodeEnum.EMPTY_PRIMARY_PORT.getCode(), ResultCodeEnum.EMPTY_PRIMARY_PORT.getMessage());
                }
            }
            for (DeviceConfigItemBo item : primaryDeviceItems) {
                addTags.add(this.getDeviceFlowTag(item, tagId, true, userId));
            }
        }
        this.autoProductAreaBindTag(addTags, userId, productDeviceItems);
    }

    private static void fillConfigItems(List<DeviceGroup> deviceGroups, Map<Integer, DeviceStatus> channelIdDeviceMap, List<DeviceConfigItemBo> primaryDeviceItems, List<DeviceConfigItemBo> productDeviceItems) {
        for (DeviceGroup deviceGroup : deviceGroups) {
            List devices = deviceGroup.getDevices();
            if (!CollectionUtils.isNotEmpty((Collection)devices)) continue;
            for (GroupDevice groupDevice : devices) {
                List deviceProductAreas;
                if (groupDevice.getIsMasterInUse() != null && groupDevice.getIsMasterInUse().booleanValue() || !CollectionUtils.isNotEmpty((Collection)(deviceProductAreas = groupDevice.getDeviceProductAreas()))) continue;
                for (DeviceProductArea deviceProductArea : deviceProductAreas) {
                    if (Product.isPrimaryPortProduct((int)deviceProductArea.getProductType())) {
                        primaryDeviceItems.add(new DeviceConfigItemBo(deviceGroup.getDepId(), deviceGroup.getId(), groupDevice.getDeviceId(), groupDevice.getMac(), Optional.ofNullable(channelIdDeviceMap.get(groupDevice.getChannelId())).map(DeviceStatus::getName).orElse(null), deviceProductArea.getProductId(), deviceProductArea.getProductType()));
                    }
                    if (!Objects.equals(0, deviceProductArea.getProductType())) continue;
                    productDeviceItems.add(new DeviceConfigItemBo(deviceGroup.getDepId(), deviceGroup.getId(), groupDevice.getDeviceId(), groupDevice.getMac(), Optional.ofNullable(channelIdDeviceMap.get(groupDevice.getChannelId())).map(DeviceStatus::getName).orElse(null), deviceProductArea.getProductId(), deviceProductArea.getProductType()));
                }
            }
        }
    }

    private DeviceFlowTag getDeviceFlowTag(DeviceConfigItemBo item, Integer tagId, Boolean isPrimaryPort, Integer userId) {
        DeviceFlowTag deviceFlowTag = new DeviceFlowTag();
        deviceFlowTag.setDeviceId(item.getDeviceId());
        deviceFlowTag.setTagId(tagId);
        deviceFlowTag.setIsDelete(Boolean.valueOf(false));
        deviceFlowTag.setIsPrimaryPort(isPrimaryPort);
        deviceFlowTag.setDepId(item.getDepId());
        deviceFlowTag.setMac(item.getMac());
        deviceFlowTag.setDataType(Integer.valueOf(12));
        deviceFlowTag.setCreateTime(new Date());
        deviceFlowTag.setCreateUserId(userId);
        deviceFlowTag.setOperateType(Integer.valueOf(0));
        deviceFlowTag.setDeviceName(item.getDeviceName());
        deviceFlowTag.setProductId(item.getProductId());
        deviceFlowTag.setProductType(item.getProductType());
        deviceFlowTag.setDeviceGroupId(item.getDeviceGroupId());
        return deviceFlowTag;
    }

    @Override
    public void reconfigure(String nvrMac, List<Integer> deviceGroupIds, Integer userId) {
        DeviceStatusDto nvrDeviceStatusDto;
        if (StringUtils.isBlank((CharSequence)nvrMac)) {
            return;
        }
        boolean empty = CollectionUtils.isEmpty(deviceGroupIds);
        if (userId == null) {
            userId = 1;
        }
        if ((nvrDeviceStatusDto = this.deviceFeign.getDeviceStatusDtoByMac(nvrMac, 20)) == null) {
            return;
        }
        List<DeviceStatus> ipcDevices = this.deviceFeign.listIpcByNvrDeviceId(nvrDeviceStatusDto.getId());
        Map<Integer, DeviceStatus> channelIdDeviceMap = ipcDevices.stream().collect(Collectors.toMap(DeviceStatus::getChannelId, Function.identity()));
        List aggregates = this.deviceGroupRepository.listByMasterMac(nvrMac);
        ArrayList todoTags = new ArrayList();
        ArrayList<Aggregate<DeviceGroup>> reconfigureDeviceGroups = new ArrayList<Aggregate<DeviceGroup>>();
        for (Aggregate aggregate : aggregates) {
            DeviceGroup root = (DeviceGroup)aggregate.getRoot();
            if (root == null || !empty && !deviceGroupIds.contains(root.getId())) continue;
            reconfigureDeviceGroups.add((Aggregate<DeviceGroup>)aggregate);
            List devices = root.getDevices();
            if (!CollectionUtils.isNotEmpty((Collection)devices)) continue;
            for (GroupDevice device : devices) {
                List deviceProductAreas = device.getDeviceProductAreas();
                if (!CollectionUtils.isNotEmpty((Collection)deviceProductAreas)) continue;
                for (DeviceProductArea deviceProductArea : deviceProductAreas) {
                    List deviceFlowTags = deviceProductArea.getDeviceFlowTags();
                    if (!CollectionUtils.isNotEmpty((Collection)deviceFlowTags)) continue;
                    todoTags.addAll(deviceFlowTags);
                }
            }
        }
        ArrayList<DeviceFlowTag> reconfigureTags = new ArrayList<DeviceFlowTag>();
        if (CollectionUtils.isNotEmpty(reconfigureDeviceGroups)) {
            this.autoReconfigure(reconfigureDeviceGroups, channelIdDeviceMap, reconfigureTags, userId);
        }
        Map<DeviceFlowTag, List<DeviceFlowTag>> todoTagMap = todoTags.stream().collect(Collectors.groupingBy(t -> new DeviceFlowTag().setDeviceId(t.getDeviceId()).setProductId(t.getProductId()).setDeviceGroupId(t.getDeviceGroupId()).setTagId(t.getTagId())));
        Map<DeviceFlowTag, List<DeviceFlowTag>> reconfigureTagMap = reconfigureTags.stream().collect(Collectors.groupingBy(t -> new DeviceFlowTag().setDeviceId(t.getDeviceId()).setProductId(t.getProductId()).setDeviceGroupId(t.getDeviceGroupId()).setTagId(t.getTagId())));
        ArrayList<DeviceFlowTag> deleteTags = new ArrayList<DeviceFlowTag>();
        todoTagMap.forEach((k, v) -> {
            if (!reconfigureTagMap.containsKey(k)) {
                deleteTags.addAll((Collection<DeviceFlowTag>)v);
            }
        });
        ArrayList<DeviceFlowTag> addTags = new ArrayList<DeviceFlowTag>();
        reconfigureTagMap.forEach((k, v) -> {
            if (!todoTagMap.containsKey(k)) {
                addTags.addAll((Collection<DeviceFlowTag>)v);
            }
        });
        if (CollectionUtils.isNotEmpty(deleteTags)) {
            Map<Integer, String> deviceNameMap = ipcDevices.stream().collect(Collectors.toMap(DeviceStatus::getId, DeviceStatus::getName, (k1, k2) -> k1));
            this.deviceFlowTagService.deleteDeviceFlowTags(deleteTags, deviceNameMap, userId);
        }
        if (CollectionUtils.isNotEmpty(addTags)) {
            this.deviceFlowTagService.saveOrUpdateDomains(addTags);
        }
    }
}

