/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.passenger.service.impl;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ovopark.passenger.mapper.ProductMapper;
import com.ovopark.passenger.model.ProductModel;
import com.ovopark.passenger.service.ProductService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

@Service
class ProductServiceImpl
extends ServiceImpl<ProductMapper, ProductModel>
implements ProductService {
    ProductServiceImpl() {
    }

    @Override
    public List<ProductModel> listProductAreaByEnterpriseId(Integer enterpriseId) {
        if (enterpriseId == null) {
            return new ArrayList<ProductModel>();
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(ProductModel::getEnterpriseId, (Object)enterpriseId)).eq(ProductModel::getProductType, (Object)0)).eq(ProductModel::getIsDelete, (Object)false)).list();
    }

    @Override
    public List<ProductModel> getProductAreasByIds(List<Integer> productIds) {
        List<ProductModel> result = new ArrayList<ProductModel>();
        if (CollectionUtils.isEmpty(productIds)) {
            return result;
        }
        result = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(ProductModel::getId, productIds)).eq(ProductModel::getProductType, (Object)0)).eq(ProductModel::getIsDelete, (Object)false)).list();
        return result;
    }

    @Override
    public Map<Integer, String> getProductIdAndProductNameMap(List<Integer> productIds) {
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        if (CollectionUtils.isEmpty(productIds)) {
            return map;
        }
        List<ProductModel> productModels = this.getProductAreasByIds(productIds);
        return productModels.stream().collect(Collectors.toMap(ProductModel::getId, ProductModel::getName, (oldValue, newValue) -> oldValue));
    }
}

