/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.passenger.service.impl;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ovopark.passenger.mapper.ProductTouchMapper;
import com.ovopark.passenger.model.ProductTouchModel;
import com.ovopark.passenger.service.ProductTouchService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class ProductTouchServiceImpl
extends ServiceImpl<ProductTouchMapper, ProductTouchModel>
implements ProductTouchService {
    @Override
    public List<ProductTouchModel> getProductTouchesByDepId(Integer depId, List<Integer> productAreaIds, String startTime, String endTime) {
        List<ProductTouchModel> result = new ArrayList<ProductTouchModel>();
        if (Objects.isNull(depId) || StringUtils.isBlank((CharSequence)startTime) || StringUtils.isBlank((CharSequence)endTime)) {
            return result;
        }
        result = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(ProductTouchModel::getDepId, (Object)depId)).in(CollectionUtils.isNotEmpty(productAreaIds), ProductTouchModel::getProductAreaId, productAreaIds)).between(ProductTouchModel::getRecordTime, (Object)startTime, (Object)endTime)).orderByDesc(ProductTouchModel::getRecordTime)).list();
        return result;
    }

    @Override
    public Map<Integer, Integer> getProductAreaIdAndTouchSumMap(Integer depId, List<Integer> productAreaIds, String startTime, String endTime) {
        List<ProductTouchModel> productTouchModels = this.getProductTouchesByDepId(depId, productAreaIds, startTime, endTime);
        if (CollectionUtils.isEmpty(productTouchModels)) {
            return new HashMap<Integer, Integer>();
        }
        Map<Integer, Integer> productAreaIdAndTouchSumMap = productTouchModels.stream().collect(Collectors.groupingBy(ProductTouchModel::getProductAreaId, Collectors.summingInt(ProductTouchModel::getTouchNum)));
        return productAreaIdAndTouchSumMap;
    }
}

