/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.passenger.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ovopark.mq.api.KafkaProducerApi;
import com.ovopark.mq.pojo.dto.PassengerPushTaskDto;
import com.ovopark.passenger.mapper.PushTimePointMapper;
import com.ovopark.passenger.model.PushTimePointModel;
import com.ovopark.passenger.service.PushTimePointService;
import com.ovopark.passenger.util.TimeUtils;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class PushTimePointServiceImpl
extends ServiceImpl<PushTimePointMapper, PushTimePointModel>
implements PushTimePointService {
    private static final Logger log = LoggerFactory.getLogger(PushTimePointServiceImpl.class);
    @Resource
    private KafkaProducerApi kafkaProducerApi;

    @Override
    public boolean update(Integer depId, Date recordTime, Integer taskId, Integer cycMinute, Integer currentLimiting) {
        Date realTime;
        Date realTimePoint;
        Date realPreviousTimePoint;
        if (depId == null || recordTime == null || taskId == null || cycMinute == null) {
            return false;
        }
        Date recordTimePoint = TimeUtils.getEntireMinTimePoint(recordTime, cycMinute);
        if (Objects.equals(recordTimePoint, realPreviousTimePoint = TimeUtils.addMinute(realTimePoint = TimeUtils.getEntireMinTimePoint(realTime = new Date(), cycMinute), -cycMinute.intValue())) && TimeUtils.getMinute(realTime) % cycMinute < 7) {
            this.merge(depId, recordTimePoint, realPreviousTimePoint, taskId, cycMinute, currentLimiting, realTime);
            return true;
        }
        this.merge(depId, recordTimePoint, realTimePoint, taskId, cycMinute, currentLimiting, realTime);
        return true;
    }

    private void merge(Integer depId, Date recordTime, Date realTime, Integer taskId, Integer cycMinute, Integer currentLimiting, Date now) {
        PushTimePointModel po = this.getUniquePo(depId, recordTime, realTime, taskId);
        if (po != null) {
            return;
        }
        int addMin = cycMinute + 8;
        Date time = realTime.after(recordTime) ? realTime : recordTime;
        Date pushTime = TimeUtils.addMinute(time, addMin);
        Long delayMs = pushTime.getTime() - now.getTime();
        Integer delaySec = (int)(delayMs / 1000L);
        PushTimePointModel pushTimePoint = new PushTimePointModel();
        pushTimePoint.setDepId(depId);
        pushTimePoint.setRecordTime(recordTime);
        pushTimePoint.setRealTime(realTime);
        pushTimePoint.setTaskId(taskId);
        pushTimePoint.setDelaySec(delaySec);
        pushTimePoint.setCurrentLimiting(currentLimiting);
        try {
            boolean save = this.save((Object)pushTimePoint);
            if (save) {
                log.info("PushTimePointModel\u4fdd\u5b58\u6210\u529f");
                PassengerPushTaskDto pushTaskDto = new PassengerPushTaskDto();
                pushTaskDto.setId(pushTimePoint.getId());
                pushTaskDto.setTaskId(taskId);
                pushTaskDto.setDepId(depId);
                pushTaskDto.setRecordTime(TimeUtils.formatLongDate(recordTime));
                pushTaskDto.setRealTime(TimeUtils.formatLongDate(realTime));
                pushTaskDto.setDelaySec(Integer.valueOf(addMin * 60));
                pushTaskDto.setCurrentLimiting(currentLimiting);
                this.kafkaProducerApi.send2PushTaskTopic(pushTaskDto);
            }
        }
        catch (Exception e) {
            log.warn("PushTimePointModel\u4fdd\u5b58\u5931\u8d25", (Throwable)e);
        }
    }

    private PushTimePointModel getUniquePo(Integer depId, Date recordTime, Date realTime, Integer taskId) {
        QueryWrapper wrapper = new QueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.lambda().eq(PushTimePointModel::getDepId, (Object)depId)).eq(PushTimePointModel::getRecordTime, (Object)recordTime)).eq(PushTimePointModel::getRealTime, (Object)realTime)).eq(PushTimePointModel::getTaskId, (Object)taskId);
        return (PushTimePointModel)((Object)this.getOne((Wrapper)wrapper));
    }

    @Override
    public void handlePushTaskFailed() {
        log.info("---------handlePushTaskFailed start");
        Date now = new Date();
        Date hourAgo = TimeUtils.addHour(now, -1);
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().lt(PushTimePointModel::getRecordTime, (Object)hourAgo)).lt(PushTimePointModel::getRealTime, (Object)hourAgo)).last("limit 10000")).list();
        for (PushTimePointModel po : list) {
            log.info("---------handlePushTaskFailed task:{}", (Object)po);
            PassengerPushTaskDto pushTaskDto = new PassengerPushTaskDto();
            pushTaskDto.setId(po.getId());
            pushTaskDto.setTaskId(po.getTaskId());
            pushTaskDto.setDepId(po.getDepId());
            pushTaskDto.setRecordTime(TimeUtils.formatLongDate(po.getRecordTime()));
            pushTaskDto.setRealTime(TimeUtils.formatLongDate(po.getRealTime()));
            pushTaskDto.setDelaySec(po.getDelaySec());
            pushTaskDto.setCurrentLimiting(po.getCurrentLimiting());
            this.kafkaProducerApi.send2PushTaskTopic(pushTaskDto);
        }
        log.info("---------handlePushTaskFailed end");
    }
}

