/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.passenger.service.impl;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.google.common.collect.Lists;
import com.ovopark.passenger.mapper.TouchAreaConfigMapper;
import com.ovopark.passenger.model.TouchAreaConfigModel;
import com.ovopark.passenger.pojo.dto.TouchAreaConfigDto;
import com.ovopark.passenger.pojo.vo.TouchAreaConfigVo;
import com.ovopark.passenger.service.ProductAreaTouchAreaConfigService;
import com.ovopark.passenger.service.TouchAreaConfigService;
import com.ovopark.pojo.UserPojo;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TouchAreaConfigServiceImpl
extends ServiceImpl<TouchAreaConfigMapper, TouchAreaConfigModel>
implements TouchAreaConfigService {
    private static final Logger log = LoggerFactory.getLogger(TouchAreaConfigServiceImpl.class);
    @Resource
    private ProductAreaTouchAreaConfigService productAreaTouchAreaConfigService;

    @Override
    public List<TouchAreaConfigVo> getTouchAreaConfigs(Integer deviceId) {
        List<TouchAreaConfigVo> list = new ArrayList<TouchAreaConfigVo>();
        if (Objects.isNull(deviceId)) {
            return list;
        }
        list = this.getTouchAreaConfigVos(null, deviceId);
        return list;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addOrUpdateTouchAreaConfig(UserPojo user, TouchAreaConfigDto dto) {
        Integer touchId = dto.getId();
        LocalDateTime now = LocalDateTime.now();
        if (Objects.isNull(touchId)) {
            TouchAreaConfigModel model = new TouchAreaConfigModel();
            model.setTouchName(dto.getTouchName());
            model.setDeviceId(dto.getDeviceId());
            model.setDepId(dto.getDepId());
            model.setEnterpriseId(user.getGroupId());
            model.setIsDelete(false);
            model.setCreatorId(user.getUserId());
            model.setCreateTime(now);
            this.save((Object)model);
        } else {
            TouchAreaConfigModel model = (TouchAreaConfigModel)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TouchAreaConfigModel::getId, (Object)touchId)).eq(TouchAreaConfigModel::getIsDelete, (Object)false)).last("LIMIT 1")).one());
            if (Objects.isNull((Object)model)) {
                return;
            }
            model.setTouchName(dto.getTouchName());
            model.setUpdateUserId(user.getUserId());
            model.setUpdateTime(now);
            this.updateById((Object)model);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void delTouchAreaConfig(UserPojo user, Integer deviceId, List<Integer> touchIds) {
        if (Objects.isNull(deviceId) && CollectionUtils.isEmpty(touchIds)) {
            return;
        }
        List models = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(Objects.nonNull(deviceId), TouchAreaConfigModel::getDeviceId, (Object)deviceId)).in(CollectionUtils.isNotEmpty(touchIds), TouchAreaConfigModel::getId, touchIds)).eq(TouchAreaConfigModel::getIsDelete, (Object)false)).list();
        LocalDateTime now = LocalDateTime.now();
        for (TouchAreaConfigModel touchAreaConfigModel : models) {
            touchAreaConfigModel.setIsDelete(true);
            touchAreaConfigModel.setDeleteUserId(user.getUserId());
            touchAreaConfigModel.setDeleteTime(now);
            this.updateById((Object)touchAreaConfigModel);
        }
        List<Integer> needDelTouchIds = models.stream().map(TouchAreaConfigModel::getId).collect(Collectors.toList());
        log.info("delTouchAreaConfig needDelTouchIds->{}", needDelTouchIds);
        this.productAreaTouchAreaConfigService.unbindProductAreaTouchAreas(user, needDelTouchIds);
    }

    @Override
    public List<TouchAreaConfigModel> listValidTouchAreasByMacAndTouchIds(List<Integer> touchIds) {
        if (CollectionUtils.isEmpty(touchIds)) {
            return Lists.newArrayList();
        }
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(TouchAreaConfigModel::getId, touchIds)).eq(TouchAreaConfigModel::getIsDelete, (Object)false)).list();
        return list;
    }

    @Override
    public Map<Integer, String> getTouchIdAndNameMapByTouchIds(List<Integer> touchIds) {
        Map<Integer, String> result = new HashMap<Integer, String>();
        if (CollectionUtils.isEmpty(touchIds)) {
            return result;
        }
        List<TouchAreaConfigModel> touchAreaConfigModels = this.listValidTouchAreasByMacAndTouchIds(touchIds);
        result = touchAreaConfigModels.stream().collect(Collectors.toMap(TouchAreaConfigModel::getId, TouchAreaConfigModel::getTouchName));
        return result;
    }

    @Override
    public List<TouchAreaConfigVo> getTouchAreaConfigsByDepId(Integer depId) {
        List<TouchAreaConfigVo> list = new ArrayList<TouchAreaConfigVo>();
        if (Objects.isNull(depId)) {
            return list;
        }
        list = this.getTouchAreaConfigVos(depId, null);
        return list;
    }

    @Override
    public List<TouchAreaConfigModel> listValidTouchAreasByDepIds(List<Integer> depIds) {
        List<TouchAreaConfigModel> result = new ArrayList<TouchAreaConfigModel>();
        if (CollectionUtils.isEmpty(depIds)) {
            return result;
        }
        result = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(TouchAreaConfigModel::getDepId, depIds)).eq(TouchAreaConfigModel::getIsDelete, (Object)false)).list();
        return result;
    }

    private List<TouchAreaConfigVo> getTouchAreaConfigVos(Integer depId, Integer deviceId) {
        List<TouchAreaConfigVo> list = new ArrayList<TouchAreaConfigVo>();
        List models = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(Objects.nonNull(depId), TouchAreaConfigModel::getDepId, (Object)depId)).eq(Objects.nonNull(deviceId), TouchAreaConfigModel::getDeviceId, (Object)deviceId)).eq(TouchAreaConfigModel::getIsDelete, (Object)false)).list();
        if (CollectionUtils.isEmpty((Collection)models)) {
            return list;
        }
        list = models.stream().map(e -> {
            TouchAreaConfigVo vo = new TouchAreaConfigVo();
            vo.setId(e.getId()).setTouchName(e.getTouchName()).setDeviceId(e.getDeviceId()).setDepId(e.getDepId());
            return vo;
        }).collect(Collectors.toList());
        return list;
    }
}

