/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.passenger.util;

import cn.hutool.core.lang.Pair;
import cn.hutool.core.util.StrUtil;
import com.ovopark.passenger.pojo.CategoryChangeType;
import com.ovopark.passenger.util.SpringContextUtil;
import com.ovopark.passenger.util.TimeUtils;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.temporal.WeekFields;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.MessageSource;

public class CategoriesUtil {
    private static final Logger log = LoggerFactory.getLogger(CategoriesUtil.class);
    private static MessageSource messageSource = SpringContextUtil.getBean(MessageSource.class);

    public static List<String> getCategoriesByTimeTypeFromStimeToEtime(String stime, String etime, Integer timeType) {
        return CategoriesUtil.getCategoriesByTimeTypeFromStimeToEtime(stime, etime, timeType, (Boolean)false);
    }

    public static List<String> getCategoriesByTimeTypeFromStimeToEtime(String stime, String etime, Integer timeType, Boolean isStartDayTheWeekSunday) {
        ArrayList<String> categories = new ArrayList<String>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date startDate = TimeUtils.timeStrToDate(stime);
        Date endDate = TimeUtils.timeStrToDate(etime);
        startDate = CategoriesUtil.getStartDate(timeType, startDate, endDate);
        Calendar cal = Calendar.getInstance();
        cal.setFirstDayOfWeek(isStartDayTheWeekSunday != null && isStartDayTheWeekSunday != false ? 1 : 2);
        cal.setMinimalDaysInFirstWeek(4);
        cal.setTime(startDate);
        block9: while (!cal.getTime().after(endDate)) {
            String dateStr = sdf.format(cal.getTime());
            String timeStr = CategoriesUtil.getShowTimeStrByDateStr(dateStr, timeType, isStartDayTheWeekSunday);
            if (!categories.contains(timeStr)) {
                categories.add(timeStr);
            }
            switch (timeType) {
                case 0: {
                    cal.add(12, 1);
                    continue block9;
                }
                case 1: {
                    cal.add(10, 1);
                    continue block9;
                }
                case 2: {
                    cal.add(5, 1);
                    continue block9;
                }
                case 3: {
                    cal.add(5, 7);
                    continue block9;
                }
                case 4: {
                    cal.add(2, 1);
                    continue block9;
                }
                case 5: {
                    cal.add(2, 3);
                    continue block9;
                }
                case 6: {
                    cal.add(1, 1);
                    continue block9;
                }
            }
            cal.add(1, 1);
        }
        return categories;
    }

    public static List<String> getCategoriesByTimeTypeFromStimeToEtime(Date startDate, Date endDate, Integer timeType) {
        return CategoriesUtil.getCategoriesByTimeTypeFromStimeToEtime(startDate, endDate, timeType, (Boolean)false);
    }

    public static List<String> getCategoriesByTimeTypeFromStimeToEtime(Date startDate, Date endDate, Integer timeType, Boolean isStartDayTheWeekSunday) {
        startDate = CategoriesUtil.getStartDate(timeType, startDate, endDate);
        ArrayList<String> categories = new ArrayList<String>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Calendar cal = Calendar.getInstance();
        cal.setFirstDayOfWeek(isStartDayTheWeekSunday != null && isStartDayTheWeekSunday != false ? 1 : 2);
        cal.setMinimalDaysInFirstWeek(4);
        cal.setTime(startDate);
        block9: while (!cal.getTime().after(endDate)) {
            String dateStr = sdf.format(cal.getTime());
            String timeStr = CategoriesUtil.getShowTimeStrByDateStr(dateStr, timeType, isStartDayTheWeekSunday);
            if (!categories.contains(timeStr)) {
                categories.add(timeStr);
            }
            switch (timeType) {
                case 0: {
                    cal.add(12, 1);
                    continue block9;
                }
                case 1: {
                    cal.add(10, 1);
                    continue block9;
                }
                case 2: {
                    cal.add(5, 1);
                    continue block9;
                }
                case 3: {
                    cal.add(5, 7);
                    continue block9;
                }
                case 4: {
                    cal.add(2, 1);
                    continue block9;
                }
                case 5: {
                    cal.add(2, 3);
                    continue block9;
                }
                case 6: {
                    cal.add(1, 1);
                    continue block9;
                }
            }
            cal.add(1, 1);
        }
        return categories;
    }

    public static List<String> getCategoriesByTimeTypeAndWorkerHourFromStimeToEtime(String stime, String etime, Integer timeType, Integer starthour, Integer endhour) {
        return CategoriesUtil.getCategoriesByTimeTypeAndWorkerHourFromStimeToEtime(stime, etime, timeType, starthour, endhour, false);
    }

    public static List<String> getCategoriesByTimeTypeAndWorkerHourFromStimeToEtime(String stime, String etime, Integer timeType, Integer starthour, Integer endhour, Boolean isStartDayTheWeekSunday) {
        ArrayList<String> categories = new ArrayList<String>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date startDate = TimeUtils.timeStrToDate(stime);
        Date endDate = TimeUtils.timeStrToDate(etime);
        startDate = CategoriesUtil.getStartDate(timeType, startDate, endDate);
        Calendar cal = Calendar.getInstance();
        cal.setFirstDayOfWeek(isStartDayTheWeekSunday != null && isStartDayTheWeekSunday != false ? 1 : 2);
        cal.setMinimalDaysInFirstWeek(4);
        cal.setTime(startDate);
        block9: while (!cal.getTime().after(endDate)) {
            String dateStr = sdf.format(cal.getTime());
            String timeStr = CategoriesUtil.getShowTimeStrByDateStr(dateStr, timeType, isStartDayTheWeekSunday);
            Integer hour = Integer.parseInt(TimeUtils.formatDate(cal.getTime(), "HH"));
            if (timeType == 1 && starthour != null && endhour != null) {
                if (hour >= starthour && hour <= endhour && !categories.contains(timeStr)) {
                    categories.add(timeStr);
                }
            } else if (!categories.contains(timeStr)) {
                categories.add(timeStr);
            }
            switch (timeType) {
                case 0: {
                    cal.add(12, 1);
                    continue block9;
                }
                case 1: {
                    cal.add(10, 1);
                    continue block9;
                }
                case 2: {
                    cal.add(5, 1);
                    continue block9;
                }
                case 3: {
                    cal.add(5, 7);
                    continue block9;
                }
                case 4: {
                    cal.add(2, 1);
                    continue block9;
                }
                case 5: {
                    cal.add(2, 3);
                    continue block9;
                }
                case 6: {
                    cal.add(1, 1);
                    continue block9;
                }
            }
            cal.add(1, 1);
        }
        return categories;
    }

    public static String getShowTimeStrByDateStr(String dateStr, int timeType) {
        return CategoriesUtil.getShowTimeStrByDateStr(dateStr, timeType, false);
    }

    public static String getShowTimeStrByDateStr(String dateStr, int timeType, Boolean isStartDayTheWeekSunday) {
        String output = null;
        Date date = TimeUtils.timeStrToDate(dateStr);
        Calendar cal = Calendar.getInstance();
        cal.setFirstDayOfWeek(isStartDayTheWeekSunday != null && isStartDayTheWeekSunday != false ? 1 : 2);
        cal.setMinimalDaysInFirstWeek(4);
        cal.setTime(date);
        switch (timeType) {
            case 0: {
                output = TimeUtils.formatDate(date, "yyyy-MM-dd HH:mm:00");
                break;
            }
            case 1: {
                output = TimeUtils.formatDate(date, "yyyy-MM-dd HH:00:00");
                break;
            }
            case 2: {
                output = dateStr.substring(0, 10);
                break;
            }
            case 3: {
                int weekNum = cal.get(3);
                String weekNumStr = weekNum < 10 ? "0" + weekNum : String.valueOf(weekNum);
                int m = cal.get(2);
                if (m + 1 == 12 && weekNum == 1) {
                    output = cal.get(1) + 1 + weekNumStr;
                    break;
                }
                if (m + 1 == 1 && weekNum > 50) {
                    output = cal.get(1) - 1 + weekNumStr;
                    break;
                }
                output = cal.get(1) + weekNumStr;
                break;
            }
            case 4: {
                int month = cal.get(2) + 1;
                output = cal.get(1) + "-" + month;
                break;
            }
            case 5: {
                output = cal.get(1) + "-" + (cal.get(2) / 3 + 1);
                break;
            }
            case 6: {
                output = cal.get(1) + "";
                break;
            }
            default: {
                output = TimeUtils.formatDate(date, "yyyy-MM-dd HH:00:00");
            }
        }
        return output;
    }

    public static String getShowTimeStrByDate(Date date, int timeType) {
        return CategoriesUtil.getShowTimeStrByDate(date, timeType, false);
    }

    public static String getShowTimeStrByDate(Date date, int timeType, Boolean isStartDayTheWeekSunday) {
        if (date == null) {
            return null;
        }
        String output = null;
        String dateStr = TimeUtils.formatDate(date, "yyyy-MM-dd HH:mm:ss");
        Calendar cal = Calendar.getInstance();
        cal.setFirstDayOfWeek(isStartDayTheWeekSunday != null && isStartDayTheWeekSunday != false ? 1 : 2);
        cal.setMinimalDaysInFirstWeek(4);
        cal.setTime(date);
        switch (timeType) {
            case 0: {
                output = TimeUtils.formatDate(date, "yyyy-MM-dd HH:mm:00");
                break;
            }
            case 1: {
                output = TimeUtils.formatDate(date, "yyyy-MM-dd HH:00:00");
                break;
            }
            case 2: {
                output = dateStr.substring(0, 10);
                break;
            }
            case 3: {
                int weekNum = cal.get(3);
                String weekNumStr = weekNum < 10 ? "0" + weekNum : String.valueOf(weekNum);
                int m = cal.get(2);
                if (m + 1 == 12 && weekNum == 1) {
                    output = cal.get(1) + 1 + weekNumStr;
                    break;
                }
                if (m + 1 == 1 && weekNum > 50) {
                    output = cal.get(1) - 1 + weekNumStr;
                    break;
                }
                output = cal.get(1) + weekNumStr;
                break;
            }
            case 4: {
                int month = cal.get(2) + 1;
                output = cal.get(1) + "-" + month;
                break;
            }
            case 5: {
                output = cal.get(1) + "-" + (cal.get(2) / 3 + 1);
                break;
            }
            case 6: {
                output = cal.get(1) + "";
                break;
            }
            default: {
                output = TimeUtils.formatDate(date, "yyyy-MM-dd HH:00:00");
            }
        }
        return output;
    }

    public static String getTimeIntervalByRecordTime(Date recordTime, Integer timeType) {
        if (recordTime == null || timeType == null) {
            return null;
        }
        if (timeType == 1) {
            String hour = TimeUtils.formatDate(recordTime, "HH");
            if ("00".equals(hour)) {
                return "23:00~24:00";
            }
            Integer h = Integer.parseInt(hour);
            String t = MessageFormat.format("{0}:00", h - 1);
            String t1 = t + MessageFormat.format("~{0}:00", h);
            return t1;
        }
        return null;
    }

    public static String getTimeIntervalByCreateTime(String createTime, Integer timeType) {
        if (createTime == null || timeType == null) {
            return null;
        }
        Date date = TimeUtils.parseDateStr(createTime, "yyyy-MM-dd HH:mm:ss");
        if (timeType == 1) {
            String hour = TimeUtils.formatDate(date, "HH");
            Integer h = Integer.parseInt(hour);
            String t = MessageFormat.format("{0}:00", h);
            String t1 = t + MessageFormat.format("~{0}:00", h + 1);
            return t1;
        }
        return null;
    }

    public static List<String> changeTimeCategories(List<String> categories, Integer timeType, CategoryChangeType categoryChangeType, Boolean isDeduplication) {
        return CategoriesUtil.changeTimeCategories(categories, timeType, categoryChangeType, isDeduplication, false);
    }

    public static List<String> changeTimeCategories(List<String> categories, Integer timeType, CategoryChangeType categoryChangeType, Boolean isDeduplication, Boolean isStartDayTheWeekSunday) {
        if (CollectionUtils.isEmpty(categories) || timeType == null || categoryChangeType == null) {
            return categories;
        }
        if (isDeduplication == null) {
            isDeduplication = false;
        }
        Locale locale = categoryChangeType.getLocale();
        ArrayList<String> categoriesNew = new ArrayList<String>();
        for (String category : categories) {
            String[] categoryArr = null;
            if (timeType == 4 || timeType == 5) {
                categoryArr = category.split("-");
            }
            switch (timeType) {
                case 0: {
                    break;
                }
                case 1: {
                    String hour;
                    Date t;
                    if (categoryChangeType.getHourChangeType() == 0) {
                        t = TimeUtils.parseDateStr(category, "yyyy-MM-dd HH:mm:ss");
                        hour = TimeUtils.formatDate(t, "HH");
                        category = Integer.parseInt(hour) + 1 + ":00";
                        break;
                    }
                    if (categoryChangeType.getHourChangeType() == 2) {
                        t = TimeUtils.parseDateStr(category, "yyyy-MM-dd HH:mm:ss");
                        hour = TimeUtils.formatDate(t, "HH");
                        category = Integer.parseInt(hour) + ":00~" + (Integer.parseInt(hour) + 1) + ":00";
                        break;
                    }
                    if (categoryChangeType.getHourChangeType() == 3) {
                        category = TimeUtils.addOneHour(category);
                        break;
                    }
                    if (categoryChangeType.getHourChangeType() == 1) {
                        t = TimeUtils.parseDateStr(category, "yyyy-MM-dd HH:mm:ss");
                        hour = TimeUtils.formatDate(t, "HH");
                        category = Integer.parseInt(hour) + 1 + "";
                        break;
                    }
                    t = TimeUtils.parseDateStr(category, "yyyy-MM-dd HH:mm:ss");
                    hour = TimeUtils.formatDate(t, "HH");
                    category = Integer.parseInt(hour) + 1 + ":00";
                    break;
                }
                case 2: {
                    if (categoryChangeType.getDayChangeType() != 0) break;
                    Date d = TimeUtils.parseDateStr(category, "yyyy-MM-dd");
                    String month = TimeUtils.formatDate(d, "MM");
                    Integer day = Integer.parseInt(TimeUtils.formatDate(d, "dd"));
                    if (CategoriesUtil.isEnglish(categoryChangeType.getLocale()).booleanValue()) {
                        String showMonth = messageSource.getMessage("passenger.momth.name." + month, null, locale);
                        String suffix = CategoriesUtil.getSuffix(day);
                        category = showMonth + " " + day + suffix;
                        break;
                    }
                    category = messageSource.getMessage("passenger.day.showname", new Object[]{Integer.parseInt(month), day}, locale);
                    break;
                }
                case 3: {
                    if (categoryChangeType.getWeekChangeType() == 1) {
                        category = messageSource.getMessage("passenger.week.have.year.showname", new Object[]{category.substring(0, 4), Integer.parseInt(category.substring(4, 6))}, locale);
                        break;
                    }
                    if (categoryChangeType.getWeekChangeType() == 2) {
                        category = messageSource.getMessage("passenger.week.have.year.month.day.showname", new Object[]{category.substring(0, 4), Integer.parseInt(category.substring(4, 6)), CategoriesUtil.getLocalDateByYearWeek(category, 1L, isStartDayTheWeekSunday).getMonthValue(), CategoriesUtil.getLocalDateByYearWeek(category, 1L, isStartDayTheWeekSunday).getDayOfMonth(), CategoriesUtil.getLocalDateByYearWeek(category, 7L, isStartDayTheWeekSunday).getMonthValue(), CategoriesUtil.getLocalDateByYearWeek(category, 7L, isStartDayTheWeekSunday).getDayOfMonth()}, locale);
                        break;
                    }
                    category = messageSource.getMessage("passenger.week.without.year.showname", new Object[]{Integer.parseInt(category.substring(4, 6))}, locale);
                    break;
                }
                case 4: {
                    if (categoryChangeType.getMonthChangeType() == 1) {
                        Integer month = Integer.parseInt(categoryArr[1]);
                        String monthStr = month < 10 ? "0" + month : String.valueOf(month);
                        category = messageSource.getMessage("passenger.momth.name." + monthStr, null, locale);
                        break;
                    }
                    category = messageSource.getMessage("passenger.momth.showname." + categoryArr[1], new Object[]{categoryArr[0]}, locale);
                    break;
                }
                case 5: {
                    category = messageSource.getMessage("passenger.quarter.have.year.showname", new Object[]{categoryArr[0], categoryArr[1]}, locale);
                    break;
                }
                case 6: {
                    category = messageSource.getMessage("passenger.year.showname", new Object[]{category}, locale);
                }
            }
            if (isDeduplication.booleanValue()) {
                if (categoriesNew.contains(category)) continue;
                categoriesNew.add(category);
                continue;
            }
            categoriesNew.add(category);
        }
        return categoriesNew;
    }

    private static LocalDate getLocalDateByYearWeek(String category, long newValue, Boolean isStartDayTheWeekSunday) {
        int year = Integer.valueOf(category.substring(0, 4));
        int week = Integer.valueOf(category.substring(4, 6));
        WeekFields weekFields = isStartDayTheWeekSunday != null && isStartDayTheWeekSunday != false ? WeekFields.of(DayOfWeek.SUNDAY, 4) : WeekFields.ISO;
        LocalDate now = LocalDate.now();
        LocalDate localDate = now.withYear(year).with(weekFields.weekOfYear(), week);
        LocalDate localDate1 = localDate.with(weekFields.dayOfWeek(), newValue);
        return localDate1;
    }

    private static String getSuffix(Integer day) {
        String suffix = "th";
        if (day == 1 || day == 21 || day == 31) {
            suffix = "st";
        } else if (day == 2 || day == 22) {
            suffix = "nd";
        } else if (day == 3 || day == 23) {
            suffix = "rd";
        }
        return suffix;
    }

    private static Boolean isEnglish(Locale locale) {
        if (locale == null) {
            return false;
        }
        return locale.equals(Locale.US);
    }

    public static String changeTimeCategory(String category, Integer timeType, CategoryChangeType categoryChangeType) {
        return CategoriesUtil.changeTimeCategory(category, timeType, categoryChangeType, false);
    }

    public static String changeTimeCategory(String category, Integer timeType, CategoryChangeType categoryChangeType, Boolean isStartDayTheWeekSunday) {
        if (StringUtils.isBlank((CharSequence)category) || timeType == null || categoryChangeType == null || category.equals("total")) {
            return category;
        }
        Locale locale = categoryChangeType.getLocale();
        String[] categoryArr = null;
        if (timeType == 4 || timeType == 5) {
            categoryArr = category.split("-");
        }
        switch (timeType) {
            case 0: {
                return category;
            }
            case 1: {
                if (categoryChangeType.getHourChangeType() == 0) {
                    Date t = TimeUtils.parseDateStr(category, "yyyy-MM-dd HH:mm:ss");
                    String hour = TimeUtils.formatDate(t, "HH");
                    category = Integer.parseInt(hour) + 1 + ":00";
                } else if (categoryChangeType.getHourChangeType() == 2) {
                    Date t = TimeUtils.parseDateStr(category, "yyyy-MM-dd HH:mm:ss");
                    String hour = TimeUtils.formatDate(t, "HH");
                    category = Integer.parseInt(hour) + ":00~" + (Integer.parseInt(hour) + 1) + ":00";
                } else if (categoryChangeType.getHourChangeType() == 3) {
                    category = TimeUtils.addOneHour(category);
                } else if (categoryChangeType.getHourChangeType() == 1) {
                    Date t = TimeUtils.parseDateStr(category, "yyyy-MM-dd HH:mm:ss");
                    String hour = TimeUtils.formatDate(t, "HH");
                    category = Integer.parseInt(hour) + 1 + "";
                } else {
                    Date t = TimeUtils.parseDateStr(category, "yyyy-MM-dd HH:mm:ss");
                    String hour = TimeUtils.formatDate(t, "HH");
                    category = Integer.parseInt(hour) + 1 + ":00";
                }
                return category;
            }
            case 2: {
                if (categoryChangeType.getDayChangeType() == 0) {
                    Date d = TimeUtils.parseDateStr(category, "yyyy-MM-dd");
                    String month = TimeUtils.formatDate(d, "MM");
                    Integer day = Integer.parseInt(TimeUtils.formatDate(d, "dd"));
                    if (CategoriesUtil.isEnglish(categoryChangeType.getLocale()).booleanValue()) {
                        String showMonth = messageSource.getMessage("passenger.momth.name." + month, null, locale);
                        String suffix = CategoriesUtil.getSuffix(day);
                        return showMonth + " " + day + suffix;
                    }
                    return messageSource.getMessage("passenger.day.showname", new Object[]{Integer.parseInt(month), day}, locale);
                }
                if (categoryChangeType.getDayChangeType() == 1) {
                    return category;
                }
            }
            case 3: {
                if (categoryChangeType.getWeekChangeType() == 1) {
                    return messageSource.getMessage("passenger.week.have.year.showname", new Object[]{category.substring(0, 4), Integer.parseInt(category.substring(4, 6))}, locale);
                }
                if (categoryChangeType.getWeekChangeType() == 2) {
                    return messageSource.getMessage("passenger.week.have.year.month.day.showname", new Object[]{category.substring(0, 4), Integer.parseInt(category.substring(4, 6)), CategoriesUtil.getLocalDateByYearWeek(category, 1L, isStartDayTheWeekSunday).getMonthValue(), CategoriesUtil.getLocalDateByYearWeek(category, 1L, isStartDayTheWeekSunday).getDayOfMonth(), CategoriesUtil.getLocalDateByYearWeek(category, 7L, isStartDayTheWeekSunday).getMonthValue(), CategoriesUtil.getLocalDateByYearWeek(category, 7L, isStartDayTheWeekSunday).getDayOfMonth()}, locale);
                }
                return messageSource.getMessage("passenger.week.without.year.showname", new Object[]{Integer.parseInt(category.substring(4, 6))}, locale);
            }
            case 4: {
                if (categoryChangeType.getMonthChangeType() == 1) {
                    Integer month = Integer.parseInt(categoryArr[1]);
                    String monthStr = month < 10 ? "0" + month : String.valueOf(month);
                    return messageSource.getMessage("passenger.momth.name." + monthStr, null, locale);
                }
                return messageSource.getMessage("passenger.momth.showname." + categoryArr[1], new Object[]{categoryArr[0]}, locale);
            }
            case 5: {
                return messageSource.getMessage("passenger.quarter.have.year.showname", new Object[]{categoryArr[0], categoryArr[1]}, locale);
            }
            case 6: {
                return messageSource.getMessage("passenger.year.showname", new Object[]{category}, locale);
            }
        }
        return category;
    }

    public static String getCompareToTime(String time, Integer timeType) {
        String[] arr;
        if (StringUtils.isBlank((CharSequence)time) || timeType == null) {
            return null;
        }
        if (timeType == 4 && Integer.parseInt((arr = time.split("-"))[1]) < 10) {
            return arr[0] + "-0" + arr[1];
        }
        return time;
    }

    public static Integer compareToTime(String time1, String time2, Integer timeType) {
        return CategoriesUtil.getCompareToTime(time1, timeType).compareTo(CategoriesUtil.getCompareToTime(time2, timeType));
    }

    public static List<Pair<String, List<String>>> getCategoryDates(String stime, String etime, Integer timeType) {
        return CategoriesUtil.getCategoryDates(stime, etime, timeType, false);
    }

    public static List<Pair<String, List<String>>> getCategoryDates(String stime, String etime, Integer timeType, Boolean isStartDayTheWeekSunday) {
        ArrayList<Pair<String, List<String>>> categories = new ArrayList<Pair<String, List<String>>>();
        Date startDate = TimeUtils.timeStrToDate(stime);
        Date endDate = TimeUtils.timeStrToDate(etime);
        startDate = CategoriesUtil.getStartDate(timeType, startDate, endDate);
        Calendar cal = Calendar.getInstance();
        cal.setFirstDayOfWeek(isStartDayTheWeekSunday != null && isStartDayTheWeekSunday != false ? 1 : 2);
        cal.setMinimalDaysInFirstWeek(4);
        cal.setTime(startDate);
        while (!cal.getTime().after(endDate)) {
            Date sDate = cal.getTime();
            String timeStr = CategoriesUtil.getShowTimeStrByDate(sDate, timeType, isStartDayTheWeekSunday);
            switch (timeType) {
                case 2: {
                    cal.add(5, 1);
                    break;
                }
                case 3: {
                    cal.add(5, 7);
                    break;
                }
                case 4: {
                    cal.add(2, 1);
                    break;
                }
                case 5: {
                    cal.add(2, 3);
                    break;
                }
                case 6: {
                    cal.add(1, 1);
                    break;
                }
                default: {
                    cal.add(1, 1);
                }
            }
            Date eDate = cal.getTime();
            categories.add((Pair<String, List<String>>)new Pair((Object)timeStr, CategoriesUtil.getCategoriesByTimeTypeFromStimeToEtime(sDate, TimeUtils.addSecond(eDate, -1), (Integer)2)));
        }
        return categories;
    }

    public static String getLimitStartTime(Integer timeType, String startTime, String endTime) {
        Date startDate = TimeUtils.timeStrToDate(startTime);
        Date endDate = TimeUtils.timeStrToDate(endTime);
        startDate = CategoriesUtil.getStartDate(timeType, startDate, endDate);
        return TimeUtils.formatLongDate(startDate);
    }

    public static Date getStartDate(Integer timeType, Date startDate, Date endDate) {
        if (timeType == 0) {
            if (endDate.getTime() - startDate.getTime() > 86400000L) {
                startDate = TimeUtils.getStartTimeOfDay(endDate);
            }
        } else if (timeType == 1) {
            if (endDate.getTime() - startDate.getTime() > 2678400000L) {
                startDate = TimeUtils.getStartTimeOfDay(TimeUtils.addDay(endDate, -30));
            }
        } else if (timeType == 2) {
            if (endDate.getTime() - startDate.getTime() > 63244800000L) {
                startDate = TimeUtils.getStartTimeOfDay(TimeUtils.addYear(endDate, -2));
            }
        } else {
            Date firstDay = TimeUtils.timeStrToDate("2013-01-01 00:00:00");
            if (startDate.before(firstDay)) {
                startDate = firstDay;
            }
        }
        return startDate;
    }

    public static Map<String, Pair<Date, Date>> getCategoryPeriods(String stime, String etime, Integer timeType, Integer starthour, Integer endhour, Boolean isStartDayTheWeekSunday) {
        HashMap<String, Pair<Date, Date>> res = new HashMap<String, Pair<Date, Date>>();
        Date startDate = TimeUtils.timeStrToDate(stime);
        Date endDate = TimeUtils.timeStrToDate(etime);
        startDate = CategoriesUtil.getStartDate(timeType, startDate, endDate);
        Calendar cal = Calendar.getInstance();
        cal.setFirstDayOfWeek(isStartDayTheWeekSunday != null && isStartDayTheWeekSunday != false ? 1 : 2);
        cal.setMinimalDaysInFirstWeek(4);
        cal.setTime(startDate);
        while (!cal.getTime().after(endDate)) {
            Date sdate = cal.getTime();
            String timeStr = CategoriesUtil.getShowTimeStrByDate(sdate, timeType, isStartDayTheWeekSunday);
            switch (timeType) {
                case 0: {
                    cal.add(12, 1);
                    break;
                }
                case 1: {
                    cal.add(10, 1);
                    break;
                }
                case 2: {
                    cal.add(5, 1);
                    break;
                }
                case 3: {
                    cal.add(5, 7);
                    break;
                }
                case 4: {
                    cal.add(2, 1);
                    break;
                }
                case 5: {
                    cal.add(2, 3);
                    break;
                }
                case 6: {
                    cal.add(1, 1);
                    break;
                }
                default: {
                    cal.add(1, 1);
                }
            }
            Date eDate = cal.getTime();
            Integer hour = Integer.parseInt(TimeUtils.formatDate(sdate, "HH"));
            if (timeType == 1 && starthour != null && endhour != null) {
                if (hour < starthour || hour > endhour || res.containsKey(timeStr)) continue;
                res.put(timeStr, (Pair<Date, Date>)new Pair((Object)sdate, (Object)TimeUtils.addSecond(eDate, -1)));
                continue;
            }
            if (res.containsKey(timeStr)) continue;
            res.put(timeStr, (Pair<Date, Date>)new Pair((Object)sdate, (Object)TimeUtils.addSecond(eDate, -1)));
        }
        return res;
    }

    public static List<Pair<String, Pair<Date, Date>>> getCategoryPeriodList(String stime, String etime, Integer timeType, Integer starthour, Integer endhour, Boolean isStartDayTheWeekSunday) {
        ArrayList<Pair<String, Pair<Date, Date>>> res = new ArrayList<Pair<String, Pair<Date, Date>>>();
        Date startDate = TimeUtils.timeStrToDate(stime);
        Date endDate = TimeUtils.timeStrToDate(etime);
        startDate = CategoriesUtil.getStartDate(timeType, startDate, endDate);
        Calendar cal = Calendar.getInstance();
        cal.setFirstDayOfWeek(isStartDayTheWeekSunday != null && isStartDayTheWeekSunday != false ? 1 : 2);
        cal.setMinimalDaysInFirstWeek(4);
        cal.setTime(startDate);
        while (!cal.getTime().after(endDate)) {
            Date sdate = cal.getTime();
            String timeStr = CategoriesUtil.getShowTimeStrByDate(sdate, timeType, isStartDayTheWeekSunday);
            switch (timeType) {
                case 0: {
                    cal.add(12, 1);
                    break;
                }
                case 1: {
                    cal.add(10, 1);
                    break;
                }
                case 2: {
                    cal.add(5, 1);
                    break;
                }
                case 3: {
                    cal.add(5, 7);
                    break;
                }
                case 4: {
                    cal.add(2, 1);
                    break;
                }
                case 5: {
                    cal.add(2, 3);
                    break;
                }
                case 6: {
                    cal.add(1, 1);
                    break;
                }
                default: {
                    cal.add(1, 1);
                }
            }
            Date eDate = cal.getTime();
            Integer hour = Integer.parseInt(TimeUtils.formatDate(sdate, "HH"));
            if (timeType == 1 && starthour != null && endhour != null) {
                if (hour < starthour || hour > endhour) continue;
                res.add((Pair<String, Pair<Date, Date>>)new Pair((Object)timeStr, (Object)new Pair((Object)sdate, (Object)TimeUtils.addSecond(eDate, -1))));
                continue;
            }
            res.add((Pair<String, Pair<Date, Date>>)new Pair((Object)timeStr, (Object)new Pair((Object)sdate, (Object)TimeUtils.addSecond(eDate, -1))));
        }
        return res;
    }

    public static String hourPeriod(String hour) {
        if (StringUtils.isBlank((CharSequence)hour)) {
            return null;
        }
        Integer h = null;
        try {
            h = Integer.parseInt(hour);
        }
        catch (NumberFormatException e) {
            log.error("hourPeriod parseInt error", (Throwable)e);
            return null;
        }
        String thisHour = h < 10 ? "0" + h : h + "";
        String s = ":00";
        String hAdd1 = h + 1 < 10 ? "0" + (h + 1) : h + 1 + "";
        return StrUtil.concat((boolean)true, (CharSequence[])new CharSequence[]{thisHour, s, "-", hAdd1, s});
    }

    public static String foreignHour(String hour) {
        Integer h = Integer.parseInt(hour);
        String am = "am";
        String pm = "pm";
        String hAm = h < 12 ? h + am : h - 12 + pm;
        String hAdd1 = h + 1 <= 12 ? h + 1 + am : h + 1 - 12 + pm;
        return StrUtil.concat((boolean)true, (CharSequence[])new CharSequence[]{hAm, "-", hAdd1});
    }

    public static List<Pair<String, List<String>>> getHourlyTimeSlots(String stime, String etime, Integer startHour, Integer endHour) {
        Date startDate = TimeUtils.timeStrToDate(stime);
        Date endDate = TimeUtils.timeStrToDate(etime);
        ArrayList<Pair<String, List<String>>> timeSlots = new ArrayList<Pair<String, List<String>>>();
        for (int hour = startHour.intValue(); hour <= endHour; ++hour) {
            String timeSlot = hour + ":00-" + (hour + 1) + ":00";
            ArrayList<String> dateTimes = new ArrayList<String>();
            Date currentDate = startDate;
            while (!currentDate.after(endDate)) {
                String dateTime = TimeUtils.formatDate(currentDate, "yyyy-MM-dd") + " " + String.format("%02d", hour) + ":00:00";
                dateTimes.add(dateTime);
                currentDate = TimeUtils.addDay(currentDate, 1);
            }
            timeSlots.add((Pair<String, List<String>>)new Pair((Object)timeSlot, dateTimes));
        }
        return timeSlots;
    }

    public static String convertHourToRangeHour(String timeStr) {
        String[] parts = timeStr.split(":");
        if (parts.length != 3) {
            throw new IllegalArgumentException("\u65f6\u95f4\u683c\u5f0f\u9519\u8bef!");
        }
        int hour = Integer.parseInt(parts[0]);
        int nextHour = hour + 1;
        return String.format("%d:00-%d:00", hour, nextHour);
    }
}

