/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.passenger.util;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.lang.Pair;
import com.ovopark.organize.common.model.pojo.DepartmentPojo;
import com.ovopark.passenger.exception.BizException;
import com.ovopark.passenger.exception.ResultCodeEnum;
import com.ovopark.passenger.pojo.Authenticator;
import com.ovopark.passenger.util.CategoriesUtil;
import com.ovopark.passenger.util.LocalDateTimeUtils;
import com.ovopark.pojo.BusinessTimeParamDto;
import com.ovopark.pojo.BusinessTimePojo;
import com.ovopark.pojo.BusinessTimeWeekParamDto;
import com.ovopark.pojo.BusinessTimeWeekPojo;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.TimeZone;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeUtils {
    private static final Logger log = LoggerFactory.getLogger(TimeUtils.class);
    public static final String LONG_FORMAT_PATTERN = "yyyy-MM-dd HH:mm:ss";
    public static final String SHORT_FORMAT_PATTERN = "yyyy-MM-dd";
    public static final String SHORT_FORMAT_CHINESE_PATTERN = "yyyy\u5e74MM\u6708dd\u65e5";
    public static final String LONG_NO_SEPARATION = "yyyyMMddHHmmss";
    public static final String HOUR_NO_SEPARATION = "yyyyMMddHH";
    public static final Integer STARTHOUR = 0;
    public static final Integer ENDHOUR = 24;
    public static final String START_MOMENT = "00:00";
    public static final String END_MOMENT = "24:00";
    public static final int BEFORE_BUSINESS_TIME = 0;
    public static final int ON_BUSINESS_TIME = 1;
    public static final int AFTER_BUSINESS_TIME = 2;

    public static Date parseDateStr(String time, String formatPattern) {
        if (StringUtils.isBlank((CharSequence)time) || StringUtils.isBlank((CharSequence)formatPattern)) {
            throw new RuntimeException("\u4f20\u5165\u53c2\u6570\u5f02\u5e38\uff0c\u65e5\u671f\u5b57\u7b26\u4e32parse\u62a5\u9519");
        }
        SimpleDateFormat f = new SimpleDateFormat(formatPattern);
        try {
            return f.parse(time);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String formatLongDate(Date date) {
        return TimeUtils.formatDate(date, LONG_FORMAT_PATTERN);
    }

    public static String formatShortDate(Date date) {
        return TimeUtils.formatDate(date, SHORT_FORMAT_PATTERN);
    }

    public static String formatShortChineseDate(Date date) {
        return TimeUtils.formatDate(date, SHORT_FORMAT_CHINESE_PATTERN);
    }

    public static String formatDate(Date date, String formatPattern) {
        if (date == null || StringUtils.isBlank((CharSequence)formatPattern)) {
            throw new RuntimeException("\u4f20\u5165\u53c2\u6570\u5f02\u5e38\uff0c\u65e5\u671fformat\u62a5\u9519");
        }
        SimpleDateFormat sdf = new SimpleDateFormat(formatPattern);
        return sdf.format(date);
    }

    public static String formatDateTime(long time, String format) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        return sdf.format(new Date(time));
    }

    public static Date timeStrToDate(String time) {
        if (StringUtils.isEmpty((CharSequence)time)) {
            return null;
        }
        int shortLen = SHORT_FORMAT_PATTERN.length();
        int longLen = LONG_FORMAT_PATTERN.length();
        if (time.length() == shortLen) {
            return TimeUtils.parseDateStr(time, SHORT_FORMAT_PATTERN);
        }
        if (time.length() == longLen) {
            return TimeUtils.parseDateStr(time, LONG_FORMAT_PATTERN);
        }
        if (time.length() == 13) {
            return new Date(Long.valueOf(time));
        }
        return null;
    }

    public static Date timeStr2Date(String time) {
        if (StringUtils.isBlank((CharSequence)time)) {
            return null;
        }
        try {
            if (TimeUtils.isValidDatePattern(time)) {
                return TimeUtils.parseDateStr(time, SHORT_FORMAT_PATTERN);
            }
            if (TimeUtils.isValidDateTimePattern(time)) {
                return TimeUtils.parseDateStr(time, LONG_FORMAT_PATTERN);
            }
            if (time.length() == 13) {
                return new Date(Long.valueOf(time));
            }
            if (time.length() == 10) {
                return new Date(Long.valueOf(time) * 1000L);
            }
        }
        catch (NumberFormatException e) {
            log.error("timeStr2Date error", (Throwable)e);
        }
        return null;
    }

    public static boolean isValidDatePattern(String dateStr) {
        String regex = "^\\d{4}-\\d{2}-\\d{2}$";
        return dateStr.matches(regex);
    }

    public static boolean isValidDateTimePattern(String dateTimeStr) {
        String regex = "^\\d{4}-\\d{2}-\\d{2} \\d{2}:\\d{2}:\\d{2}$";
        return dateTimeStr.matches(regex);
    }

    public static Date getEndTimeOfDay(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date getStartTimeOfDay(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date getFixedHourTimeOfDay(Date date, Integer hour, Integer minute) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(11, hour);
        cal.set(12, minute);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date getFirstDayOnThisCycleByTimeAndTimeType(Date date, Integer timeType) {
        return TimeUtils.getFirstDayOnThisCycleByTimeAndTimeType(date, timeType, false);
    }

    public static Date getFirstDayOnThisCycleByTimeAndTimeType(Date date, Integer timeType, Boolean isStartDayTheWeekSunday) {
        if (date == null || timeType == null) {
            return null;
        }
        switch (timeType) {
            case 0: 
            case 1: 
            case 2: {
                return date;
            }
            case 3: {
                return TimeUtils.getStartDayOfWeek(date, isStartDayTheWeekSunday);
            }
            case 4: {
                return TimeUtils.getStartDayOfMonth(date);
            }
            case 5: {
                return TimeUtils.getStartDayOfQuarter(date);
            }
            case 6: {
                return TimeUtils.getStartDayOfYear(date);
            }
        }
        return null;
    }

    public static Date getEndDayOnThisCycleByTimeAndTimeType(Date date, Integer timeType) {
        return TimeUtils.getEndDayOnThisCycleByTimeAndTimeType(date, timeType, false);
    }

    public static Date getEndDayOnThisCycleByTimeAndTimeType(Date date, Integer timeType, Boolean isStartDayTheWeekSunday) {
        if (date == null || timeType == null) {
            return null;
        }
        switch (timeType) {
            case 0: 
            case 1: 
            case 2: {
                return date;
            }
            case 3: {
                return TimeUtils.getEndDayOfWeek(date, isStartDayTheWeekSunday);
            }
            case 4: {
                return TimeUtils.getEndDayOfMonth(date);
            }
            case 5: {
                return TimeUtils.getEndDayOfQuarter(date);
            }
            case 6: {
                return TimeUtils.getEndDayOfYear(date);
            }
        }
        return null;
    }

    public static Date getStartDayOfWeek(Date date, Boolean isStartDayTheWeekSunday) {
        int d = 0;
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int dayOfWeek = cal.get(7);
        d = isStartDayTheWeekSunday != null && isStartDayTheWeekSunday != false ? 1 - dayOfWeek : (dayOfWeek == 1 ? -6 : 2 - dayOfWeek);
        cal.add(7, d);
        return cal.getTime();
    }

    public static Date getEndDayOfWeek(Date date, Boolean isStartDayTheWeekSunday) {
        int d = 0;
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int dayOfWeek = cal.get(7);
        d = isStartDayTheWeekSunday != null && isStartDayTheWeekSunday != false ? 1 - dayOfWeek : (dayOfWeek == 1 ? -6 : 2 - dayOfWeek);
        cal.add(7, d + 6);
        return cal.getTime();
    }

    public static Date getStartDayOfMonth(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(5, 1);
        return cal.getTime();
    }

    public static Date getEndDayOfMonth(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int maxDay = cal.getActualMaximum(5);
        cal.set(5, maxDay);
        return cal.getTime();
    }

    public static Date getStartDayOfQuarter(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int d = 0;
        int month = cal.get(2) + 1;
        if (month % 3 == 0) {
            d = -2;
        } else if (month % 3 == 1) {
            d = 0;
        } else if (month % 3 == 2) {
            d = -1;
        }
        cal.add(2, d);
        cal.set(5, 1);
        return cal.getTime();
    }

    public static Date getEndDayOfQuarter(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int d = 0;
        int month = cal.get(2) + 1;
        if (month % 3 == 0) {
            d = -2;
        } else if (month % 3 == 1) {
            d = 0;
        } else if (month % 3 == 2) {
            d = -1;
        }
        cal.add(2, d + 2);
        cal.set(5, cal.getActualMaximum(5));
        return cal.getTime();
    }

    public static Date getStartDayOfYear(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(6, 1);
        return cal.getTime();
    }

    public static Date getEndDayOfYear(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(6, cal.getActualMaximum(6));
        return cal.getTime();
    }

    public static String getPreviousCycleStartTimeStr(String dateStr, Integer timeType) {
        if (StringUtils.isBlank((CharSequence)dateStr) || timeType == null) {
            return null;
        }
        Date date = TimeUtils.timeStrToDate(dateStr);
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        switch (timeType) {
            case 0: 
            case 1: {
                cal.add(10, -1);
                return TimeUtils.formatDate(cal.getTime(), LONG_FORMAT_PATTERN);
            }
            case 2: {
                cal.add(5, -1);
                return TimeUtils.formatDate(cal.getTime(), LONG_FORMAT_PATTERN);
            }
            case 3: {
                cal.add(7, -7);
                return TimeUtils.formatDate(cal.getTime(), LONG_FORMAT_PATTERN);
            }
            case 4: {
                cal.add(2, -1);
                return TimeUtils.formatDate(cal.getTime(), LONG_FORMAT_PATTERN);
            }
            case 5: {
                cal.add(2, -3);
                return TimeUtils.formatDate(cal.getTime(), LONG_FORMAT_PATTERN);
            }
            case 6: {
                cal.add(1, -1);
                return TimeUtils.formatDate(cal.getTime(), LONG_FORMAT_PATTERN);
            }
        }
        return null;
    }

    public static String getPreviousCycleEndTimeStr(String dateStr, Integer timeType) {
        if (StringUtils.isBlank((CharSequence)dateStr) || timeType == null) {
            return null;
        }
        Date date = TimeUtils.timeStrToDate(dateStr);
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        switch (timeType) {
            case 0: 
            case 1: {
                cal.add(10, -1);
                return TimeUtils.formatDate(cal.getTime(), LONG_FORMAT_PATTERN);
            }
            case 2: {
                cal.add(5, -1);
                return TimeUtils.formatDate(cal.getTime(), LONG_FORMAT_PATTERN);
            }
            case 3: {
                cal.add(7, -7);
                return TimeUtils.formatDate(cal.getTime(), LONG_FORMAT_PATTERN);
            }
            case 4: {
                cal.add(2, -1);
                return TimeUtils.formatDate(TimeUtils.getEndDayOfMonth(cal.getTime()), LONG_FORMAT_PATTERN);
            }
            case 5: {
                cal.add(2, -3);
                return TimeUtils.formatDate(TimeUtils.getEndDayOfMonth(cal.getTime()), LONG_FORMAT_PATTERN);
            }
            case 6: {
                cal.add(1, -1);
                return TimeUtils.formatDate(TimeUtils.getEndDayOfMonth(cal.getTime()), LONG_FORMAT_PATTERN);
            }
        }
        return null;
    }

    public static String getPreviousCycleThisTimeStr(String dateStr, Integer timeType) {
        if (StringUtils.isBlank((CharSequence)dateStr) || timeType == null) {
            return null;
        }
        Date date = TimeUtils.timeStrToDate(dateStr);
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        switch (timeType) {
            case 0: 
            case 1: {
                cal.add(10, -1);
                return TimeUtils.formatDate(cal.getTime(), LONG_FORMAT_PATTERN);
            }
            case 2: {
                cal.add(5, -1);
                return TimeUtils.formatDate(cal.getTime(), LONG_FORMAT_PATTERN);
            }
            case 3: {
                cal.add(7, -7);
                return TimeUtils.formatDate(cal.getTime(), LONG_FORMAT_PATTERN);
            }
            case 4: {
                cal.add(2, -1);
                return TimeUtils.formatDate(cal.getTime(), LONG_FORMAT_PATTERN);
            }
            case 5: {
                cal.add(2, -3);
                return TimeUtils.formatDate(cal.getTime(), LONG_FORMAT_PATTERN);
            }
            case 6: {
                cal.add(1, -1);
                return TimeUtils.formatDate(cal.getTime(), LONG_FORMAT_PATTERN);
            }
        }
        return null;
    }

    public static String getPreviousYearStartTimeStr(String dateStr, Integer timeType) {
        if (StringUtils.isBlank((CharSequence)dateStr) || timeType == null) {
            return null;
        }
        Date date = TimeUtils.timeStrToDate(dateStr);
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(1, -1);
        return TimeUtils.formatDate(cal.getTime(), LONG_FORMAT_PATTERN);
    }

    public static String getPreviousYearEndTimeStr(String dateStr, Integer timeType) {
        if (StringUtils.isBlank((CharSequence)dateStr) || timeType == null) {
            return null;
        }
        Date date = TimeUtils.timeStrToDate(dateStr);
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(1, -1);
        return TimeUtils.formatDate(cal.getTime(), LONG_FORMAT_PATTERN);
    }

    public static String getHourStrByTimeNotStartWithZero(Date date) {
        if (date == null) {
            return null;
        }
        String hour = TimeUtils.formatDate(date, "HH");
        if (hour.startsWith("0")) {
            hour = hour.substring(1, 2);
        }
        return hour;
    }

    public static Boolean isEndDayOfMonth(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(5) == cal.getActualMaximum(5);
    }

    public static Integer getTrendTimeType(Integer timeType) {
        if (timeType == null) {
            return 2;
        }
        switch (timeType) {
            case 1: 
            case 2: {
                return 1;
            }
            case 3: 
            case 4: {
                return 2;
            }
            case 5: 
            case 6: {
                return 4;
            }
        }
        return null;
    }

    public static String addOneHour(String str) {
        Date date = TimeUtils.timeStrToDate(str);
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(11, 1);
        return TimeUtils.formatDate(cal.getTime(), "yyyy-MM-dd HH:00:00");
    }

    public static Integer determineInTimeIntervalSite(Date time, Date startTime, Date endTime) {
        Calendar date = Calendar.getInstance();
        date.setTime(time);
        Calendar begin = Calendar.getInstance();
        begin.setTime(startTime);
        Calendar end = Calendar.getInstance();
        end.setTime(endTime);
        if (date.before(begin)) {
            return -1;
        }
        if (date.after(end)) {
            return 1;
        }
        return 0;
    }

    public static Integer getWeekNumOfYear(Date date, Boolean isStartDayTheWeekSunday) {
        Calendar cal = Calendar.getInstance();
        cal.setFirstDayOfWeek(isStartDayTheWeekSunday != null && isStartDayTheWeekSunday != false ? 1 : 2);
        cal.setMinimalDaysInFirstWeek(4);
        cal.setTime(date);
        if (cal.get(3) == 1 && DateUtil.isSameDay((Date)date, (Date)DateUtil.endOfDay((Date)date))) {
            cal.add(3, -1);
        }
        return cal.get(3);
    }

    private static Calendar getCalendarFormYear(int year, Boolean isStartDayTheWeekSunday) {
        Calendar cal = Calendar.getInstance();
        cal.setFirstDayOfWeek(isStartDayTheWeekSunday != null && isStartDayTheWeekSunday != false ? 1 : 2);
        cal.setMinimalDaysInFirstWeek(4);
        cal.set(7, 2);
        cal.set(1, year);
        return cal;
    }

    public static Date getEndDayOfWeekNo(int year, int weekNo, Boolean isStartDayTheWeekSunday) {
        Calendar cal = TimeUtils.getCalendarFormYear(year, isStartDayTheWeekSunday);
        int maxWeekNum = cal.getActualMaximum(3);
        if (maxWeekNum < weekNo) {
            weekNo = maxWeekNum;
        }
        cal.set(3, weekNo);
        cal.add(7, 6);
        return cal.getTime();
    }

    public static Date getStartDayOfWeekNo(int year, int weekNo, Boolean isStartDayTheWeekSunday) {
        Calendar cal = TimeUtils.getCalendarFormYear(year, isStartDayTheWeekSunday);
        int maxWeekNum = cal.getActualMaximum(3);
        if (maxWeekNum < weekNo) {
            weekNo = maxWeekNum;
        }
        cal.set(3, weekNo);
        return cal.getTime();
    }

    public static Integer getWeekNumOfDate(Date dt) {
        int[] weekDays = new int[]{6, 0, 1, 2, 3, 4, 5};
        Calendar cal = Calendar.getInstance();
        cal.setTime(dt);
        int w = cal.get(7) - 1;
        if (w < 0) {
            w = 0;
        }
        return weekDays[w];
    }

    public static boolean isWeekday(Date date) {
        if (date == null) {
            return false;
        }
        Integer weekNum = TimeUtils.getWeekNumOfDate(date);
        return weekNum != 5 && weekNum != 6;
    }

    public static boolean isWeekend(Date date) {
        if (date == null) {
            return false;
        }
        Integer weekNum = TimeUtils.getWeekNumOfDate(date);
        return weekNum == 5 || weekNum == 6;
    }

    public static int getMonthByDate(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(2) + 1;
    }

    public static String[] getThisPeriodStartAndEndTime(String stime, String etime, Integer timeType) {
        String[] strArr = new String[2];
        if (StringUtils.isBlank((CharSequence)stime)) {
            stime = TimeUtils.formatDate(Authenticator.getInstance().now(), SHORT_FORMAT_PATTERN);
        }
        String startTime = "";
        String endTime = "";
        if (StringUtils.isBlank((CharSequence)etime)) {
            Date startDate = TimeUtils.getFirstDayOnThisCycleByTimeAndTimeType(TimeUtils.timeStrToDate(stime), timeType);
            Date endDate = TimeUtils.getEndDayOnThisCycleByTimeAndTimeType(TimeUtils.timeStrToDate(stime), timeType);
            startTime = TimeUtils.formatDate(TimeUtils.getStartTimeOfDay(startDate), LONG_FORMAT_PATTERN);
            endTime = TimeUtils.formatDate(TimeUtils.getEndTimeOfDay(endDate), LONG_FORMAT_PATTERN);
        } else {
            startTime = stime;
            endTime = etime;
        }
        strArr[0] = startTime;
        strArr[1] = endTime;
        return strArr;
    }

    public static Pair<String, String> getStartAndEndTime(String stime, String etime, Integer timeType) {
        if (Objects.isNull(timeType)) {
            return new Pair((Object)stime, (Object)etime);
        }
        String startTime = null;
        String endTime = null;
        if (timeType == 8) {
            Date now = Authenticator.getInstance().now();
            endTime = TimeUtils.formatLongDate(TimeUtils.getEndTimeOfDay(now));
            startTime = TimeUtils.formatLongDate(TimeUtils.getStartTimeOfDay(TimeUtils.addDay(now, -6)));
        } else if (timeType == 9) {
            Date now = Authenticator.getInstance().now();
            Date yesterdayDate = TimeUtils.addDay(now, -1);
            endTime = TimeUtils.formatLongDate(TimeUtils.getEndTimeOfDay(yesterdayDate));
            startTime = TimeUtils.formatLongDate(TimeUtils.getStartTimeOfDay(yesterdayDate));
        } else {
            String[] startAndEndTime = TimeUtils.getThisPeriodStartAndEndTime(stime, etime, timeType);
            startTime = startAndEndTime[0];
            endTime = startAndEndTime[1];
        }
        return new Pair((Object)startTime, (Object)endTime);
    }

    public static Pair<String, String> getChainStartAndEndTime(String stime, String etime, Integer timeType) {
        String startTime = null;
        String endTime = null;
        if (Objects.isNull(timeType)) {
            timeType = 2;
            List<String> times = CategoriesUtil.getCategoriesByTimeTypeFromStimeToEtime(stime, etime, timeType);
            startTime = TimeUtils.reduceStimeNCycleByTimeType(TimeUtils.timeStrToDate(stime), timeType, times.size());
            endTime = TimeUtils.reduceEtimeNCycleByTimeType(TimeUtils.timeStrToDate(etime), timeType, times.size());
        } else if (timeType == 8) {
            Date now = Authenticator.getInstance().now();
            endTime = TimeUtils.formatLongDate(TimeUtils.getEndTimeOfDay(TimeUtils.addDay(now, -7)));
            startTime = TimeUtils.formatLongDate(TimeUtils.getStartTimeOfDay(TimeUtils.addDay(now, -13)));
        } else if (timeType == 9) {
            Date now = Authenticator.getInstance().now();
            Date date = TimeUtils.addDay(now, -2);
            endTime = TimeUtils.formatLongDate(TimeUtils.getEndTimeOfDay(date));
            startTime = TimeUtils.formatLongDate(TimeUtils.getStartTimeOfDay(date));
        } else {
            String[] startAndEndTime = TimeUtils.getPreviousPeriodStartAndEndTime(stime, etime, timeType);
            startTime = startAndEndTime[0];
            endTime = startAndEndTime[1];
        }
        return new Pair((Object)startTime, (Object)endTime);
    }

    public static String[] getThisPeriodStartAndNowTime(String stime, String etime, Integer timeType) {
        String[] strArr = new String[2];
        Date now = Authenticator.getInstance().now();
        if (StringUtils.isBlank((CharSequence)stime)) {
            stime = TimeUtils.formatDate(now, LONG_FORMAT_PATTERN);
        }
        String startTime = "";
        String endTime = "";
        if (StringUtils.isBlank((CharSequence)etime)) {
            Date startDate = TimeUtils.getFirstDayOnThisCycleByTimeAndTimeType(TimeUtils.timeStrToDate(stime), timeType);
            Date endDate = now;
            startTime = timeType == 1 ? TimeUtils.formatDate(now, "yyyy-MM-dd HH:00:00") : TimeUtils.formatDate(TimeUtils.getStartTimeOfDay(startDate), LONG_FORMAT_PATTERN);
            endTime = TimeUtils.formatDate(endDate, LONG_FORMAT_PATTERN);
        } else {
            startTime = stime;
            endTime = etime;
        }
        strArr[0] = startTime;
        strArr[1] = endTime;
        return strArr;
    }

    public static String[] getThisMonthStartAndEndTime(String stime) {
        String[] strArr = new String[2];
        Date now = new Date();
        String startTime = "";
        String endTime = "";
        if (StringUtils.isBlank((CharSequence)stime)) {
            startTime = TimeUtils.formatDate(TimeUtils.getStartDayOfMonth(now), LONG_FORMAT_PATTERN);
            endTime = TimeUtils.formatDate(TimeUtils.getEndDayOfMonth(now), LONG_FORMAT_PATTERN);
        } else {
            Date stimeDate = TimeUtils.parseDateStr(stime, LONG_FORMAT_PATTERN);
            startTime = TimeUtils.formatDate(TimeUtils.getStartDayOfMonth(stimeDate), LONG_FORMAT_PATTERN);
            endTime = TimeUtils.formatDate(TimeUtils.getEndDayOfMonth(stimeDate), LONG_FORMAT_PATTERN);
        }
        strArr[0] = startTime;
        strArr[1] = endTime;
        return strArr;
    }

    public static String[] getPreviousPeriodStartAndEndTime(String startTime, String endTime, Integer timeType) {
        String[] strArr = new String[]{TimeUtils.getPreviousCycleStartTimeStr(startTime, timeType), TimeUtils.getPreviousCycleEndTimeStr(endTime, timeType)};
        return strArr;
    }

    public static String[] getPreviousSamePeriodStartAndEndTime(String startTime, String endTime, Integer timeType) {
        String[] strArr = new String[2];
        Date now = new Date();
        Date etime = TimeUtils.timeStrToDate(endTime);
        etime = now.before(etime) ? now : etime;
        strArr[0] = TimeUtils.getPreviousCycleThisTimeStr(startTime, timeType);
        strArr[1] = TimeUtils.getPreviousCycleThisTimeStr(TimeUtils.formatLongDate(etime), timeType);
        return strArr;
    }

    public static String[] getYoySamePeriodStartAndEndTime(String startTime, String endTime, Integer timeType) {
        String[] strArr = new String[2];
        Date now = new Date();
        Date etime = TimeUtils.timeStrToDate(endTime);
        etime = now.before(etime) ? now : etime;
        strArr[0] = TimeUtils.getPreviousYearStartTimeStr(startTime, timeType);
        strArr[1] = TimeUtils.getPreviousYearEndTimeStr(TimeUtils.formatLongDate(etime), timeType);
        return strArr;
    }

    public static Date getNDaysAgoTime(Date date, Integer n) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(5, -n.intValue());
        return cal.getTime();
    }

    public static String reduceStimeNCycleByTimeType(Date date, Integer timeType, Integer num) {
        if (date == null || timeType == null || num == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        switch (timeType) {
            case 0: 
            case 1: {
                cal.add(10, -1 * num);
                break;
            }
            case 2: {
                cal.add(5, -1 * num);
                break;
            }
            case 3: {
                cal.add(7, -7 * num);
                break;
            }
            case 4: {
                cal.add(2, -1 * num);
                break;
            }
            case 5: {
                cal.add(2, -3 * num);
                break;
            }
            case 6: {
                cal.add(1, -1 * num);
            }
        }
        return TimeUtils.formatLongDate(cal.getTime());
    }

    public static String reduceEtimeNCycleByTimeType(Date date, Integer timeType, Integer num) {
        if (date == null || timeType == null || num == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        switch (timeType) {
            case 0: 
            case 1: {
                cal.add(10, -1 * num);
                return TimeUtils.formatDate(cal.getTime(), LONG_FORMAT_PATTERN);
            }
            case 2: {
                cal.add(5, -1 * num);
                return TimeUtils.formatDate(cal.getTime(), LONG_FORMAT_PATTERN);
            }
            case 3: {
                cal.add(7, -7 * num);
                return TimeUtils.formatDate(cal.getTime(), LONG_FORMAT_PATTERN);
            }
            case 4: {
                cal.add(2, -1 * num);
                return TimeUtils.formatDate(TimeUtils.getEndDayOfMonth(cal.getTime()), LONG_FORMAT_PATTERN);
            }
            case 5: {
                cal.add(2, -3 * num);
                return TimeUtils.formatDate(TimeUtils.getEndDayOfMonth(cal.getTime()), LONG_FORMAT_PATTERN);
            }
            case 6: {
                cal.add(1, -1 * num);
                return TimeUtils.formatDate(TimeUtils.getEndDayOfMonth(cal.getTime()), LONG_FORMAT_PATTERN);
            }
        }
        return null;
    }

    public static Date addHour(Date date, int n) {
        if (date == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(11, n);
        return cal.getTime();
    }

    public static Date addSecond(Date date, int n) {
        if (Objects.isNull(date)) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(13, n);
        return cal.getTime();
    }

    public static Date addHour(String time, int n) {
        Date date = TimeUtils.timeStrToDate(time);
        return TimeUtils.addHour(date, n);
    }

    public static Date addDay(Date date, int n) {
        if (date == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(6, n);
        return cal.getTime();
    }

    public static Date addDay(String time, int n) {
        Date date = TimeUtils.timeStrToDate(time);
        if (date == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(6, n);
        return cal.getTime();
    }

    public static String addDay2Str(String time, int n) {
        Date date = TimeUtils.timeStrToDate(time);
        if (date == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(6, n);
        Date dataResult = cal.getTime();
        return TimeUtils.formatLongDate(dataResult);
    }

    public static Date addMonth(Date date, int n) {
        if (date == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(2, n);
        return cal.getTime();
    }

    public static Date addYear(Date date, int n) {
        if (date == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(1, n);
        return cal.getTime();
    }

    public static String beforeOrAfterNumberDay(Date date, int day) {
        SimpleDateFormat fm = new SimpleDateFormat(SHORT_FORMAT_PATTERN);
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(6, day);
        return fm.format(c.getTime());
    }

    public static List<String> getLastDates(Integer timeLength) {
        SimpleDateFormat fm = new SimpleDateFormat(SHORT_FORMAT_PATTERN);
        ArrayList<String> list = new ArrayList<String>();
        if (Objects.isNull(timeLength)) {
            return list;
        }
        Date now = Authenticator.getInstance().now();
        timeLength = timeLength + 1;
        for (int i = 0; i < timeLength; ++i) {
            list.add(TimeUtils.beforeOrAfterNumberDay(now, i - timeLength, fm));
        }
        return list;
    }

    public static String beforeOrAfterNumberDay(Date date, int day, SimpleDateFormat fm) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(6, day);
        return fm.format(c.getTime());
    }

    public static boolean isOnBusinessTime(List<BusinessTimeParamDto> businessTimeParams, Date now) {
        String hour = TimeUtils.formatDate(now, "HH");
        if (!CollectionUtils.isEmpty(businessTimeParams)) {
            for (BusinessTimeParamDto businessTimeParam : businessTimeParams) {
                if (!TimeUtils.isEffectiveDate(now, TimeUtils.timeStr2Date(businessTimeParam.getStime()), TimeUtils.timeStr2Date(businessTimeParam.getEtime()))) continue;
                if (businessTimeParam.getStarthour() != null && businessTimeParam.getEndhour() != null) {
                    if (Integer.parseInt(hour) < businessTimeParam.getStarthour() || Integer.parseInt(hour) > businessTimeParam.getEndhour()) continue;
                    return true;
                }
                if (CollectionUtils.isEmpty((Collection)businessTimeParam.getWeekParamList())) continue;
                Integer weekNum = TimeUtils.getWeekNumOfDate(now);
                for (BusinessTimeWeekParamDto businessTimeWeekParam : businessTimeParam.getWeekParamList()) {
                    if (weekNum < businessTimeWeekParam.getWeekDayFrom() || weekNum > businessTimeWeekParam.getWeekDayTo() || Integer.parseInt(hour) < businessTimeWeekParam.getStarthour() || Integer.parseInt(hour) > businessTimeWeekParam.getEndhour()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static int getOnBusinessTimeStatus(List<BusinessTimeParamDto> businessTimeParams, Date now) {
        String hourStr = TimeUtils.formatDate(now, "HH");
        int hour = Integer.parseInt(hourStr);
        if (!CollectionUtils.isEmpty(businessTimeParams)) {
            for (BusinessTimeParamDto businessTimeParam : businessTimeParams) {
                if (!TimeUtils.isEffectiveDate(now, TimeUtils.timeStr2Date(businessTimeParam.getStime()), TimeUtils.timeStr2Date(businessTimeParam.getEtime()))) continue;
                if (businessTimeParam.getStarthour() != null && businessTimeParam.getEndhour() != null) {
                    if (hour >= businessTimeParam.getStarthour() && hour <= businessTimeParam.getEndhour()) {
                        return 1;
                    }
                    if (hour < businessTimeParam.getStarthour()) {
                        return 0;
                    }
                    if (hour <= businessTimeParam.getEndhour()) continue;
                    return 2;
                }
                if (CollectionUtils.isEmpty((Collection)businessTimeParam.getWeekParamList())) continue;
                Integer weekNum = TimeUtils.getWeekNumOfDate(now);
                for (BusinessTimeWeekParamDto businessTimeWeekParam : businessTimeParam.getWeekParamList()) {
                    if (weekNum < businessTimeWeekParam.getWeekDayFrom() || weekNum > businessTimeWeekParam.getWeekDayTo()) continue;
                    if (hour >= businessTimeWeekParam.getStarthour() && hour <= businessTimeWeekParam.getEndhour()) {
                        return 1;
                    }
                    if (hour < businessTimeWeekParam.getStarthour()) {
                        return 0;
                    }
                    if (hour <= businessTimeWeekParam.getEndhour()) continue;
                    return 2;
                }
            }
        }
        return -1;
    }

    public static boolean isEffectiveDate(Date nowTime, Date startTime, Date endTime) {
        if (nowTime.getTime() == startTime.getTime() || nowTime.getTime() == endTime.getTime()) {
            return true;
        }
        Calendar date = Calendar.getInstance();
        date.setTime(nowTime);
        Calendar begin = Calendar.getInstance();
        begin.setTime(startTime);
        Calendar end = Calendar.getInstance();
        end.setTime(endTime);
        return date.after(begin) && date.before(end);
    }

    public static void main(String[] args) {
        Date date = TimeUtils.timeStrToDate("2025-03-24 09:59:59");
        System.out.println(TimeUtils.getSecondIndex(date));
    }

    public static Date now(String timeZone) {
        if (StringUtils.isBlank((CharSequence)timeZone)) {
            return new Date();
        }
        TimeZone tz = TimeZone.getTimeZone(timeZone);
        SimpleDateFormat sdf = new SimpleDateFormat(LONG_FORMAT_PATTERN);
        sdf.setTimeZone(tz);
        String dateStr = sdf.format(new Date());
        return TimeUtils.parseDateStr(dateStr, LONG_FORMAT_PATTERN);
    }

    public static Date getHourDate(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date getEntire20minTimePoint(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int i = cal.get(12);
        if (i < 20) {
            cal.set(12, 0);
        } else if (i < 40) {
            cal.set(12, 20);
        } else {
            cal.set(12, 40);
        }
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date getEntireMinTimePoint(Date date, int cycMinute) {
        if (cycMinute < 20 || cycMinute > 60) {
            return null;
        }
        if (60 % cycMinute != 0) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int minute = cal.get(12);
        int num = 60 / cycMinute;
        for (int i = 0; i < num; ++i) {
            if (minute >= cycMinute * (i + 1)) continue;
            cal.set(12, cycMinute * i);
            break;
        }
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static boolean isOnTheHour(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(12) == 0 && cal.get(13) == 0;
    }

    public static Date getOnTheHourStartTime(String stime) {
        return TimeUtils.getHourDate(TimeUtils.timeStrToDate(stime));
    }

    public static Date getOnTheHourEndTime(String etime) {
        Date date = TimeUtils.timeStrToDate(etime);
        if (TimeUtils.isOnTheHour(date)) {
            return date;
        }
        return TimeUtils.addHour(TimeUtils.getHourDate(date), 1);
    }

    public static String subMinuteEndDate(String date) {
        if (StringUtils.isBlank((CharSequence)date)) {
            return date;
        }
        if (date.length() == LONG_FORMAT_PATTERN.length()) {
            return date.substring(0, LONG_FORMAT_PATTERN.length() - 3);
        }
        return date;
    }

    public static Date getEast8TimeZoneDate(Date date, DepartmentPojo dep) {
        if (Objects.isNull(date) || Objects.isNull(dep)) {
            return null;
        }
        Calendar cal = TimeUtils.getEast8TimeZoneCalendar(date, dep);
        if (TimeUtils.isDST(date, dep.getIsSummerTime(), dep.getRealSummerTimeStart(), dep.getRealSummerTimeEnd())) {
            cal.add(10, -1);
        }
        return cal.getTime();
    }

    private static Calendar getEast8TimeZoneCalendar(Date date, DepartmentPojo dep) {
        int timeZone = dep.getTimeZone();
        Integer LOCAL = com.ovopark.pojo.DepartmentPojo.DEFAULT_TIME_ZONE;
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        if (timeZone <= 12) {
            cal.add(10, LOCAL - timeZone);
        } else {
            switch (timeZone) {
                case 13: {
                    cal.add(10, LOCAL + 9);
                    cal.add(12, 30);
                    break;
                }
                case 14: {
                    cal.add(10, LOCAL + 3);
                    cal.add(12, 30);
                    break;
                }
                case 15: {
                    cal.add(10, LOCAL - 3);
                    cal.add(12, -30);
                    break;
                }
                case 16: {
                    cal.add(10, LOCAL - 4);
                    cal.add(12, -30);
                    break;
                }
                case 17: {
                    cal.add(10, LOCAL - 5);
                    cal.add(12, -30);
                    break;
                }
                case 18: {
                    cal.add(10, LOCAL - 6);
                    cal.add(12, -30);
                    break;
                }
                case 19: {
                    cal.add(10, LOCAL - 9);
                    cal.add(12, -30);
                    break;
                }
                case 20: {
                    cal.add(10, LOCAL - 10);
                    cal.add(12, -30);
                    break;
                }
                case 21: {
                    cal.add(10, LOCAL - 13);
                    break;
                }
                case 22: {
                    cal.add(10, LOCAL - 14);
                    break;
                }
            }
        }
        return cal;
    }

    private static boolean isDST(Date now, Integer isSummerTime, Date summerTimeStart, Date summerTimeEnd) {
        boolean isDst = false;
        if (isSummerTime != null && isSummerTime > 0 && summerTimeStart != null && summerTimeEnd != null) {
            if (summerTimeEnd.after(summerTimeStart)) {
                if (!now.before(summerTimeStart) && now.before(summerTimeEnd)) {
                    isDst = true;
                }
            } else {
                isDst = !now.after(summerTimeEnd) || now.after(summerTimeStart);
            }
        }
        return isDst;
    }

    public static Date addMinute(Date date, int minute) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(12, minute);
        return calendar.getTime();
    }

    public static boolean isThisHourOnBusinessTime(List<BusinessTimePojo> businessTimeParams, Date now) {
        String md = TimeUtils.formatDate(now, "MM-dd");
        int hour = TimeUtils.getHour(now);
        if (CollectionUtils.isNotEmpty(businessTimeParams)) {
            try {
                for (BusinessTimePojo businessTime : businessTimeParams) {
                    if (md.compareTo(businessTime.getFromDate()) < 0 || md.compareTo(businessTime.getToDate()) > 0) continue;
                    if (businessTime.getIsWeekSeprate() == 1) {
                        Integer weekNum = TimeUtils.getWeekNumOfDate(now);
                        List weekList = businessTime.getWeekList();
                        if (!CollectionUtils.isNotEmpty((Collection)weekList)) continue;
                        for (BusinessTimeWeekPojo week : weekList) {
                            if (weekNum < week.getWeekDayFrom() || weekNum > week.getWeekDayTo() || !TimeUtils.isOnHourPeriod(hour, week.getFromTime(), week.getToTime())) continue;
                            return true;
                        }
                        continue;
                    }
                    if (!TimeUtils.isOnHourPeriod(hour, businessTime.getFromTime(), businessTime.getToTime())) continue;
                    return true;
                }
            }
            catch (Exception e) {
                log.error("\u8425\u4e1a\u65f6\u95f4\u8bbe\u7f6e\u6709\u8befdepId:{}", (Object)businessTimeParams.get(0).getDepId());
                throw new RuntimeException(e);
            }
        }
        return false;
    }

    public static BusinessTimePojo getBusinessTimeByDate(List<BusinessTimePojo> businessTimeParams, String dateStr) {
        BusinessTimePojo res = new BusinessTimePojo();
        Date date = TimeUtils.timeStrToDate(dateStr);
        String md = TimeUtils.formatDate(date, "MM-dd");
        if (CollectionUtils.isNotEmpty(businessTimeParams)) {
            try {
                for (BusinessTimePojo businessTime : businessTimeParams) {
                    if (md.compareTo(businessTime.getFromDate()) < 0 || md.compareTo(businessTime.getToDate()) > 0) continue;
                    if (businessTime.getIsWeekSeprate() == 1) {
                        Integer weekNum = TimeUtils.getWeekNumOfDate(date);
                        List weekList = businessTime.getWeekList();
                        if (!CollectionUtils.isNotEmpty((Collection)weekList)) continue;
                        for (BusinessTimeWeekPojo week : weekList) {
                            if (weekNum < week.getWeekDayFrom() || weekNum > week.getWeekDayTo()) continue;
                            res.setFromTime(week.getFromTime());
                            res.setToTime(week.getToTime());
                        }
                        continue;
                    }
                    res.setFromTime(businessTime.getFromTime());
                    res.setToTime(businessTime.getToTime());
                }
            }
            catch (Exception e) {
                log.error("\u8425\u4e1a\u65f6\u95f4\u8bbe\u7f6e\u6709\u8befdepId:{}", (Object)businessTimeParams.get(0).getDepId());
            }
        }
        return res;
    }

    public static Integer getHour(Date date) {
        if (date == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(11);
    }

    public static Integer getHour(Object object) {
        int hour = 0;
        if (Objects.isNull(object)) {
            return hour;
        }
        if (object instanceof String) {
            hour = Integer.valueOf(((String)object).substring(0, ((String)object).indexOf(":")));
        } else if (object instanceof Date && Objects.equals(STARTHOUR, hour = Integer.valueOf(TimeUtils.formatDate((Date)object, "HH")).intValue())) {
            hour = ENDHOUR;
        }
        return hour;
    }

    private static boolean isOnHourPeriod(int hour, String fromTime, String toTime) {
        int endHour;
        if (StringUtils.isBlank((CharSequence)fromTime) || StringUtils.isBlank((CharSequence)toTime)) {
            return false;
        }
        int startHour = Integer.parseInt(fromTime.substring(0, 2));
        int n = endHour = toTime.endsWith(":00") ? Integer.parseInt(toTime.substring(0, 2)) - 1 : Integer.parseInt(toTime.substring(0, 2));
        if (hour >= startHour && hour <= endHour) {
            return true;
        }
        return false;
    }

    public static BusinessTimePojo getHourPeriod(String fromTime, String toTime) {
        BusinessTimePojo res = new BusinessTimePojo();
        if (StringUtils.isBlank((CharSequence)fromTime) || StringUtils.isBlank((CharSequence)toTime)) {
            return res;
        }
        String minuteStr = ":00";
        String fromHour = fromTime.substring(0, 2);
        int endHour = toTime.endsWith(minuteStr) ? Integer.parseInt(toTime.substring(0, 2)) : Integer.parseInt(toTime.substring(0, 2)) + 1;
        res.setFromTime(fromHour + minuteStr);
        res.setToTime((endHour < 10 ? "0" + endHour : "" + endHour) + minuteStr);
        return res;
    }

    public static Integer getDayNum(String startTime, String endTime) {
        if (StringUtils.isBlank((CharSequence)startTime) || StringUtils.isBlank((CharSequence)endTime)) {
            return null;
        }
        Date sDate = TimeUtils.timeStrToDate(startTime);
        Date eDate = TimeUtils.timeStrToDate(endTime);
        long t = eDate.getTime() - sDate.getTime();
        long dayNum = t / 86400000L;
        return (int)dayNum + 1;
    }

    public static List<Pair<String, String>> getMonthPeriod(String startTime, String endTime) {
        if (StringUtils.isBlank((CharSequence)startTime) || StringUtils.isBlank((CharSequence)endTime)) {
            return new ArrayList<Pair<String, String>>();
        }
        ArrayList<Pair<String, String>> res = new ArrayList<Pair<String, String>>();
        Date startDate = TimeUtils.timeStrToDate(startTime);
        Date endDate = TimeUtils.timeStrToDate(endTime);
        Date monthEndTime = TimeUtils.getEndTimeOfDay(TimeUtils.getEndDayOfMonth(startDate));
        while (monthEndTime.before(endDate)) {
            res.add(new Pair((Object)TimeUtils.formatLongDate(startDate), (Object)TimeUtils.formatLongDate(monthEndTime)));
            startDate = TimeUtils.getStartTimeOfDay(TimeUtils.getStartDayOfMonth(TimeUtils.addMonth(startDate, 1)));
            monthEndTime = TimeUtils.getEndDayOfMonth(TimeUtils.addMonth(monthEndTime, 1));
        }
        res.add(new Pair((Object)TimeUtils.formatLongDate(startDate), (Object)endTime));
        return res;
    }

    public static boolean isOnTheSameDay(String startTime, String endTime) {
        if (StringUtils.isBlank((CharSequence)startTime) || StringUtils.isBlank((CharSequence)endTime)) {
            return false;
        }
        Date startDate = TimeUtils.timeStrToDate(startTime);
        Date endDate = TimeUtils.timeStrToDate(endTime);
        return Objects.equals(TimeUtils.formatShortDate(startDate), TimeUtils.formatShortDate(endDate));
    }

    public static Integer getYear(Date date) {
        if (date == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(1);
    }

    public static List<String> getDays(String startTime, String endTime) {
        if (StringUtils.isBlank((CharSequence)startTime) || StringUtils.isBlank((CharSequence)endTime)) {
            return new ArrayList<String>();
        }
        ArrayList<String> res = new ArrayList<String>();
        Date startDate = TimeUtils.timeStrToDate(startTime);
        Date endDate = TimeUtils.timeStrToDate(endTime);
        while (!startDate.after(endDate)) {
            res.add(TimeUtils.formatShortDate(startDate));
            startDate = TimeUtils.addDay(startDate, 1);
        }
        return res;
    }

    public static int getMinute(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(12);
    }

    public static Date reduceOneHour(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(11, -1);
        return cal.getTime();
    }

    public static Integer getSecondIndex(Date time) {
        if (time == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(time);
        return calendar.get(12) * 60 + calendar.get(13);
    }

    public static Date getUntil5MinuteDate(Date date) {
        if (date == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int minute = cal.get(12);
        cal.set(12, minute / 5 * 5);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date getDate(Object value) {
        Date date = null;
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            String str = (String)value;
            date = TimeUtils.timeStr2Date(str);
        } else if (value instanceof Date) {
            date = (Date)value;
        } else if (value instanceof LocalDateTime) {
            LocalDateTime ldt = (LocalDateTime)value;
            date = LocalDateTimeUtils.convertLDTToDate(ldt);
        }
        if (date == null) {
            throw new BizException(ResultCodeEnum.PARAM_ERROR.getCode(), ResultCodeEnum.PARAM_ERROR.getMessage());
        }
        return date;
    }

    public static Date setHour(Date date, int hour) {
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, hour);
        return calendar.getTime();
    }
}

