/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.passenger.ck.config;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.util.Arrays;
import javax.annotation.PostConstruct;
import javax.sql.DataSource;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.type.JdbcType;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.mybatis.spring.annotation.MapperScan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

@Configuration
@MapperScan(basePackages={"com.ovopark.passenger.ck.mapper"}, sqlSessionFactoryRef="ckSqlSessionFactory")
public class CkMyBatisConfig {
    private static final Logger log = LoggerFactory.getLogger(CkMyBatisConfig.class);
    @Autowired
    private Environment env;

    @PostConstruct
    public void printConfigInfo() {
        log.info("Active Profiles: {}", (Object)Arrays.toString(this.env.getActiveProfiles()));
        log.info("ClickHouse URL from Env: {}", (Object)this.env.getProperty("spring.datasource.clickhouse.jdbc-url"));
        log.info("ClickHouse Driver from Env: {}", (Object)this.env.getProperty("spring.datasource.clickhouse.driver-class-name"));
    }

    @Bean(value={"ckHikariConfig"})
    @ConfigurationProperties(prefix="spring.datasource.clickhouse.hikari")
    public HikariConfig ckHikariConfig() {
        return new HikariConfig();
    }

    @Bean(value={"ckDs"})
    public DataSource ckDs(@Value(value="${spring.datasource.clickhouse.driver-class-name}") String driver, @Value(value="${spring.datasource.clickhouse.jdbc-url}") String url, @Value(value="${spring.datasource.clickhouse.username}") String username, @Value(value="${spring.datasource.clickhouse.password}") String password, @Qualifier(value="ckHikariConfig") HikariConfig cfg) {
        log.info("ClickHouse Config Values:");
        log.info("Driver: {}", (Object)driver);
        log.info("URL: {}", (Object)url);
        log.info("Username: {}", (Object)username);
        log.info("Password: {} (masked)", (Object)(password.substring(0, 3) + "***"));
        cfg.setDriverClassName(driver);
        cfg.setJdbcUrl(url);
        cfg.setUsername(username);
        cfg.setPassword(password);
        cfg.setAutoCommit(true);
        return new HikariDataSource(cfg);
    }

    @Bean(value={"ckSqlSessionFactory"})
    public SqlSessionFactory ckSqlSessionFactory(@Qualifier(value="ckDs") DataSource ds) throws Exception {
        SqlSessionFactoryBean b = new SqlSessionFactoryBean();
        b.setDataSource(ds);
        PathMatchingResourcePatternResolver r = new PathMatchingResourcePatternResolver();
        b.setMapperLocations(r.getResources("classpath*:/mybatis/ck/**/*.xml"));
        org.apache.ibatis.session.Configuration conf = new org.apache.ibatis.session.Configuration();
        conf.setMapUnderscoreToCamelCase(true);
        conf.setJdbcTypeForNull(JdbcType.NULL);
        b.setConfiguration(conf);
        return b.getObject();
    }
}

