/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.passenger.ck.service.Impl;

import com.ovopark.passenger.ck.dto.PassengerFlowHourlyDto;
import com.ovopark.passenger.ck.mapper.FlowHourlyCkMapper;
import com.ovopark.passenger.ck.service.FlowHourlyService;
import java.util.Date;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class FlowHourlyServiceImpl
implements FlowHourlyService {
    private final FlowHourlyCkMapper mapper;

    public FlowHourlyServiceImpl(FlowHourlyCkMapper mapper) {
        this.mapper = mapper;
    }

    @Override
    public List<PassengerFlowHourlyDto> queryHourly(Integer enterpriseId, List<Integer> depIds, Integer type, String startTime, String endTime, Integer startHour, Integer endHour, Integer isOnBusinessTime, Integer limit, Integer offset) {
        if (startHour == null) {
            startHour = 0;
        }
        if (endHour == null) {
            endHour = 24;
        }
        if (limit == null) {
            limit = 1000;
        }
        if (offset == null) {
            offset = 0;
        }
        return this.mapper.queryHourly(enterpriseId, depIds, type, startTime, endTime, startHour, endHour, isOnBusinessTime, limit, offset);
    }

    @Override
    public List<PassengerFlowHourlyDto> findByMacTimeTagFace(String mac, Date startTime, Date endTime, Integer tagId, String faceId) {
        if (mac == null || this.isBlankInJava8(mac)) {
            throw new IllegalArgumentException("mac \u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (startTime == null || endTime == null) {
            throw new IllegalArgumentException("startTime / endTime \u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.mapper.selectByMacTimeTagFace(mac, startTime, endTime, tagId, faceId);
    }

    public boolean isBlankInJava8(String str) {
        return str == null || str.trim().isEmpty();
    }
}

