/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.passenger.common;

import com.ovopark.passenger.common.Diff;
import com.ovopark.passenger.common.DiffOptions;
import com.ovopark.passenger.common.ID;
import com.ovopark.passenger.exception.SysException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiPredicate;
import org.springframework.util.ReflectionUtils;

public class DataObjDiffUtils {
    private static final ConcurrentHashMap<Class<?>, Field[]> FIELDS_CACHE = new ConcurrentHashMap();

    public static <E extends ID> Optional<Diff<E>> getDiff(E origin, E current) {
        DiffOptions diffOptions = DiffOptions.defaultDiffOptions();
        return DataObjDiffUtils.getDiff(origin, current, diffOptions);
    }

    public static <E extends ID> Optional<Diff<E>> getDiff(E origin, E current, DiffOptions options) {
        if (origin == null && current == null) {
            return Optional.empty();
        }
        if (origin == null || current == null) {
            return Optional.of(new Diff<E>(origin, current));
        }
        DiffOptions diffOptions = DiffOptions.defaultDiffOptions();
        if (options != null) {
            diffOptions.merge(options);
        }
        if (diffOptions.hasClass(origin.getClass())) {
            BiPredicate<?, ?> biPredicate = diffOptions.get(origin.getClass());
            if (!biPredicate.test(origin, current)) {
                return Optional.of(new Diff<E>(origin, current));
            }
            return Optional.empty();
        }
        for (Field field : DataObjDiffUtils.getFields(origin.getClass())) {
            Object o = ReflectionUtils.getField((Field)field, origin);
            Object c = ReflectionUtils.getField((Field)field, current);
            BiPredicate<?, ?> predicate = diffOptions.get(field.getType());
            if (predicate == null) {
                throw new SysException("500", "DiffOptions \u672a\u627e\u5230 [+" + field.getType().getName() + "+]\u7684\u6bd4\u8f83\u65b9\u6cd5,\u5fc5\u987b\u6307\u5b9a");
            }
            if (predicate.test(o, c)) continue;
            return Optional.of(new Diff<E>(origin, current));
        }
        return Optional.empty();
    }

    public static <E extends ID> List<Diff<E>> getDiff(List<E> origin, List<E> current) {
        return DataObjDiffUtils.getDiff(origin, current, null);
    }

    public static <E extends ID> List<Diff<E>> getDiff(List<E> origin, List<E> current, DiffOptions options) {
        Object diff;
        if (origin == null) {
            origin = new ArrayList();
        }
        if (current == null) {
            current = new ArrayList();
        }
        ArrayList<Diff<E>> diffs = new ArrayList<Diff<E>>();
        block0: for (ID e : current) {
            if (Objects.isNull(e.getId())) {
                diff = DataObjDiffUtils.getDiff(null, e, options);
                ((Optional)diff).ifPresent(diffs::add);
                continue;
            }
            for (ID k : origin) {
                if (!Objects.equals(e.getId(), k.getId())) continue;
                Optional<Diff<ID>> diff2 = DataObjDiffUtils.getDiff(k, e, options);
                diff2.ifPresent(diffs::add);
                continue block0;
            }
        }
        block2: for (ID k : origin) {
            for (ID e : current) {
                if (!Objects.equals(e.getId(), k.getId())) continue;
                continue block2;
            }
            diff = DataObjDiffUtils.getDiff(k, null, options);
            ((Optional)diff).ifPresent(diffs::add);
        }
        return diffs;
    }

    private static Field[] getFields(Class<?> clz) {
        Field[] fields = FIELDS_CACHE.get(clz);
        if (fields == null || fields.length == 0) {
            for (Field field : fields = clz.getDeclaredFields()) {
                field.setAccessible(true);
            }
            FIELDS_CACHE.put(clz, fields);
        }
        return fields;
    }
}

