/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.passenger.common;

import com.ovopark.passenger.common.ID;
import java.util.function.Consumer;

public class Diff<T extends ID> {
    public static final int ADDED = 0;
    public static final int CHANGED = 1;
    public static final int DELETED = 2;
    private int type = 1;
    private final T origin;
    private final T current;

    public Diff(T origin, T current) {
        this.origin = origin;
        this.current = current;
        if (origin == null) {
            this.type = 0;
        }
        if (current == null) {
            this.type = 2;
        }
    }

    public T get() {
        return this.current;
    }

    public T getOrigin() {
        return this.origin;
    }

    public boolean isAdded() {
        return this.type == 0;
    }

    public boolean isChanged() {
        return this.type == 1;
    }

    public boolean isDeleted() {
        return this.type == 2;
    }

    public void onDelete(Consumer<T> consumer) {
        if (this.isDeleted()) {
            consumer.accept(this.origin);
        }
    }

    public void onAdd(Consumer<T> consumer) {
        if (this.isAdded()) {
            consumer.accept(this.current);
        }
    }

    public void onAdd(Consumer<T> consumer, Consumer<Integer> ... idSetter) {
        if (this.isAdded()) {
            consumer.accept(this.current);
            if (idSetter != null && idSetter.length > 0) {
                for (Consumer<Integer> eachConsumer : idSetter) {
                    eachConsumer.accept(this.current.getId());
                }
            }
        }
    }

    public void onChange(Consumer<T> consumer) {
        if (this.isChanged()) {
            consumer.accept(this.current);
        }
    }

    public String toString() {
        return "Diff(type=" + this.type + ", origin=" + this.getOrigin() + ", current=" + this.current + ")";
    }
}

