/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.passenger.config;

import com.ovopark.passenger.util.TimeUtils;
import java.util.Collection;
import java.util.Date;
import org.apache.shardingsphere.api.sharding.standard.PreciseShardingAlgorithm;
import org.apache.shardingsphere.api.sharding.standard.PreciseShardingValue;

public class CFMonthPreciseSharding
implements PreciseShardingAlgorithm<Comparable<?>> {
    public String doSharding(Collection<String> availableTargetNames, PreciseShardingValue<Comparable<?>> shardingValue) {
        Comparable value = shardingValue.getValue();
        Date recordTime = TimeUtils.getDate(value);
        if (recordTime.before(TimeUtils.timeStrToDate("2025-08-01 00:00:00"))) {
            return "is_customer_flow_2025m7";
        }
        String[] dateStrs = TimeUtils.formatDate(recordTime, "yyyy-MM").split("-");
        StringBuilder builder = new StringBuilder(shardingValue.getLogicTableName());
        builder.append("_").append(dateStrs[0]).append("m").append(Integer.parseInt(dateStrs[1]));
        return builder.toString();
    }
}

