/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.passenger.config;

import com.google.common.collect.BoundType;
import com.ovopark.passenger.util.TimeUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import org.apache.shardingsphere.api.sharding.standard.RangeShardingAlgorithm;
import org.apache.shardingsphere.api.sharding.standard.RangeShardingValue;

public class CFMonthRangeSharding
implements RangeShardingAlgorithm<Comparable<?>> {
    public Collection<String> doSharding(Collection<String> availableTargetNames, RangeShardingValue<Comparable<?>> shardingValue) {
        ArrayList<String> result = new ArrayList<String>();
        Date startTime = null;
        Date endTime = null;
        if (shardingValue.getValueRange().hasUpperBound()) {
            endTime = TimeUtils.getDate(shardingValue.getValueRange().upperEndpoint());
            if (shardingValue.getValueRange().upperBoundType() == BoundType.OPEN) {
                endTime = TimeUtils.addSecond(endTime, -1);
            }
            if (endTime.before(TimeUtils.timeStrToDate("2025-08-01 00:00:00"))) {
                result.add("is_customer_flow_2025m7");
                return result;
            }
        }
        Integer lowerYear = null;
        Integer lowerMonth = null;
        if (shardingValue.getValueRange().hasLowerBound()) {
            startTime = TimeUtils.getDate(shardingValue.getValueRange().lowerEndpoint());
            if (shardingValue.getValueRange().lowerBoundType() == BoundType.OPEN) {
                startTime = TimeUtils.addSecond(startTime, 1);
            }
            String[] startDate = TimeUtils.formatDate(startTime, "yyyy-MM").split("-");
            lowerYear = Integer.parseInt(startDate[0]);
            lowerMonth = Integer.parseInt(startDate[1]);
        }
        Integer upperYear = null;
        Integer upperMonth = null;
        if (shardingValue.getValueRange().hasUpperBound()) {
            String[] endDate = TimeUtils.formatDate(endTime, "yyyy-MM").split("-");
            upperYear = Integer.parseInt(endDate[0]);
            upperMonth = Integer.parseInt(endDate[1]);
        }
        for (String availableTargetName : availableTargetNames) {
            int index = availableTargetName.lastIndexOf("_");
            int year = Integer.parseInt(availableTargetName.substring(index + 1, index + 5));
            int month = Integer.parseInt(availableTargetName.substring(index + 6));
            if (shardingValue.getValueRange().hasLowerBound() && (lowerYear - year > 0 || lowerYear - year == 0 && lowerMonth - month > 0) || shardingValue.getValueRange().hasUpperBound() && (upperYear - year < 0 || upperYear - year == 0 && upperMonth - month < 0)) continue;
            result.add(availableTargetName);
        }
        return result;
    }
}

