/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.passenger.config;

import com.baomidou.mybatisplus.core.MybatisConfiguration;
import com.baomidou.mybatisplus.extension.plugins.PaginationInterceptor;
import com.baomidou.mybatisplus.extension.spring.MybatisSqlSessionFactoryBean;
import javax.sql.DataSource;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.type.JdbcType;
import org.mybatis.spring.SqlSessionTemplate;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;

@Configuration
@MapperScan(basePackages={"com.ovopark.mapper", "com.ovopark.passenger.mapper"}, sqlSessionFactoryRef="mysqlSqlSessionFactory")
public class MysqlMyBatisConfig {
    @Autowired
    private PaginationInterceptor paginationInterceptor;

    @Primary
    @Bean(value={"mysqlSqlSessionFactory"})
    public SqlSessionFactory mysqlSqlSessionFactory(@Qualifier(value="dataSource") DataSource ds) throws Exception {
        MybatisSqlSessionFactoryBean b = new MybatisSqlSessionFactoryBean();
        b.setDataSource(ds);
        b.setMapperLocations(new PathMatchingResourcePatternResolver().getResources("classpath*:mybatis/mappers/**/*.xml"));
        MybatisConfiguration conf = new MybatisConfiguration();
        conf.setMapUnderscoreToCamelCase(true);
        conf.setJdbcTypeForNull(JdbcType.NULL);
        conf.addInterceptor((Interceptor)this.paginationInterceptor);
        b.setConfiguration(conf);
        return b.getObject();
    }

    @Primary
    @Bean(value={"mysqlSqlSessionTemplate"})
    public SqlSessionTemplate mysqlSqlSessionTemplate(@Qualifier(value="mysqlSqlSessionFactory") SqlSessionFactory sf) {
        return new SqlSessionTemplate(sf);
    }

    @Primary
    @Bean(value={"mysqlTxManager"})
    public DataSourceTransactionManager mysqlTxManager(@Qualifier(value="dataSource") DataSource ds) {
        return new DataSourceTransactionManager(ds);
    }
}

