/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.passenger.config.aspect;

import com.ovopark.passenger.annotation.ApiPerformanceLog;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class PerformanceAspect {
    private static final Logger log = LoggerFactory.getLogger(PerformanceAspect.class);

    @Around(value="@annotation(logAnnotation)")
    public Object profileAnnotatedApis(ProceedingJoinPoint pjp, ApiPerformanceLog logAnnotation) throws Throwable {
        Object object;
        long startTime = System.currentTimeMillis();
        MethodSignature signature = (MethodSignature)pjp.getSignature();
        String className = signature.getDeclaringType().getSimpleName();
        String methodName = signature.getName();
        String apiDescription = logAnnotation.value();
        String traceId = MDC.get((String)"TRACE_ID");
        log.info("[API_START] {}.{} - {} START. TraceID: {}", new Object[]{className, methodName, apiDescription, traceId});
        try {
            Object result;
            object = result = pjp.proceed();
        }
        catch (Throwable e) {
            try {
                log.error("[API_ERROR] {}.{} FAILED. TraceID: {}", new Object[]{className, methodName, traceId, e});
                throw e;
            }
            catch (Throwable throwable) {
                long duration = System.currentTimeMillis() - startTime;
                log.info("[API_PERF] {}.{} - {} finished in {} ms. TraceID: {}", new Object[]{className, methodName, apiDescription, duration, traceId});
                throw throwable;
            }
        }
        long duration = System.currentTimeMillis() - startTime;
        log.info("[API_PERF] {}.{} - {} finished in {} ms. TraceID: {}", new Object[]{className, methodName, apiDescription, duration, traceId});
        return object;
    }
}

