/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.passenger.event;

import com.ovopark.passenger.occupancy.DeviceOccupancyRegional5minRepository;
import com.ovopark.passenger.occupancy.entity.OccupancyHourlyPropUpdateParam;
import com.ovopark.passenger.occupancy.entity.OccupancyRegionalPlan;
import com.ovopark.passenger.occupancy.entity.OccupancyRegionalPlanRepository;
import com.ovopark.passenger.occupancy.event.OccupancyInOut;
import com.ovopark.passenger.occupancy.event.OccupancyUploadEvent;
import com.ovopark.passenger.util.TimeUtils;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

@Component
public class OccupancyUploadEvent5MinListener
implements ApplicationListener<OccupancyUploadEvent> {
    private static final Logger log = LoggerFactory.getLogger(OccupancyUploadEvent5MinListener.class);
    @Resource
    private OccupancyRegionalPlanRepository occupancyRegionalPlanRepository;
    @Resource
    private DeviceOccupancyRegional5minRepository deviceOccupancyRegional5minRepository;

    public void onApplicationEvent(OccupancyUploadEvent event) {
        Integer regionalPlanId = event.getRegionalPlanId();
        Integer tableTurnoverCount = event.getTableTurnoverCount() == null ? 0 : event.getTableTurnoverCount();
        List inOutList = event.getInOutList();
        Integer occupants = Optional.ofNullable(event.getOccupants()).orElse(0);
        if (tableTurnoverCount == 0 && CollectionUtils.isNotEmpty((Collection)inOutList) || regionalPlanId == null) {
            log.warn("OccupancyUploadEventListener \u4f20\u53c2\u6709\u8bef\uff0cOccupancyUploadEvent: {}", (Object)event);
            return;
        }
        OccupancyRegionalPlan plan = this.occupancyRegionalPlanRepository.getById(regionalPlanId);
        if (plan == null) {
            log.warn("OccupancyUploadEventListener regionalPlanId\u4e3a\u7a7a\uff0cOccupancyUploadEvent: {}", (Object)event);
            return;
        }
        Date now = new Date();
        HashMap<Date, OccupancyHourlyPropUpdateParam> hourlyPropUpdateParamMap = new HashMap<Date, OccupancyHourlyPropUpdateParam>();
        Date nowUntil5MinuteDate = TimeUtils.getUntil5MinuteDate(now);
        OccupancyHourlyPropUpdateParam npwPropUpdateParam = new OccupancyHourlyPropUpdateParam();
        npwPropUpdateParam.setRegionalPlanId(regionalPlanId);
        npwPropUpdateParam.setDeviceId(plan.getDeviceId());
        npwPropUpdateParam.setDepId(plan.getDepId());
        npwPropUpdateParam.setEnterpriseId(plan.getEnterpriseId());
        npwPropUpdateParam.setTimePoint(nowUntil5MinuteDate);
        npwPropUpdateParam.setTableTurnoverCount(tableTurnoverCount);
        npwPropUpdateParam.setOccupants(occupants);
        hourlyPropUpdateParamMap.put(nowUntil5MinuteDate, npwPropUpdateParam);
        if (CollectionUtils.isNotEmpty((Collection)inOutList)) {
            for (OccupancyInOut inOut : inOutList) {
                long l;
                Date inUntil5MinuteDate = TimeUtils.getUntil5MinuteDate(inOut.getInTime());
                Date outUntil5MinuteDate = TimeUtils.getUntil5MinuteDate(inOut.getOutTime());
                if (inUntil5MinuteDate == null || outUntil5MinuteDate == null || (l = outUntil5MinuteDate.getTime() - inUntil5MinuteDate.getTime()) > 86400000L || l < 0L) continue;
                Calendar cal = Calendar.getInstance();
                cal.setTime(inUntil5MinuteDate);
                int n = 0;
                while (!cal.getTime().after(outUntil5MinuteDate)) {
                    int endIndex;
                    int startIndex;
                    Date until5MinuteDate2 = cal.getTime();
                    OccupancyHourlyPropUpdateParam propUpdateParam2 = (OccupancyHourlyPropUpdateParam)hourlyPropUpdateParamMap.get(until5MinuteDate2);
                    if (propUpdateParam2 == null) {
                        propUpdateParam2 = new OccupancyHourlyPropUpdateParam();
                        propUpdateParam2.setRegionalPlanId(regionalPlanId);
                        propUpdateParam2.setDeviceId(plan.getDeviceId());
                        propUpdateParam2.setDepId(plan.getDepId());
                        propUpdateParam2.setEnterpriseId(plan.getEnterpriseId());
                        propUpdateParam2.setTimePoint(until5MinuteDate2);
                        propUpdateParam2.setOccupants(occupants);
                        hourlyPropUpdateParamMap.put(until5MinuteDate2, propUpdateParam2);
                    }
                    cal.add(12, 5);
                    Date startTime = until5MinuteDate2;
                    Date endTime = TimeUtils.addSecond(cal.getTime(), -1);
                    if (n == 0) {
                        startTime = inOut.getInTime();
                        propUpdateParam2.setPassengerFlow(Integer.valueOf(propUpdateParam2.getPassengerFlow() + 1));
                        propUpdateParam2.setStayTime(Long.valueOf(propUpdateParam2.getStayTime() + (inOut.getOutTime().getTime() - inOut.getInTime().getTime())));
                    }
                    if (until5MinuteDate2.equals(outUntil5MinuteDate)) {
                        endTime = inOut.getOutTime();
                    }
                    if ((startIndex = TimeUtils.getSecondIndex(startTime).intValue()) <= (endIndex = TimeUtils.getSecondIndex(endTime).intValue())) {
                        for (int i = startIndex; i <= endIndex; ++i) {
                            propUpdateParam2.getOccupancySecondIndexes().add(i);
                        }
                    }
                    ++n;
                }
            }
        }
        if (hourlyPropUpdateParamMap.isEmpty()) {
            return;
        }
        hourlyPropUpdateParamMap.forEach((until5MinuteDate, propUpdateParam) -> {
            try {
                this.deviceOccupancyRegional5minRepository.update(propUpdateParam);
            }
            catch (Exception e) {
                log.error("propUpdateParam\u66f4\u65b0\u5931\u8d25\uff0cparam:{}", propUpdateParam, (Object)e);
            }
        });
    }
}

