/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.passenger.event;

import com.ovopark.passenger.occupancy.entity.OccupancyHourlyPropUpdateParam;
import com.ovopark.passenger.occupancy.entity.OccupancyRegionalHourlyRepository;
import com.ovopark.passenger.occupancy.entity.OccupancyRegionalPlan;
import com.ovopark.passenger.occupancy.entity.OccupancyRegionalPlanRepository;
import com.ovopark.passenger.occupancy.event.OccupancyInOut;
import com.ovopark.passenger.occupancy.event.OccupancyUploadEvent;
import com.ovopark.passenger.util.TimeUtils;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

@Component
public class OccupancyUploadEventListener
implements ApplicationListener<OccupancyUploadEvent> {
    private static final Logger log = LoggerFactory.getLogger(OccupancyUploadEventListener.class);
    @Resource
    private OccupancyRegionalPlanRepository occupancyRegionalPlanRepository;
    @Resource
    private OccupancyRegionalHourlyRepository occupancyRegionalHourlyRepository;

    public void onApplicationEvent(OccupancyUploadEvent event) {
        Integer regionalPlanId = event.getRegionalPlanId();
        Integer tableTurnoverCount = event.getTableTurnoverCount() == null ? 0 : event.getTableTurnoverCount();
        List inOutList = event.getInOutList();
        if (tableTurnoverCount == 0 && CollectionUtils.isNotEmpty((Collection)inOutList) || regionalPlanId == null) {
            log.warn("OccupancyUploadEventListener \u4f20\u53c2\u6709\u8bef\uff0cOccupancyUploadEvent: {}", (Object)event);
            return;
        }
        OccupancyRegionalPlan plan = this.occupancyRegionalPlanRepository.getById(regionalPlanId);
        if (plan == null) {
            log.warn("OccupancyUploadEventListener regionalPlanId\u4e3a\u7a7a\uff0cOccupancyUploadEvent: {}", (Object)event);
            return;
        }
        Date now = new Date();
        HashMap<Date, OccupancyHourlyPropUpdateParam> hourlyPropUpdateParamMap = new HashMap<Date, OccupancyHourlyPropUpdateParam>();
        if (tableTurnoverCount != 0) {
            Date hourDate2 = TimeUtils.getHourDate(now);
            OccupancyHourlyPropUpdateParam propUpdateParam2 = new OccupancyHourlyPropUpdateParam();
            propUpdateParam2.setRegionalPlanId(regionalPlanId);
            propUpdateParam2.setDeviceId(plan.getDeviceId());
            propUpdateParam2.setDepId(plan.getDepId());
            propUpdateParam2.setEnterpriseId(plan.getEnterpriseId());
            propUpdateParam2.setTimePoint(hourDate2);
            propUpdateParam2.setTableTurnoverCount(tableTurnoverCount);
            hourlyPropUpdateParamMap.put(hourDate2, propUpdateParam2);
        }
        if (CollectionUtils.isNotEmpty((Collection)inOutList)) {
            for (OccupancyInOut inOut : inOutList) {
                long l;
                Date inHourDate = TimeUtils.getHourDate(inOut.getInTime());
                Date outHourDate = TimeUtils.getHourDate(inOut.getOutTime());
                if (inHourDate == null || outHourDate == null || (l = outHourDate.getTime() - inHourDate.getTime()) > 86400000L || l < 0L) continue;
                Calendar cal = Calendar.getInstance();
                cal.setTime(inHourDate);
                int n = 0;
                while (!cal.getTime().after(outHourDate)) {
                    int endIndex;
                    int startIndex;
                    Date hourDate3 = cal.getTime();
                    OccupancyHourlyPropUpdateParam propUpdateParam3 = (OccupancyHourlyPropUpdateParam)hourlyPropUpdateParamMap.get(hourDate3);
                    if (propUpdateParam3 == null) {
                        propUpdateParam3 = new OccupancyHourlyPropUpdateParam();
                        propUpdateParam3.setRegionalPlanId(regionalPlanId);
                        propUpdateParam3.setDeviceId(plan.getDeviceId());
                        propUpdateParam3.setDepId(plan.getDepId());
                        propUpdateParam3.setEnterpriseId(plan.getEnterpriseId());
                        propUpdateParam3.setTimePoint(hourDate3);
                        hourlyPropUpdateParamMap.put(hourDate3, propUpdateParam3);
                    }
                    cal.add(10, 1);
                    Date startTime = hourDate3;
                    Date endTime = TimeUtils.addSecond(cal.getTime(), -1);
                    if (n == 0) {
                        startTime = inOut.getInTime();
                        propUpdateParam3.setPassengerFlow(Integer.valueOf(propUpdateParam3.getPassengerFlow() + 1));
                        propUpdateParam3.setStayTime(Long.valueOf(propUpdateParam3.getStayTime() + (inOut.getOutTime().getTime() - inOut.getInTime().getTime())));
                    }
                    if (hourDate3.equals(outHourDate)) {
                        endTime = inOut.getOutTime();
                    }
                    if ((startIndex = TimeUtils.getSecondIndex(startTime).intValue()) <= (endIndex = TimeUtils.getSecondIndex(endTime).intValue())) {
                        for (int i = startIndex; i <= endIndex; ++i) {
                            propUpdateParam3.getOccupancySecondIndexes().add(i);
                        }
                    }
                    ++n;
                }
            }
        }
        if (hourlyPropUpdateParamMap.isEmpty()) {
            return;
        }
        hourlyPropUpdateParamMap.forEach((hourDate, propUpdateParam) -> {
            try {
                this.occupancyRegionalHourlyRepository.update(propUpdateParam);
            }
            catch (Exception e) {
                log.error("propUpdateParam\u66f4\u65b0\u5931\u8d25\uff0cparam:{}", propUpdateParam, (Object)e);
            }
        });
    }
}

