/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.passenger.exception;

import com.ovopark.passenger.exception.BizException;
import com.ovopark.passenger.exception.ResultCodeEnum;
import com.ovopark.passenger.exception.SysException;
import com.ovopark.pojo.BaseResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;

@ControllerAdvice
public class GlobalExceptionHandler {
    private static final Logger logger = LoggerFactory.getLogger(GlobalExceptionHandler.class);

    @ResponseBody
    @ExceptionHandler(value={BizException.class})
    public BaseResult bizExceptionHandler(BizException ex) {
        logger.error(ex.getMessage(), (Throwable)ex);
        return BaseResult.error((String)ex.getCode(), (String)ex.getMessage());
    }

    @ResponseBody
    @ExceptionHandler(value={SysException.class})
    public BaseResult sysExceptionHandler(SysException ex) {
        logger.error(ex.getMessage(), (Throwable)ex);
        return BaseResult.error((String)ex.getCode(), (String)ex.getMessage());
    }

    @ResponseBody
    @ExceptionHandler(value={Exception.class})
    public BaseResult errorHandler(Exception ex) {
        logger.error("\u5168\u5c40\u5f02\u5e38", (Throwable)ex);
        return BaseResult.error((String)"500", (String)ex.getMessage());
    }

    @ResponseBody
    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public BaseResult arguementsValidateErrorHandler(MethodArgumentNotValidException ex) {
        logger.warn("\u53c2\u6570\u6821\u9a8c\u5f02\u5e38", (Throwable)ex);
        List fieldErrors = ex.getBindingResult().getFieldErrors();
        if (CollectionUtils.isNotEmpty((Collection)fieldErrors)) {
            return BaseResult.error((String)ResultCodeEnum.PARAM_ERROR.getCode(), (String)((FieldError)fieldErrors.get(0)).getDefaultMessage());
        }
        return BaseResult.error((String)ResultCodeEnum.PARAM_ERROR.getCode(), (String)ResultCodeEnum.PARAM_ERROR.getMessage());
    }

    @ResponseBody
    @ExceptionHandler(value={ConstraintViolationException.class})
    public BaseResult arguementsValidateErrorHandler(ConstraintViolationException ex) {
        logger.warn("\u53c2\u6570\u6821\u9a8c\u5f02\u5e38", (Throwable)ex);
        Set constraintViolations = ex.getConstraintViolations();
        if (CollectionUtils.isNotEmpty((Collection)constraintViolations)) {
            ArrayList list = new ArrayList(constraintViolations);
            return BaseResult.error((String)ResultCodeEnum.PARAM_ERROR.getCode(), (String)((ConstraintViolation)list.get(0)).getMessage());
        }
        return BaseResult.error((String)ResultCodeEnum.PARAM_ERROR.getCode(), (String)ResultCodeEnum.PARAM_ERROR.getMessage());
    }
}

