/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.passenger.feign;

import com.alibaba.fastjson.JSON;
import com.ovopark.organize.common.base.BaseResult;
import com.ovopark.organize.common.model.mo.DataStatisticMo;
import com.ovopark.organize.common.model.mo.DataStatisticModule;
import com.ovopark.organize.sdk.api.DataStatisticApi;
import com.ovopark.passenger.util.LocalDateTimeUtils;
import java.util.Date;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DataStatisticFeign {
    private static final Logger log = LoggerFactory.getLogger(DataStatisticFeign.class);
    @Resource
    private DataStatisticApi dataStatisticApi;

    public Boolean reportNewAddStoreNum(Date date, Integer newAddStoreNum) {
        if (date == null || newAddStoreNum == null) {
            return false;
        }
        DataStatisticMo mo = new DataStatisticMo();
        mo.setModule(DataStatisticModule.PASSENGER);
        mo.setDate(LocalDateTimeUtils.convertDateToLDT(date).toLocalDate());
        mo.setNewDepCount(newAddStoreNum);
        BaseResult result = this.dataStatisticApi.postData(mo);
        if (!result.getIsError().booleanValue() && result.getData() != null) {
            return (Boolean)result.getData();
        }
        log.info(JSON.toJSONString((Object)result));
        return false;
    }
}

