/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.passenger.feign;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.google.common.collect.Lists;
import com.ovopark.api.BaseDeviceApi;
import com.ovopark.device.cloud.api.DeviceApi;
import com.ovopark.device.cloud.api.DeviceStatusApi;
import com.ovopark.device.cloud.api.VideoFeignService;
import com.ovopark.device.cloud.common.model.mo.BatchUpdateDevicePassengerFlowOrHotspotMo;
import com.ovopark.device.cloud.common.model.mo.DeviceRecordPictureFeignMo;
import com.ovopark.device.cloud.common.model.mo.DeviceStatusMo;
import com.ovopark.device.cloud.common.model.mo.DevicesMo;
import com.ovopark.device.cloud.common.model.mo.GetPassFlowDeviceStatusListMo;
import com.ovopark.device.cloud.common.model.mo.SetMultiReidCfgMo;
import com.ovopark.device.cloud.common.model.mo.VideoDownloadFeignMo;
import com.ovopark.device.cloud.common.model.vo.DevicesVo;
import com.ovopark.device.cloud.common.model.vo.DownloadVideoFeignVo;
import com.ovopark.passenger.support.DeviceStatus;
import com.ovopark.pojo.dto.BaseResult;
import com.ovopark.pojo.dto.DeviceDto;
import com.ovopark.pojo.dto.DeviceStatusDto;
import com.ovopark.pojo.dto.EnterpriseDepartmentsDto;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DeviceFeign {
    private static final Logger log = LoggerFactory.getLogger(DeviceFeign.class);
    @Resource
    private DeviceApi deviceApi;
    @Resource
    private DeviceStatusApi deviceStatusApi;
    @Resource
    private VideoFeignService videoFeignService;
    @Resource
    private BaseDeviceApi baseDeviceApi;
    @Autowired
    private com.ovopark.api.DeviceStatusApi baseDeviceStatusApi;

    public Boolean delPFlowHotspots(Integer enterpriseId, List<Integer> productIds) {
        try {
            com.ovopark.device.common.response.BaseResult baseResult = this.deviceApi.delPFlowHotspots(enterpriseId, productIds.stream().map(String::valueOf).collect(Collectors.toList()));
            if (baseResult == null) {
                log.info("delPFlowHotspots\u8fd4\u56de\u503c\u4e3a\u7a7a");
                return false;
            }
            log.info("delPFlowHotspots result:{}", (Object)JSONObject.toJSONString((Object)baseResult));
            return baseResult.getIsError() == false;
        }
        catch (Exception e) {
            log.error("delPFlowHotspots fail", (Throwable)e);
            return false;
        }
    }

    public Map<Integer, String> getDeviceName(List<Integer> deviceStatusIds) {
        try {
            com.ovopark.device.common.response.BaseResult baseResult = this.deviceStatusApi.getDeviceName(deviceStatusIds);
            if (Objects.nonNull(baseResult) && !baseResult.getIsError().booleanValue()) {
                log.info("getDeviceName result:{}", (Object)JSONObject.toJSONString((Object)baseResult));
                return (Map)baseResult.getData();
            }
            return null;
        }
        catch (Exception e) {
            log.error("getDeviceName fail", (Throwable)e);
            return null;
        }
    }

    public DeviceStatusMo getDeviceStatusById(Integer deviceStatusId) {
        try {
            log.info("getDeviceStatusById param:{}", (Object)deviceStatusId);
            com.ovopark.device.common.response.BaseResult baseResult = this.deviceStatusApi.findById(deviceStatusId);
            log.info("getDeviceStatusById result:{}", (Object)JSONObject.toJSONString((Object)baseResult));
            if (Objects.nonNull(baseResult) && !baseResult.getIsError().booleanValue()) {
                return (DeviceStatusMo)baseResult.getData();
            }
            return null;
        }
        catch (Exception e) {
            log.error("getDeviceStatusById fail", (Throwable)e);
            return null;
        }
    }

    public List<DevicesMo> listDeviceMoByIds(List<Integer> deviceIds) {
        try {
            log.info("listDeviceMoByIds param:{}", deviceIds);
            com.ovopark.device.common.response.BaseResult baseResult = this.deviceApi.getDeviceMoByIds(deviceIds);
            log.info("listDeviceMoByIds result:{}", (Object)JSONObject.toJSONString((Object)baseResult));
            if (Objects.nonNull(baseResult) && !baseResult.getIsError().booleanValue() && Objects.nonNull(baseResult.getData())) {
                return (List)baseResult.getData();
            }
            return new ArrayList<DevicesMo>();
        }
        catch (Exception e) {
            log.error("listDeviceMoByIds fail", (Throwable)e);
            return new ArrayList<DevicesMo>();
        }
    }

    public List<DeviceStatusMo> getDeviceStatusListByIds(List<Integer> deviceStatusIds) {
        try {
            com.ovopark.device.common.response.BaseResult baseResult = this.deviceStatusApi.findByIds(deviceStatusIds);
            if (Objects.nonNull(baseResult) && !baseResult.getIsError().booleanValue()) {
                log.info("getDeviceStatusListByIds result:{}", (Object)JSONObject.toJSONString((Object)baseResult));
                return (List)baseResult.getData();
            }
            return null;
        }
        catch (Exception e) {
            log.error("getDeviceStatusListByIds fail", (Throwable)e);
            return null;
        }
    }

    public List<DeviceStatus> listDeviceByUser(Integer enterpriseId, Integer userId, String filterName) {
        if (Objects.isNull(enterpriseId) || Objects.isNull(userId)) {
            log.warn("getDeviceStatusListByDeviceIds param is null");
            return new ArrayList<DeviceStatus>();
        }
        GetPassFlowDeviceStatusListMo param = new GetPassFlowDeviceStatusListMo();
        param.setUserId(userId);
        param.setEnterpriseId(enterpriseId);
        param.setDeviceName(filterName);
        try {
            com.ovopark.device.common.response.BaseResult deviceRes = this.deviceStatusApi.getPassFlowDeviceStatusList(param);
            if (Objects.nonNull(deviceRes) && !deviceRes.getIsError().booleanValue() && Objects.nonNull(deviceRes.getData())) {
                log.info("getDeviceStatusListByDeviceIds result:{}", (Object)JSONObject.toJSONString((Object)deviceRes));
                return ((List)deviceRes.getData()).stream().map(m -> {
                    DeviceStatus vo = new DeviceStatus();
                    vo.setId(m.getDeviceStatusId());
                    vo.setMac(m.getMac());
                    vo.setDeviceType(m.getDeviceType());
                    vo.setName(m.getDeviceName());
                    vo.setDType(m.getDType());
                    vo.setDepId(m.getDepId());
                    return vo;
                }).collect(Collectors.toList());
            }
            return new ArrayList<DeviceStatus>();
        }
        catch (Exception e) {
            log.error("getDeviceStatusListByDeviceIds fail", (Throwable)e);
            return new ArrayList<DeviceStatus>();
        }
    }

    public List<DeviceStatus> listIpcByNvrDeviceId(Integer nvrDeviceId) {
        if (Objects.isNull(nvrDeviceId)) {
            log.warn("listIpcByNvrDeviceId param is null");
            return new ArrayList<DeviceStatus>();
        }
        com.ovopark.device.common.response.BaseResult res = this.deviceStatusApi.getIpcListSimpleByNvrId(nvrDeviceId);
        if (Objects.nonNull(res) && !res.getIsError().booleanValue() && Objects.nonNull(res.getData())) {
            log.info("listIpcByNvrDeviceId nvrDeviceId:{},result:{}", (Object)nvrDeviceId, (Object)JSONObject.toJSONString((Object)res));
            return ((List)res.getData()).stream().map(m -> {
                DeviceStatus vo = new DeviceStatus();
                vo.setId(m.getId());
                vo.setMac(m.getMac());
                vo.setName(m.getDeviceName());
                vo.setChannelId(m.getChannelId());
                return vo;
            }).collect(Collectors.toList());
        }
        return new ArrayList<DeviceStatus>();
    }

    public boolean setMultiReidCfg(SetMultiReidCfgMo setMultiReidCfgMo) {
        log.info("setMultiReidCfg param:{}", (Object)JSONObject.toJSONString((Object)setMultiReidCfgMo));
        com.ovopark.device.common.response.BaseResult dms2New1ResBaseResult = this.deviceStatusApi.setMultiReidCfg(setMultiReidCfgMo);
        log.info("setMultiReidCfg result:{}", (Object)JSONObject.toJSONString((Object)dms2New1ResBaseResult));
        if (Objects.isNull(dms2New1ResBaseResult) || dms2New1ResBaseResult.getIsError().booleanValue() || Objects.isNull(dms2New1ResBaseResult.getData())) {
            return false;
        }
        JSONObject jsonObject = JSONObject.parseObject((String)JSONObject.toJSONString((Object)dms2New1ResBaseResult.getData()));
        return jsonObject != null && Optional.ofNullable(jsonObject.getInteger("result")).map(r -> Objects.equals(r, 200000)).orElse(false) != false;
    }

    public void batchUpdateDeviceHotspotStatus(List<Integer> ids, Boolean isHotspot) {
        log.info("batchUpdateDeviceHotspotStatus param ids:{},isHotspot:{}", ids, (Object)isHotspot);
        com.ovopark.device.common.response.BaseResult baseResult = this.updateDeviceStatus(ids, isHotspot, BatchUpdateDevicePassengerFlowOrHotspotMo.TYPE_HOTSPOT);
        log.info("batchUpdateDeviceHotspotStatus result:{}", (Object)JSONObject.toJSONString((Object)baseResult));
    }

    private com.ovopark.device.common.response.BaseResult updateDeviceStatus(List<Integer> ids, Boolean enable, Integer type) {
        BatchUpdateDevicePassengerFlowOrHotspotMo mo = new BatchUpdateDevicePassengerFlowOrHotspotMo();
        mo.setIds(ids);
        mo.setEnable(Integer.valueOf(enable != false ? 1 : 0));
        mo.setType(type);
        com.ovopark.device.common.response.BaseResult baseResult = this.deviceStatusApi.batchUpdateDevicePassengerFlowOrHotspot(mo);
        return baseResult;
    }

    public void batchUpdateDevicePassengerStatus(List<Integer> ids, Boolean isPassengerFlow) {
        log.info("batchUpdateDevicePassengerStatus param ids:{},isPassengerFlow:{}", ids, (Object)isPassengerFlow);
        com.ovopark.device.common.response.BaseResult baseResult = this.updateDeviceStatus(ids, isPassengerFlow, BatchUpdateDevicePassengerFlowOrHotspotMo.TYPE_PASSENGERFLOW);
        log.info("batchUpdateDevicePassengerStatus result:{}", (Object)JSONObject.toJSONString((Object)baseResult));
    }

    public DevicesVo getDeviceByVideoId(Integer videoId) {
        DevicesVo devicesVo = new DevicesVo();
        if (Objects.isNull(videoId)) {
            return devicesVo;
        }
        try {
            com.ovopark.device.common.response.BaseResult baseRes = this.deviceApi.getDeviceById(videoId);
            log.info("getDeviceById baseRes:{}", (Object)JSONObject.toJSONString((Object)baseRes));
            if (Objects.nonNull(baseRes) && !baseRes.getIsError().booleanValue() && Objects.nonNull(baseRes.getData())) {
                return (DevicesVo)baseRes.getData();
            }
            return devicesVo;
        }
        catch (Exception e) {
            log.error("getDeviceById fail", (Throwable)e);
            return devicesVo;
        }
    }

    public Boolean getDeviceRecordPicture(Integer userId, Integer videoId, String startTime, String endTime, String callBackUrl) {
        Boolean flag = false;
        DeviceRecordPictureFeignMo mo = new DeviceRecordPictureFeignMo();
        mo.setUserId(userId);
        mo.setDeviceId(videoId);
        mo.setStartTime(startTime);
        mo.setEndTime(endTime);
        mo.setInterval((List)Lists.newArrayList((Object[])new Long[]{0L}));
        mo.setCallBackUrl(callBackUrl);
        mo.setExpirePolicy("ThreeMonth");
        try {
            com.ovopark.device.common.response.BaseResult baseResult = this.videoFeignService.deviceRecordPicture(mo);
            log.info("deviceRecordPicture result:{}", (Object)JSONObject.toJSONString((Object)baseResult));
            flag = baseResult.getIsError() == false;
        }
        catch (Exception e) {
            log.error("deviceRecordPicture fail", (Throwable)e);
        }
        return flag;
    }

    public DownloadVideoFeignVo downloadVideo(Integer userId, Integer videoId, String startTime, String endTime) {
        DownloadVideoFeignVo result = new DownloadVideoFeignVo();
        VideoDownloadFeignMo mo = new VideoDownloadFeignMo();
        mo.setUserId(userId);
        mo.setDeviceId(videoId);
        mo.setStartTime(startTime);
        mo.setEndTime(endTime);
        try {
            com.ovopark.device.common.response.BaseResult baseRes = this.videoFeignService.downloadVideoV2(mo);
            log.info("downloadVideo baseRes:{}", (Object)JSONObject.toJSONString((Object)baseRes));
            if (Objects.nonNull(baseRes) && !baseRes.getIsError().booleanValue() && Objects.nonNull(baseRes.getData())) {
                return (DownloadVideoFeignVo)baseRes.getData();
            }
            return result;
        }
        catch (Exception e) {
            log.error("downloadVideo fail", (Throwable)e);
            return result;
        }
    }

    public DeviceDto getDeviceById(Integer id) {
        if (id == null) {
            return null;
        }
        BaseResult res = this.baseDeviceApi.getById(id);
        if (res != null && !res.getIsError().booleanValue() && res.getData() != null) {
            return (DeviceDto)res.getData();
        }
        return null;
    }

    public List<EnterpriseDepartmentsDto> getDepIdsByMacs(List<String> macs) {
        if (CollectionUtils.isEmpty(macs)) {
            return new ArrayList<EnterpriseDepartmentsDto>();
        }
        BaseResult res = this.baseDeviceStatusApi.listDepIdByMacs(macs);
        if (res != null && !res.getIsError().booleanValue() && res.getData() != null) {
            return (List)res.getData();
        }
        return new ArrayList<EnterpriseDepartmentsDto>();
    }

    public List<DeviceStatusDto> listDeviceStatusDtoByMac(String mac) {
        if (StringUtils.isEmpty((CharSequence)mac)) {
            return new ArrayList<DeviceStatusDto>();
        }
        BaseResult listBaseResult = this.baseDeviceStatusApi.listValidDeviceByMac(mac);
        if (listBaseResult == null || listBaseResult.getIsError().booleanValue()) {
            return new ArrayList<DeviceStatusDto>();
        }
        return (List)listBaseResult.getData();
    }

    public DeviceStatusDto getDeviceStatusDtoByMac(String mac, Integer dType) {
        if (StringUtils.isEmpty((CharSequence)mac)) {
            return null;
        }
        List<DeviceStatusDto> deviceStatusDtos = this.listDeviceStatusDtoByMac(mac);
        if (CollectionUtils.isEmpty(deviceStatusDtos)) {
            return null;
        }
        if (dType == null) {
            return deviceStatusDtos.get(0);
        }
        for (DeviceStatusDto deviceStatusDto : deviceStatusDtos) {
            if (!dType.equals(deviceStatusDto.getdType())) continue;
            return deviceStatusDto;
        }
        return null;
    }
}

