/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.passenger.feign;

import com.ovopark.hotspot.api.HotspotDataApi;
import com.ovopark.hotspot.pojo.dto.DepartmentHotspotDto;
import com.ovopark.hotspot.pojo.dto.HotspotParam;
import com.ovopark.pojo.BaseResult;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class HotspotDataFeign {
    @Resource
    private HotspotDataApi hotspotDataApi;

    public List<Integer> getDepIdsHavingHotspotDevice(List<Integer> depIds) {
        if (CollectionUtils.isEmpty(depIds)) {
            return new ArrayList<Integer>();
        }
        BaseResult hotspotRes = this.hotspotDataApi.getDepIdsHavingHotspotDevice(depIds);
        if (hotspotRes != null && !hotspotRes.getIsError().booleanValue() && hotspotRes.getData() != null) {
            return (List)hotspotRes.getData();
        }
        return new ArrayList<Integer>();
    }

    public DepartmentHotspotDto getDepartmentHotspotData(HotspotParam param) {
        if (Objects.isNull(param) || Objects.isNull(param.getDepId()) || StringUtils.isBlank((CharSequence)param.getStartTime()) || StringUtils.isBlank((CharSequence)param.getEndTime())) {
            return null;
        }
        BaseResult hotspotRes = this.hotspotDataApi.getDepartmentHotspotData(param);
        if (hotspotRes != null && !hotspotRes.getIsError().booleanValue() && hotspotRes.getData() != null) {
            return (DepartmentHotspotDto)hotspotRes.getData();
        }
        return null;
    }
}

