/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.passenger.pojo;

import com.ovopark.passenger.pojo.ClientInfo;
import com.ovopark.passenger.support.User;
import com.ovopark.passenger.util.TimeUtils;
import com.ovopark.pojo.UserPojo;
import java.util.Date;

public class Authenticator {
    private static Authenticator instance;
    private ThreadLocal<ClientInfo> currentClient = new ThreadLocal();

    public ClientInfo getCurrentClient() {
        return this.currentClient.get();
    }

    public void setCurrentClient(ClientInfo clientInfo) {
        this.currentClient.set(clientInfo);
    }

    public UserPojo getCurrentUser() {
        ClientInfo ci = this.currentClient.get();
        return ci == null ? null : ci.getUser();
    }

    public User getUser() {
        UserPojo user = this.getCurrentUser();
        if (user == null) {
            return null;
        }
        User u = new User();
        u.setId(user.getId());
        u.setUserName(user.getUserName());
        u.setShowName(user.getShowName());
        u.setEnterpriseId(user.getGroupId());
        return u;
    }

    public void setCurrentUser(UserPojo currentUser) {
        ClientInfo clientInfo = this.currentClient.get();
        if (clientInfo == null) {
            clientInfo = new ClientInfo();
            this.currentClient.set(clientInfo);
        }
        clientInfo.setUser(currentUser);
    }

    private Authenticator() {
    }

    public static Authenticator getInstance() {
        if (instance == null) {
            instance = new Authenticator();
        }
        return instance;
    }

    public Date now(Date now) {
        ClientInfo ci = this.currentClient.get();
        if (ci == null) {
            ci = new ClientInfo();
            this.setCurrentClient(ci);
        }
        if (now != null) {
            ci.setNow(now);
            return ci.getNow();
        }
        if (ci.getNow() != null) {
            return ci.getNow();
        }
        String timeZone = ci.getTimeZone();
        ci.setNow(TimeUtils.now(timeZone));
        return ci.getNow();
    }

    public Date now() {
        return this.now(null);
    }

    public void clearCurrentClient() {
        this.currentClient.remove();
    }
}

