/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.passenger.repository.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ovopark.passenger.model.DeviceOccupancyRegional5minModel;
import com.ovopark.passenger.occupancy.DeviceOccupancyRegional5minRepository;
import com.ovopark.passenger.occupancy.entity.OccupancyHourlyPropUpdateParam;
import com.ovopark.passenger.occupancy.entity.OccupancyRegional5min;
import com.ovopark.passenger.service.DeviceOccupancyRegional5minService;
import com.ovopark.passenger.util.LocalDateTimeUtils;
import java.time.ZoneId;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service(value="deviceOccupancyRegional5minRepository")
public class DeviceOccupancyRegional5minRepositoryImpl
implements DeviceOccupancyRegional5minRepository {
    @Resource
    private DeviceOccupancyRegional5minService deviceOccupancyRegional5minService;

    public boolean update(OccupancyHourlyPropUpdateParam propUpdateParam) {
        Integer regionalPlanId = propUpdateParam.getRegionalPlanId();
        Date timePoint = propUpdateParam.getTimePoint();
        Set occupancySecondIndexes = propUpdateParam.getOccupancySecondIndexes();
        boolean haveIncrementData = CollectionUtils.isNotEmpty((Collection)occupancySecondIndexes) || propUpdateParam.getPassengerFlow() > 0 || propUpdateParam.getStayTime() > 0L || propUpdateParam.getTableTurnoverCount() > 0;
        DeviceOccupancyRegional5minModel model = this.deviceOccupancyRegional5minService.getByUniqueKey(regionalPlanId, timePoint);
        if (model == null) {
            model = new DeviceOccupancyRegional5minModel();
            model.setRegionalPlanId(regionalPlanId);
            model.setDeviceId(propUpdateParam.getDeviceId());
            model.setDepId(propUpdateParam.getDepId());
            model.setEnterpriseId(propUpdateParam.getEnterpriseId());
            model.setTimePoint(timePoint.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime());
            model.setTotalStayTime(0L);
            model.setTotalPassengerFlow(0);
            model.setTimeOccupancyDesc(JSONObject.toJSONString((Object)new short[300]));
            model.setOccupancySeconds(0);
            model.setTableTurnoverCount(0);
            model.setVersionNum(0);
            model.setOccupants(propUpdateParam.getOccupants());
            model.setIsOccupied(propUpdateParam.getOccupants() > 0);
            if (!haveIncrementData) {
                return this.deviceOccupancyRegional5minService.save((Object)model);
            }
        }
        if (!haveIncrementData) {
            return true;
        }
        if (CollectionUtils.isNotEmpty((Collection)occupancySecondIndexes)) {
            if (StringUtils.isBlank((CharSequence)model.getTimeOccupancyDesc())) {
                model.setTimeOccupancyDesc(JSONObject.toJSONString((Object)new short[300]));
            }
            JSONArray jsonArray = JSONArray.parseArray((String)model.getTimeOccupancyDesc());
            for (Integer index : occupancySecondIndexes) {
                jsonArray.set(index.intValue(), (Object)1);
            }
            model.setTimeOccupancyDesc(JSONObject.toJSONString((Object)jsonArray));
            long count = jsonArray.stream().filter(item -> item.equals(1)).count();
            model.setOccupancySeconds(Integer.parseInt(String.valueOf(count)));
        }
        model.setTotalPassengerFlow(model.getTotalPassengerFlow() + propUpdateParam.getPassengerFlow());
        model.setTotalStayTime(model.getTotalStayTime() + propUpdateParam.getStayTime());
        model.setTableTurnoverCount(model.getTableTurnoverCount() + propUpdateParam.getTableTurnoverCount());
        return this.deviceOccupancyRegional5minService.saveOrUpdate((Object)model);
    }

    public List<OccupancyRegional5min> getOccupancyRegional5minListByRegionalPlanIds(List<Integer> regionalPlanIds, String stime, String etime) {
        List<DeviceOccupancyRegional5minModel> models = this.deviceOccupancyRegional5minService.getOccupancyRegional5minListByRegionalPlanIds(regionalPlanIds, stime, etime);
        List<OccupancyRegional5min> result = models.stream().map(this::model2Domain).collect(Collectors.toList());
        return result;
    }

    private OccupancyRegional5min model2Domain(DeviceOccupancyRegional5minModel model) {
        if (model == null) {
            return null;
        }
        OccupancyRegional5min domain = new OccupancyRegional5min();
        domain.setId(model.getId());
        domain.setRegionalPlanId(model.getRegionalPlanId());
        domain.setTimePoint(model.getTimePoint());
        domain.setTime(LocalDateTimeUtils.formatTime(model.getTimePoint(), "yyyy-MM-dd HH:mm:ss"));
        domain.setIsOccupied(model.getIsOccupied());
        domain.setOccupants(model.getOccupants());
        domain.setDeviceId(model.getDeviceId());
        domain.setDepId(model.getDepId());
        domain.setEnterpriseId(model.getEnterpriseId());
        domain.setTotalStayTime(model.getTotalStayTime());
        domain.setTotalPassengerFlow(model.getTotalPassengerFlow());
        domain.setOccupancySeconds(model.getOccupancySeconds());
        domain.setTableTurnoverCount(model.getTableTurnoverCount());
        domain.setVersionNum(model.getVersionNum());
        return domain;
    }
}

