/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.passenger.repository.impl;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.ovopark.passenger.core.entity.DeviceFlowTag;
import com.ovopark.passenger.core.entity.DeviceProductArea;
import com.ovopark.passenger.core.entity.DeviceProductAreaRepository;
import com.ovopark.passenger.model.DeviceProductAreaModel;
import com.ovopark.passenger.model.ProductModel;
import com.ovopark.passenger.service.DeviceProductAreaService;
import com.ovopark.passenger.service.ProductService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service(value="deviceProductAreaRepository")
public class DeviceProductAreaRepositoryImpl
implements DeviceProductAreaRepository {
    @Resource
    private DeviceProductAreaService deviceProductAreaService;
    @Resource
    private ProductService productService;

    public List<DeviceProductArea> listProductAreaByDeviceIds(List<Integer> deviceIds) {
        if (deviceIds == null || deviceIds.isEmpty()) {
            return new ArrayList<DeviceProductArea>();
        }
        return this.deviceProductAreaService.listProductAreaByDeviceIds(deviceIds).stream().map(DeviceProductAreaModel::model2Domain).collect(Collectors.toList());
    }

    public List<DeviceProductArea> listValidByAreaIds(List<Integer> areaIds) {
        if (CollectionUtils.isEmpty(areaIds)) {
            return new ArrayList<DeviceProductArea>();
        }
        List models = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.deviceProductAreaService.lambdaQuery().in(DeviceProductAreaModel::getId, areaIds)).eq(DeviceProductAreaModel::getIsDelete, (Object)false)).list();
        if (CollectionUtils.isEmpty((Collection)models)) {
            return new ArrayList<DeviceProductArea>();
        }
        List productIds = models.stream().map(DeviceProductAreaModel::getProductId).distinct().collect(Collectors.toList());
        Map<Integer, String> productNameMap = this.productService.listByIds(productIds).stream().collect(Collectors.toMap(ProductModel::getId, ProductModel::getName));
        models.forEach(m -> {
            String s = (String)productNameMap.get(m.getProductId());
            if (StringUtils.isNotBlank((CharSequence)s)) {
                m.setProductName(s);
            }
        });
        return models.stream().map(DeviceProductAreaModel::model2Domain).collect(Collectors.toList());
    }

    public List<DeviceProductArea> listProductAreaByDepId(Integer depId, Boolean enableTouch) {
        if (depId == null) {
            return new ArrayList<DeviceProductArea>();
        }
        List<DeviceProductAreaModel> deviceProductAreaModels = this.deviceProductAreaService.listValidDeviceProductAreaByDeptId(depId, enableTouch);
        if (CollectionUtils.isEmpty(deviceProductAreaModels)) {
            return new ArrayList<DeviceProductArea>();
        }
        List productIds = deviceProductAreaModels.stream().map(DeviceProductAreaModel::getProductId).distinct().collect(Collectors.toList());
        this.productService.listByIds(productIds).forEach(p -> deviceProductAreaModels.forEach(m -> {
            if (m.getProductId().equals(p.getId())) {
                m.setProductName(p.getName());
            }
        }));
        return deviceProductAreaModels.stream().map(DeviceProductAreaModel::model2Domain).collect(Collectors.toList());
    }

    public Map<Integer, Map<Integer, String>> getProductNameMap(List<DeviceFlowTag> deviceFlowTags) {
        HashMap<Integer, Map<Integer, String>> deviceProductNameMap = new HashMap<Integer, Map<Integer, String>>();
        if (CollectionUtils.isEmpty(deviceFlowTags)) {
            return deviceProductNameMap;
        }
        List<Integer> deviceIds = deviceFlowTags.stream().map(DeviceFlowTag::getDeviceId).distinct().collect(Collectors.toList());
        List<Object> deviceProductAreas = this.listProductAreaByDeviceIds(deviceIds);
        if (CollectionUtils.isEmpty(deviceProductAreas = deviceProductAreas.stream().filter(p -> p.getProductType() != 0).collect(Collectors.toList()))) {
            return deviceProductNameMap;
        }
        Map<Integer, List<DeviceProductArea>> deviceProductAreasMap = deviceProductAreas.stream().collect(Collectors.groupingBy(DeviceProductArea::getDeviceId));
        for (Map.Entry<Integer, List<DeviceProductArea>> entry : deviceProductAreasMap.entrySet()) {
            Integer deviceId = entry.getKey();
            List<DeviceProductArea> productAreas = entry.getValue();
            if (productAreas.size() == 1) continue;
            HashMap<Integer, String> productNameMap = new HashMap<Integer, String>();
            for (DeviceProductArea productArea : productAreas) {
                productNameMap.put(productArea.getProductId(), productArea.getProductName());
            }
            deviceProductNameMap.put(deviceId, productNameMap);
        }
        return deviceProductNameMap;
    }
}

