/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.passenger.repository.impl;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.ovopark.passenger.common.QueryParam;
import com.ovopark.passenger.common.util.NumberUtils;
import com.ovopark.passenger.dwell.entity.DwellTimeHourly;
import com.ovopark.passenger.dwell.entity.DwellTimeHourlyRepository;
import com.ovopark.passenger.dwell.valueobject.DwellTimeData;
import com.ovopark.passenger.model.DwellTimeHourlyModel;
import com.ovopark.passenger.service.DwellTimeHourlyService;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="dwellTimeHourlyRepository")
public class DwellTimeHourlyRepositoryImpl
implements DwellTimeHourlyRepository {
    private static final Logger log = LoggerFactory.getLogger(DwellTimeHourlyRepositoryImpl.class);
    @Resource
    private DwellTimeHourlyService dwellTimeHourlyService;

    public boolean saveBatch(List<DwellTimeHourly> dwellTimeHourlies) {
        dwellTimeHourlies.forEach(dwellTimeHourly -> {
            DwellTimeHourlyModel exist = (DwellTimeHourlyModel)((Object)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.dwellTimeHourlyService.lambdaQuery().eq(DwellTimeHourlyModel::getDepId, (Object)dwellTimeHourly.getDepId())).eq(DwellTimeHourlyModel::getRecordTime, (Object)dwellTimeHourly.getRecordTime())).one()));
            if (exist != null) {
                exist.setSumDwellTime(exist.getSumDwellTime() + dwellTimeHourly.getSumDwellTime());
                exist.setInCount(exist.getInCount() + dwellTimeHourly.getInCount());
                exist.setOutCount(exist.getOutCount() + dwellTimeHourly.getOutCount());
                exist.setSumPaxInStore(exist.getSumPaxInStore() + exist.getInCount());
                exist.setAvgDwellTime(NumberUtils.getDivide((Number)exist.getSumDwellTime(), (Number)exist.getSumPaxInStore(), (int)0).intValue());
                this.dwellTimeHourlyService.updateById((Object)exist);
            } else {
                try {
                    this.dwellTimeHourlyService.save((Object)this.domain2Po((DwellTimeHourly)dwellTimeHourly));
                }
                catch (Exception e) {
                    log.warn("saveBatch error, dwellTimeHourly: {}", dwellTimeHourly, (Object)e);
                }
            }
        });
        return true;
    }

    public boolean deleteByDepIdAndDate(Integer depId, String date) {
        return ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.dwellTimeHourlyService.lambdaUpdate().eq(DwellTimeHourlyModel::getDepId, (Object)depId)).likeRight(DwellTimeHourlyModel::getRecordTime, (Object)date)).remove();
    }

    private DwellTimeHourlyModel domain2Po(DwellTimeHourly hourly) {
        DwellTimeHourlyModel po = new DwellTimeHourlyModel();
        po.setDepId(hourly.getDepId());
        po.setRecordTime(hourly.getRecordTime());
        po.setSumDwellTime(hourly.getSumDwellTime());
        po.setStartPaxInStore(hourly.getStartPaxInStore());
        po.setSumPaxInStore(hourly.getSumPaxInStore());
        po.setAvgDwellTime(hourly.getAvgDwellTime());
        po.setInCount(hourly.getInCount());
        po.setOutCount(hourly.getOutCount());
        po.setStatsStartTime(hourly.getStatsStartTime());
        po.setStatsEndTime(hourly.getStatsEndTime());
        return po;
    }

    public List<DwellTimeData> listDwellTimeData(QueryParam queryParam) {
        return this.dwellTimeHourlyService.listDwellTimeData(queryParam);
    }
}

