/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.passenger.repository.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ovopark.passenger.common.util.DateUtils;
import com.ovopark.passenger.model.OccupancyRegionalHourlyModel;
import com.ovopark.passenger.occupancy.entity.OccupancyHourlyPropUpdateParam;
import com.ovopark.passenger.occupancy.entity.OccupancyRegionalHourly;
import com.ovopark.passenger.occupancy.entity.OccupancyRegionalHourlyRepository;
import com.ovopark.passenger.pojo.vo.OccupancyRegionalHourlyDbVo;
import com.ovopark.passenger.service.OccupancyRegionalHourlyService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service(value="occupancyRegionalHourlyRepository")
public class OccupancyRegionalHourlyRepositoryImpl
implements OccupancyRegionalHourlyRepository {
    @Resource
    private OccupancyRegionalHourlyService occupancyRegionalHourlyService;

    public boolean update(OccupancyHourlyPropUpdateParam propUpdateParam) {
        Set occupancySecondIndexes;
        Date timePoint;
        Integer regionalPlanId = propUpdateParam.getRegionalPlanId();
        OccupancyRegionalHourlyModel model = this.occupancyRegionalHourlyService.getByUniqueKey(regionalPlanId, timePoint = propUpdateParam.getTimePoint());
        if (model == null) {
            model = new OccupancyRegionalHourlyModel();
            model.setRegionalPlanId(regionalPlanId);
            model.setDeviceId(propUpdateParam.getDeviceId());
            model.setDepId(propUpdateParam.getDepId());
            model.setEnterpriseId(propUpdateParam.getEnterpriseId());
            model.setTimePoint(timePoint);
            model.setTotalStayTime(0L);
            model.setTotalPassengerFlow(0);
            model.setTimeOccupancyDesc(JSONObject.toJSONString((Object)new short[3600]));
            model.setOccupancySeconds(0);
            model.setTableTurnoverCount(0);
            model.setVersionNum(0);
        }
        if (CollectionUtils.isNotEmpty((Collection)(occupancySecondIndexes = propUpdateParam.getOccupancySecondIndexes()))) {
            JSONArray jsonArray = JSONArray.parseArray((String)model.getTimeOccupancyDesc());
            for (Integer index : occupancySecondIndexes) {
                jsonArray.set(index.intValue(), (Object)1);
            }
            model.setTimeOccupancyDesc(JSONObject.toJSONString((Object)jsonArray));
            long count = jsonArray.stream().filter(item -> item.equals(1)).count();
            model.setOccupancySeconds(Integer.parseInt(String.valueOf(count)));
        }
        model.setTotalPassengerFlow(model.getTotalPassengerFlow() + propUpdateParam.getPassengerFlow());
        model.setTotalStayTime(model.getTotalStayTime() + propUpdateParam.getStayTime());
        model.setTableTurnoverCount(model.getTableTurnoverCount() + propUpdateParam.getTableTurnoverCount());
        return this.occupancyRegionalHourlyService.saveOrUpdate((Object)model);
    }

    private OccupancyRegionalHourly model2Domain(OccupancyRegionalHourlyModel model) {
        if (model == null) {
            return null;
        }
        OccupancyRegionalHourly domain = new OccupancyRegionalHourly();
        domain.setId(model.getId());
        domain.setRegionalPlanId(model.getRegionalPlanId());
        domain.setDeviceId(model.getDeviceId());
        domain.setDepId(model.getDepId());
        domain.setEnterpriseId(model.getEnterpriseId());
        domain.setTimePoint(model.getTimePoint());
        domain.setTime(DateUtils.formatLongDate((Date)model.getTimePoint()));
        domain.setTotalStayTime(model.getTotalStayTime());
        domain.setTotalPassengerFLow(model.getTotalPassengerFlow());
        domain.setOccupancySeconds(model.getOccupancySeconds());
        domain.setTableTurnoverCount(model.getTableTurnoverCount());
        domain.setVersionNum(model.getVersionNum());
        return domain;
    }

    private OccupancyRegionalHourly vo2Domain(OccupancyRegionalHourlyDbVo vo) {
        if (vo == null) {
            return null;
        }
        OccupancyRegionalHourly domain = new OccupancyRegionalHourly();
        domain.setRegionalPlanId(vo.getRegionalPlanId());
        domain.setDepId(vo.getDepId());
        domain.setTime(vo.getTime());
        domain.setTotalStayTime(vo.getTotalStayTime());
        domain.setTotalPassengerFLow(vo.getTotalPassengerFlow());
        return domain;
    }

    public List<OccupancyRegionalHourly> select(List<Integer> depIds, Integer timeType, String stime, String etime, Integer isOnBusinessTime, List<Integer> hours) {
        List<OccupancyRegionalHourlyDbVo> models = this.occupancyRegionalHourlyService.getListByDepIds(depIds, timeType, stime, etime, hours);
        List<OccupancyRegionalHourly> result = models.stream().map(this::vo2Domain).collect(Collectors.toList());
        return result;
    }

    public List<OccupancyRegionalHourly> getOccupancyRegionalHourlyListByDepIds(List<Integer> depIds, Date startTime, Date endTime) {
        List<Object> result = new ArrayList<OccupancyRegionalHourly>();
        if (CollectionUtils.isEmpty(depIds) || startTime == null || endTime == null) {
            return result;
        }
        List<OccupancyRegionalHourlyModel> models = this.occupancyRegionalHourlyService.getOccupancyRegionalHourlyListByDepIds(depIds, startTime, endTime);
        result = models.stream().map(this::model2Domain).collect(Collectors.toList());
        return result;
    }

    public List<OccupancyRegionalHourly> getOccupancyRegionalHourlyListByRegionalPlanIds(List<Integer> regionalPlanIds, String stime, String etime) {
        List<Object> result = new ArrayList<OccupancyRegionalHourly>();
        if (CollectionUtils.isEmpty(regionalPlanIds)) {
            return result;
        }
        List<OccupancyRegionalHourlyModel> models = this.occupancyRegionalHourlyService.getOccupancyRegionalHourlyListByRegionalPlanIds(regionalPlanIds, stime, etime);
        result = models.stream().map(this::model2Domain).collect(Collectors.toList());
        return result;
    }

    public List<OccupancyRegionalHourly> getOccupancyTimeByRegionalPlanId(Integer regionalPlanId, String stime, String etime, List<Integer> hours) {
        List<Object> result = new ArrayList<OccupancyRegionalHourly>();
        Boolean flag = Objects.isNull(regionalPlanId) || StringUtils.isBlank((CharSequence)stime) || StringUtils.isBlank((CharSequence)etime) || CollectionUtils.isEmpty(hours);
        if (flag.booleanValue()) {
            return result;
        }
        List<OccupancyRegionalHourlyModel> models = this.occupancyRegionalHourlyService.getOccupancyTimeByRegionalPlanId(regionalPlanId, stime, etime, hours);
        result = models.stream().map(this::model2Domain).collect(Collectors.toList());
        return result;
    }
}

