/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.passenger.repository.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ovopark.passenger.mapper.OccupancyRegionalPlanMapper;
import com.ovopark.passenger.model.OccupancyRegionalPlanModel;
import com.ovopark.passenger.occupancy.entity.OccupancyRegionalPlan;
import com.ovopark.passenger.occupancy.entity.OccupancyRegionalPlanRepository;
import com.ovopark.passenger.util.LocalDateTimeUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

@Service(value="occupancyRegionalPlanRepository")
public class OccupancyRegionalPlanRepositoryImpl
implements OccupancyRegionalPlanRepository {
    @Resource
    private OccupancyRegionalPlanMapper occupancyRegionalPlanMapper;

    public List<OccupancyRegionalPlan> listByIds(List<Integer> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<OccupancyRegionalPlan>();
        }
        List models = this.occupancyRegionalPlanMapper.selectBatchIds(ids);
        return models.stream().map(this::model2Domain).collect(Collectors.toList());
    }

    public List<OccupancyRegionalPlan> listByDepIds(List<Integer> depIds) {
        if (CollectionUtils.isEmpty(depIds)) {
            return Collections.emptyList();
        }
        List models = this.occupancyRegionalPlanMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(OccupancyRegionalPlanModel::getDepId, depIds)).eq(OccupancyRegionalPlanModel::getIsDel, (Object)0));
        return models.stream().map(this::model2Domain).collect(Collectors.toList());
    }

    public OccupancyRegionalPlan getById(Integer id) {
        if (id == null) {
            return null;
        }
        OccupancyRegionalPlanModel model = (OccupancyRegionalPlanModel)this.occupancyRegionalPlanMapper.selectById(id);
        return this.model2Domain(model);
    }

    public Map<Integer, String> getIdAndNameMapByIds(List<Integer> ids) {
        Map<Integer, String> idAndNameMap = new HashMap<Integer, String>();
        if (CollectionUtils.isEmpty(ids)) {
            return idAndNameMap;
        }
        List<OccupancyRegionalPlan> occupancyRegionalPlans = this.listByIds(ids);
        idAndNameMap = occupancyRegionalPlans.stream().collect(Collectors.toMap(OccupancyRegionalPlan::getId, OccupancyRegionalPlan::getRegionalPlanName));
        return idAndNameMap;
    }

    public OccupancyRegionalPlan model2Domain(OccupancyRegionalPlanModel model) {
        if (model == null) {
            return null;
        }
        OccupancyRegionalPlan domain = new OccupancyRegionalPlan();
        domain.setId(model.getId());
        domain.setRegionalPlanName(model.getRegionalPlanName());
        domain.setIsOccupied(model.getIsOccupied());
        domain.setRegulation(model.getRegulation());
        domain.setPoints(model.getPoints());
        domain.setCreateTime((Date)Optional.ofNullable(model.getCreateTime()).map(LocalDateTimeUtils::convertLDTToDate).orElse(null));
        domain.setUpdateTime((Date)Optional.ofNullable(model.getUpdateTime()).map(LocalDateTimeUtils::convertLDTToDate).orElse(null));
        domain.setIsDel(model.getIsDel());
        domain.setDeviceId(model.getDeviceId());
        domain.setDepId(model.getDepId());
        domain.setEnterpriseId(model.getEnterpriseId());
        return domain;
    }
}

