/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.passenger.repository.impl;

import com.ovopark.passenger.push.entity.PushTimePoint;
import com.ovopark.passenger.push.entity.PushTimePointRepository;
import com.ovopark.passenger.util.TimeUtils;
import java.util.Date;
import java.util.Objects;
import org.springframework.stereotype.Service;

@Service
public class PushTimePointRepositoryImpl
implements PushTimePointRepository {
    public boolean update(Integer depId, Date recordTime, Integer taskId, Integer cycMinute, Integer currentLimiting) {
        Date realTime;
        Date realTimePoint;
        Date realPreviousTimePoint;
        if (depId == null || recordTime == null || taskId == null || cycMinute == null) {
            return false;
        }
        Date recordTimePoint = TimeUtils.getEntireMinTimePoint(recordTime, cycMinute);
        if (Objects.equals(recordTimePoint, realPreviousTimePoint = TimeUtils.addMinute(realTimePoint = TimeUtils.getEntireMinTimePoint(realTime = new Date(), cycMinute), -cycMinute.intValue())) && TimeUtils.getMinute(realTime) % cycMinute < 7) {
            this.merge(depId, recordTimePoint, realPreviousTimePoint, taskId, cycMinute, currentLimiting);
            return true;
        }
        this.merge(depId, recordTimePoint, realTimePoint, taskId, cycMinute, currentLimiting);
        return true;
    }

    private void merge(Integer depId, Date recordTime, Date realTime, Integer taskId, Integer cycMinute, Integer currentLimiting) {
        Date time = realTime.after(recordTime) ? realTime : recordTime;
        Date pushTime = TimeUtils.addMinute(time, cycMinute + 8);
        Long delayMs = pushTime.getTime() - time.getTime();
        Integer delaySec = (int)(delayMs / 1000L);
        PushTimePoint pushTimePoint = new PushTimePoint();
        pushTimePoint.setDepId(depId);
        pushTimePoint.setRecordTime(recordTime);
        pushTimePoint.setRealTime(realTime);
        pushTimePoint.setTaskId(taskId);
        pushTimePoint.setDelaySec(delaySec);
        pushTimePoint.setCurrentLimiting(currentLimiting);
    }
}

