/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.passenger.service.impl;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ovopark.passenger.mapper.DepBaseMapConfigMapper;
import com.ovopark.passenger.model.DepBaseMapConfigModel;
import com.ovopark.passenger.pojo.dto.BaseMapConfigDto;
import com.ovopark.passenger.pojo.vo.BaseMapConfigHotVo;
import com.ovopark.passenger.pojo.vo.DepBaseMapConfigVo;
import com.ovopark.passenger.pojo.vo.DepBaseMapMainAreaDeviceVo;
import com.ovopark.passenger.pojo.vo.DepBaseMapProductVo;
import com.ovopark.passenger.service.DepBaseMapConfigService;
import com.ovopark.passenger.service.DepBaseMapHotConfigService;
import com.ovopark.passenger.service.DepBaseMapMainAreaDeviceConfigService;
import com.ovopark.passenger.service.DepBaseMapProductConfigService;
import com.ovopark.passenger.support.User;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DepBaseMapConfigServiceImpl
extends ServiceImpl<DepBaseMapConfigMapper, DepBaseMapConfigModel>
implements DepBaseMapConfigService {
    @Resource
    private DepBaseMapProductConfigService depBaseMapProductConfigService;
    @Resource
    private DepBaseMapHotConfigService depBaseMapHotConfigService;
    @Resource
    private DepBaseMapMainAreaDeviceConfigService depBaseMapMainAreaDeviceConfigService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveOrUpdateBaseMap(User user, List<BaseMapConfigDto> baseMapConfigDtos) {
        if (CollectionUtils.isEmpty(baseMapConfigDtos)) {
            return;
        }
        for (BaseMapConfigDto baseMapConfigDto : baseMapConfigDtos) {
            DepBaseMapConfigModel model;
            if (Objects.isNull(baseMapConfigDto.getBaseMapId())) {
                model = new DepBaseMapConfigModel();
                Date now = new Date();
                model.setName(baseMapConfigDto.getName()).setDepId(baseMapConfigDto.getDepId()).setEnterpriseId(user.getEnterpriseId()).setCreatorId(user.getId()).setCreateTime(now);
                this.save((Object)model);
            } else {
                model = (DepBaseMapConfigModel)((Object)this.getById(baseMapConfigDto.getBaseMapId()));
                if (Objects.nonNull((Object)model)) {
                    model.setName(baseMapConfigDto.getName()).setPic(baseMapConfigDto.getPic());
                    this.updateById((Object)model);
                }
            }
            this.depBaseMapProductConfigService.saveOrUpdateBaseMapProducts(user, baseMapConfigDto.getBaseMapId(), baseMapConfigDto.getProductDtos());
            this.depBaseMapHotConfigService.saveOrUpdateBaseMapHots(user, baseMapConfigDto.getBaseMapId(), baseMapConfigDto.getHotDtos());
            this.depBaseMapMainAreaDeviceConfigService.saveOrUpdateBaseMapMainAreaDevices(user, baseMapConfigDto.getBaseMapId(), baseMapConfigDto.getMainAreaDeviceDtos());
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBaseMap(User user, Integer baseMapId) {
        this.removeById(baseMapId);
        this.depBaseMapProductConfigService.deleteByBaseMapId(baseMapId);
        this.depBaseMapHotConfigService.deleteByBaseMapId(baseMapId);
        this.depBaseMapMainAreaDeviceConfigService.deleteByBaseMapId(baseMapId);
    }

    @Override
    public List<DepBaseMapConfigVo> getDepBaseMaps(Integer depId) {
        List<DepBaseMapConfigVo> result = new ArrayList<DepBaseMapConfigVo>();
        if (Objects.isNull(depId)) {
            return result;
        }
        List models = ((LambdaQueryChainWrapper)this.lambdaQuery().eq(DepBaseMapConfigModel::getDepId, (Object)depId)).list();
        result = models.stream().map(this::convertToVo).collect(Collectors.toList());
        List<DepBaseMapProductVo> depBaseMapProducts = this.depBaseMapProductConfigService.getDepBaseMapRelateProducts(depId);
        Map<Integer, List<DepBaseMapProductVo>> productMap = depBaseMapProducts.stream().collect(Collectors.groupingBy(DepBaseMapProductVo::getBaseMapId));
        List<BaseMapConfigHotVo> depBaseMapHots = this.depBaseMapHotConfigService.getDepBaseMapRelateHots(depId);
        Map<Integer, List<BaseMapConfigHotVo>> hotMap = depBaseMapHots.stream().collect(Collectors.groupingBy(BaseMapConfigHotVo::getBaseMapId));
        List<DepBaseMapMainAreaDeviceVo> depBaseMapMainAreaDevices = this.depBaseMapMainAreaDeviceConfigService.getDepBaseMapMainAreaDevices(depId);
        Map<Integer, List<DepBaseMapMainAreaDeviceVo>> mainAreaDeviceMap = depBaseMapMainAreaDevices.stream().filter(e -> Objects.nonNull(e.getBaseMapId())).collect(Collectors.groupingBy(DepBaseMapMainAreaDeviceVo::getBaseMapId));
        for (DepBaseMapConfigVo depBaseMapConfigVo : result) {
            depBaseMapConfigVo.setDepBaseMapProductVos(productMap.get(depBaseMapConfigVo.getBaseMapId()));
            depBaseMapConfigVo.setBaseMapConfigHotVos(hotMap.get(depBaseMapConfigVo.getBaseMapId()));
            depBaseMapConfigVo.setDepBaseMapMainAreaDeviceVos(mainAreaDeviceMap.get(depBaseMapConfigVo.getBaseMapId()));
        }
        return result;
    }

    private DepBaseMapConfigVo convertToVo(DepBaseMapConfigModel model) {
        DepBaseMapConfigVo vo = new DepBaseMapConfigVo();
        vo.setBaseMapId(model.getId());
        vo.setName(model.getName());
        vo.setPic(model.getPic());
        vo.setDepId(model.getDepId());
        return vo;
    }
}

