/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.passenger.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ovopark.passenger.feign.HotspotConfigFeign;
import com.ovopark.passenger.mapper.DepBaseMapHotConfigMapper;
import com.ovopark.passenger.model.DepBaseMapHotConfigModel;
import com.ovopark.passenger.pojo.dto.BaseMapConfigHotDto;
import com.ovopark.passenger.pojo.vo.BaseMapConfigHotVo;
import com.ovopark.passenger.service.DepBaseMapHotConfigService;
import com.ovopark.passenger.support.User;
import com.ovopark.pojo.HotspotDeviceMapVo;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

@Service
public class DepBaseMapHotConfigServiceImpl
extends ServiceImpl<DepBaseMapHotConfigMapper, DepBaseMapHotConfigModel>
implements DepBaseMapHotConfigService {
    @Resource
    private HotspotConfigFeign hotspotConfigFeign;

    @Override
    public void saveOrUpdateBaseMapHots(User user, Integer baseMapId, List<BaseMapConfigHotDto> hotDtos) {
        if (CollectionUtils.isEmpty(hotDtos)) {
            return;
        }
        this.deleteByBaseMapId(baseMapId);
        Date now = new Date();
        for (BaseMapConfigHotDto hotDto : hotDtos) {
            DepBaseMapHotConfigModel model = new DepBaseMapHotConfigModel();
            model.setBaseMapId(hotDto.getBaseMapId());
            model.setHotDeviceId(hotDto.getHotDeviceId());
            model.setPoints(hotDto.getPoints());
            model.setDepId(hotDto.getDepId());
            model.setEnterpriseId(user.getEnterpriseId());
            model.setCreatorId(user.getId());
            model.setCreateTime(now);
            this.save((Object)model);
        }
    }

    @Override
    public List<BaseMapConfigHotVo> getDepBaseMapHots(Integer depId) {
        List<BaseMapConfigHotVo> result = new ArrayList<BaseMapConfigHotVo>();
        if (Objects.isNull(depId)) {
            return result;
        }
        List<HotspotDeviceMapVo> depHotspotDevices = this.hotspotConfigFeign.getHotspotDeviceByDepId(depId);
        if (CollectionUtils.isEmpty(depHotspotDevices)) {
            return result;
        }
        List<DepBaseMapHotConfigModel> models = this.getModels(depId);
        Map<Integer, DepBaseMapHotConfigModel> hotDeviceIdMap = models.stream().collect(Collectors.toMap(DepBaseMapHotConfigModel::getHotDeviceId, e -> e));
        result = depHotspotDevices.stream().map(e -> {
            DepBaseMapHotConfigModel depBaseMapHotConfigModel = (DepBaseMapHotConfigModel)((Object)((Object)hotDeviceIdMap.get(e.getDeviceId())));
            BaseMapConfigHotVo vo = new BaseMapConfigHotVo();
            vo.setHotDeviceId(e.getDeviceId()).setHotDeviceName(e.getDeviceName()).setHotspotMapId(e.getHotspotMapId()).setHotspotMapName(e.getHotspotMapName()).setDepId(depId).setBind(false);
            if (Objects.nonNull((Object)depBaseMapHotConfigModel)) {
                vo.setBaseMapHotId(depBaseMapHotConfigModel.getId()).setBaseMapId(depBaseMapHotConfigModel.getBaseMapId()).setBind(true).setPoints(depBaseMapHotConfigModel.getPoints());
            }
            return vo;
        }).collect(Collectors.toList());
        return result;
    }

    @Override
    public void deleteByBaseMapId(Integer baseMapId) {
        this.remove((Wrapper)this.lambdaQuery().eq(DepBaseMapHotConfigModel::getBaseMapId, (Object)baseMapId));
    }

    @Override
    public List<BaseMapConfigHotVo> getDepBaseMapRelateHots(Integer depId) {
        List<BaseMapConfigHotVo> result = new ArrayList<BaseMapConfigHotVo>();
        if (Objects.isNull(depId)) {
            return result;
        }
        List<DepBaseMapHotConfigModel> models = this.getModels(depId);
        if (CollectionUtils.isEmpty(models)) {
            return result;
        }
        result = models.stream().map(e -> {
            BaseMapConfigHotVo vo = new BaseMapConfigHotVo();
            vo.setBaseMapHotId(e.getId()).setBaseMapId(e.getBaseMapId()).setHotDeviceId(e.getHotDeviceId()).setPoints(e.getPoints()).setDepId(e.getDepId()).setBind(true);
            return vo;
        }).collect(Collectors.toList());
        return result;
    }

    private List<DepBaseMapHotConfigModel> getModels(Integer depId) {
        ArrayList<DepBaseMapHotConfigModel> result = new ArrayList<DepBaseMapHotConfigModel>();
        if (Objects.isNull(depId)) {
            return result;
        }
        return ((LambdaQueryChainWrapper)this.lambdaQuery().eq(DepBaseMapHotConfigModel::getDepId, (Object)depId)).list();
    }
}

