/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.passenger.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ovopark.passenger.core.entity.DeviceFlowTagRepository;
import com.ovopark.passenger.exception.BizException;
import com.ovopark.passenger.exception.ResultCodeEnum;
import com.ovopark.passenger.mapper.DepBaseMapMainAreaDeviceConfigMapper;
import com.ovopark.passenger.model.DepBaseMapMainAreaDeviceConfigModel;
import com.ovopark.passenger.model.ShopFlowTagModel;
import com.ovopark.passenger.pojo.dto.BaseMapConfigMainAreaDeviceDto;
import com.ovopark.passenger.pojo.vo.DepBaseMapMainAreaDeviceVo;
import com.ovopark.passenger.service.DepBaseMapMainAreaDeviceConfigService;
import com.ovopark.passenger.service.ShopFlowTagService;
import com.ovopark.passenger.support.User;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

@Service
public class DepBaseMapMainAreaDeviceConfigServiceImpl
extends ServiceImpl<DepBaseMapMainAreaDeviceConfigMapper, DepBaseMapMainAreaDeviceConfigModel>
implements DepBaseMapMainAreaDeviceConfigService {
    @Resource
    private ShopFlowTagService shopFlowTagService;
    @Resource
    private DeviceFlowTagRepository deviceFlowTagRepository;

    @Override
    public void saveOrUpdateBaseMapMainAreaDevices(User user, Integer baseMapId, List<BaseMapConfigMainAreaDeviceDto> deviceDtos) {
        if (CollectionUtils.isEmpty(deviceDtos)) {
            return;
        }
        this.deleteByBaseMapId(baseMapId);
        Date now = new Date();
        for (BaseMapConfigMainAreaDeviceDto deviceDto : deviceDtos) {
            DepBaseMapMainAreaDeviceConfigModel model = new DepBaseMapMainAreaDeviceConfigModel();
            model.setBaseMapId(deviceDto.getBaseMapId()).setMainAreaDeviceId(deviceDto.getMainAreaDeviceId()).setPoints(deviceDto.getPoints()).setDepId(deviceDto.getDepId()).setEnterpriseId(user.getEnterpriseId()).setCreatorId(user.getId()).setCreateTime(now);
            this.save((Object)model);
        }
    }

    @Override
    public List<DepBaseMapMainAreaDeviceVo> getDepBaseMapMainAreaDevices(Integer depId) {
        List<DepBaseMapMainAreaDeviceVo> result = new ArrayList<DepBaseMapMainAreaDeviceVo>();
        if (Objects.isNull(depId)) {
            return result;
        }
        Integer tagId = Optional.ofNullable(this.shopFlowTagService.getPrimaryTag(depId)).map(ShopFlowTagModel::getId).orElse(null);
        if (tagId == null) {
            throw new BizException(ResultCodeEnum.EMPTY_PRIMARY_PORT.getCode(), ResultCodeEnum.EMPTY_PRIMARY_PORT.getMessage());
        }
        List deviceFlowTags = this.deviceFlowTagRepository.listDeviceFlowTagByTagId(tagId);
        if (CollectionUtils.isEmpty((Collection)deviceFlowTags)) {
            return result;
        }
        List<DepBaseMapMainAreaDeviceConfigModel> models = this.getModels(depId);
        Map<Integer, DepBaseMapMainAreaDeviceConfigModel> mainAreaDeviceIdMap = models.stream().collect(Collectors.toMap(DepBaseMapMainAreaDeviceConfigModel::getMainAreaDeviceId, e -> e));
        result = deviceFlowTags.stream().map(e -> {
            DepBaseMapMainAreaDeviceConfigModel model = (DepBaseMapMainAreaDeviceConfigModel)((Object)((Object)mainAreaDeviceIdMap.get(e.getDeviceId())));
            DepBaseMapMainAreaDeviceVo vo = new DepBaseMapMainAreaDeviceVo();
            vo.setMainAreaDeviceId(e.getDeviceId()).setDeviceName(e.getDeviceName()).setDepId(e.getDepId()).setBind(false);
            if (Objects.nonNull((Object)model)) {
                vo.setBaseMapMainId(model.getId());
                vo.setBaseMapId(model.getBaseMapId());
                vo.setPoints(model.getPoints());
                vo.setBind(true);
            }
            return vo;
        }).collect(Collectors.toList());
        return result;
    }

    @Override
    public void deleteByBaseMapId(Integer baseMapId) {
        this.remove((Wrapper)this.lambdaQuery().eq(DepBaseMapMainAreaDeviceConfigModel::getBaseMapId, (Object)baseMapId));
    }

    @Override
    public List<DepBaseMapMainAreaDeviceVo> getDepBaseMapRelateMainAreaDevices(Integer depId) {
        List<DepBaseMapMainAreaDeviceVo> result = new ArrayList<DepBaseMapMainAreaDeviceVo>();
        if (Objects.isNull(depId)) {
            return result;
        }
        List<DepBaseMapMainAreaDeviceConfigModel> models = this.getModels(depId);
        if (CollectionUtils.isEmpty(models)) {
            return result;
        }
        result = models.stream().map(e -> {
            DepBaseMapMainAreaDeviceVo vo = new DepBaseMapMainAreaDeviceVo();
            vo.setBaseMapMainId(e.getId()).setBaseMapId(e.getBaseMapId()).setMainAreaDeviceId(e.getMainAreaDeviceId()).setPoints(e.getPoints()).setDepId(e.getDepId()).setBind(true);
            return vo;
        }).collect(Collectors.toList());
        return result;
    }

    private List<DepBaseMapMainAreaDeviceConfigModel> getModels(Integer depId) {
        ArrayList<DepBaseMapMainAreaDeviceConfigModel> models = new ArrayList<DepBaseMapMainAreaDeviceConfigModel>();
        if (Objects.isNull(depId)) {
            return models;
        }
        return ((LambdaQueryChainWrapper)this.lambdaQuery().eq(DepBaseMapMainAreaDeviceConfigModel::getDepId, (Object)depId)).list();
    }
}

