/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.passenger.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ovopark.passenger.mapper.DepBaseMapProductConfigMapper;
import com.ovopark.passenger.model.DepBaseMapProductConfigModel;
import com.ovopark.passenger.model.DeviceProductAreaModel;
import com.ovopark.passenger.pojo.dto.BaseMapConfigProductDto;
import com.ovopark.passenger.pojo.vo.DepBaseMapProductVo;
import com.ovopark.passenger.service.DepBaseMapProductConfigService;
import com.ovopark.passenger.service.DeviceProductAreaService;
import com.ovopark.passenger.service.ProductService;
import com.ovopark.passenger.support.User;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

@Service
public class DepBaseMapProductConfigServiceImpl
extends ServiceImpl<DepBaseMapProductConfigMapper, DepBaseMapProductConfigModel>
implements DepBaseMapProductConfigService {
    @Resource
    private DeviceProductAreaService deviceProductAreaService;
    @Resource
    private ProductService productService;

    @Override
    public void saveOrUpdateBaseMapProducts(User user, Integer baseMapId, List<BaseMapConfigProductDto> productDtos) {
        if (CollectionUtils.isEmpty(productDtos)) {
            return;
        }
        this.deleteByBaseMapId(baseMapId);
        Date now = new Date();
        for (BaseMapConfigProductDto productDto : productDtos) {
            DepBaseMapProductConfigModel model = new DepBaseMapProductConfigModel();
            model.setBaseMapId(baseMapId).setProductAreaId(productDto.getProductAreaId()).setPoints(productDto.getPoints()).setDepId(productDto.getDepId()).setEnterpriseId(user.getEnterpriseId()).setCreatorId(user.getId()).setCreateTime(now);
            this.save((Object)model);
        }
    }

    @Override
    public List<DepBaseMapProductVo> getDepBaseMapProducts(Integer depId) {
        List<DepBaseMapProductVo> result = new ArrayList<DepBaseMapProductVo>();
        if (Objects.isNull(depId)) {
            return result;
        }
        List<DeviceProductAreaModel> deviceProductAreaModels = this.deviceProductAreaService.listValidDeviceProductAreaByDeptId(depId);
        if (CollectionUtils.isEmpty(deviceProductAreaModels)) {
            return result;
        }
        List<Integer> productIds = deviceProductAreaModels.stream().map(DeviceProductAreaModel::getProductId).distinct().collect(Collectors.toList());
        Map<Integer, String> productIdNameMap = this.productService.getProductIdAndProductNameMap(productIds);
        List<DepBaseMapProductConfigModel> products = this.getProducts(depId);
        Map<Integer, DepBaseMapProductConfigModel> productAreaIdMap = products.stream().collect(Collectors.toMap(DepBaseMapProductConfigModel::getProductAreaId, e -> e));
        result = deviceProductAreaModels.stream().map(e -> {
            DepBaseMapProductConfigModel depBaseMapProductConfigModel = (DepBaseMapProductConfigModel)((Object)((Object)productAreaIdMap.get(e.getId())));
            DepBaseMapProductVo vo = new DepBaseMapProductVo();
            vo.setProductAreaId(e.getId()).setProductId(e.getProductId()).setProductName((String)productIdNameMap.get(e.getProductId())).setDepId(e.getDepId()).setBind(false);
            if (Objects.nonNull((Object)depBaseMapProductConfigModel)) {
                vo.setBaseMapProductId(depBaseMapProductConfigModel.getId()).setBaseMapId(depBaseMapProductConfigModel.getBaseMapId()).setBind(true).setPoints(depBaseMapProductConfigModel.getPoints());
            }
            return vo;
        }).collect(Collectors.toList());
        return result;
    }

    @Override
    public void deleteByBaseMapId(Integer baseMapId) {
        this.remove((Wrapper)new LambdaQueryWrapper().eq(DepBaseMapProductConfigModel::getBaseMapId, (Object)baseMapId));
    }

    @Override
    public List<DepBaseMapProductVo> getDepBaseMapRelateProducts(Integer depId) {
        List<DepBaseMapProductVo> result = new ArrayList<DepBaseMapProductVo>();
        if (Objects.isNull(depId)) {
            return result;
        }
        List<DepBaseMapProductConfigModel> products = this.getProducts(depId);
        if (CollectionUtils.isEmpty(products)) {
            return result;
        }
        result = products.stream().map(e -> {
            DepBaseMapProductVo vo = new DepBaseMapProductVo();
            vo.setBaseMapProductId(e.getId()).setBaseMapId(e.getBaseMapId()).setProductAreaId(e.getProductAreaId()).setPoints(e.getPoints()).setDepId(e.getDepId()).setBind(true);
            return vo;
        }).collect(Collectors.toList());
        return result;
    }

    private List<DepBaseMapProductConfigModel> getProducts(Integer depId) {
        ArrayList<DepBaseMapProductConfigModel> models = new ArrayList<DepBaseMapProductConfigModel>();
        if (Objects.isNull(depId)) {
            return models;
        }
        return ((LambdaQueryChainWrapper)this.lambdaQuery().eq(DepBaseMapProductConfigModel::getDepId, (Object)depId)).list();
    }
}

