/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.passenger.service.impl;

import cn.hutool.core.lang.Pair;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ovopark.passenger.mapper.DeviceProductAreaMapper;
import com.ovopark.passenger.model.DeviceProductAreaModel;
import com.ovopark.passenger.pojo.bo.DeviceProductAreaBo;
import com.ovopark.passenger.service.DeviceProductAreaService;
import com.ovopark.passenger.service.ProductService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class DeviceProductAreaServiceImpl
extends ServiceImpl<DeviceProductAreaMapper, DeviceProductAreaModel>
implements DeviceProductAreaService {
    @Resource
    private DeviceProductAreaMapper deviceProductAreaMapper;
    @Resource
    private ProductService productService;

    @Override
    public List<DeviceProductAreaModel> listDeviceProductArea(List<Integer> depIds, List<Integer> productIds) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(DeviceProductAreaModel::getDepId, depIds)).in(org.apache.commons.collections.CollectionUtils.isNotEmpty(productIds), DeviceProductAreaModel::getProductId, productIds)).gt(DeviceProductAreaModel::getTagId, (Object)0)).eq(DeviceProductAreaModel::getIsDelete, (Object)false)).list();
    }

    @Override
    public List<DeviceProductAreaBo> getDeviceProductAreaByDeviceIdAndProductId(Integer deviceId, Integer productId) {
        if (deviceId == null || productId == null) {
            return null;
        }
        return this.deviceProductAreaMapper.getDeviceProductAreaByDeviceIdAndProductId(deviceId, productId);
    }

    @Override
    public List<DeviceProductAreaBo> listDeviceProductAreaByDeviceIdsAndProductIds(List<Integer> deviceIds, List<Integer> productIds) {
        if (CollectionUtils.isEmpty(deviceIds) || CollectionUtils.isEmpty(productIds)) {
            return new ArrayList<DeviceProductAreaBo>();
        }
        return this.deviceProductAreaMapper.listDeviceProductAreaByDeviceIdsAndProductIds(deviceIds, productIds);
    }

    @Override
    public List<DeviceProductAreaModel> listProductAreaByDeviceIds(List<Integer> deviceIds) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(deviceIds)) {
            return new ArrayList<DeviceProductAreaModel>();
        }
        return this.deviceProductAreaMapper.listDeviceProductAreaByDeviceIds(deviceIds);
    }

    @Override
    public List<DeviceProductAreaBo> listProductAreaBoByDeviceIds(List<Integer> deviceIds) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(deviceIds)) {
            return new ArrayList<DeviceProductAreaBo>();
        }
        return this.listProductAreaByDeviceIds(deviceIds).stream().map(this::convertModelToBo).collect(Collectors.toList());
    }

    private DeviceProductAreaBo convertModelToBo(DeviceProductAreaModel model) {
        if (model == null) {
            return null;
        }
        DeviceProductAreaBo bo = new DeviceProductAreaBo();
        bo.setId(model.getId());
        bo.setDeviceId(model.getDeviceId());
        bo.setDeviceName(model.getDeviceName());
        bo.setMac(model.getMac());
        bo.setDepId(model.getDepId());
        bo.setProductId(model.getProductId());
        bo.setProductName(model.getProductName());
        bo.setTagId(model.getTagId());
        bo.setProductType(model.getProductType());
        bo.setInfoPubMac(model.getInfoPubMac());
        return bo;
    }

    @Override
    public List<DeviceProductAreaModel> listValidDeviceProductAreaByDeptId(Integer deptId) {
        return this.listValidDeviceProductAreaByDeptId(deptId, null);
    }

    @Override
    public List<DeviceProductAreaModel> listValidDeviceProductAreaByDeptId(Integer deptId, Boolean enableTouch) {
        if (deptId == null) {
            return new ArrayList<DeviceProductAreaModel>();
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(DeviceProductAreaModel::getDepId, (Object)deptId)).eq(DeviceProductAreaModel::getProductType, (Object)0)).eq(Objects.nonNull(enableTouch), DeviceProductAreaModel::getEnableTouch, (Object)enableTouch)).eq(DeviceProductAreaModel::getIsDelete, (Object)false)).list();
    }

    @Override
    public List<DeviceProductAreaModel> listValidDeviceProductAreaByDeviceIdsAndProductNames(List<Integer> deviceIds, List<String> productNames) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(deviceIds)) {
            return new ArrayList<DeviceProductAreaModel>();
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(DeviceProductAreaModel::getDeviceId, deviceIds)).in(org.apache.commons.collections.CollectionUtils.isNotEmpty(productNames), DeviceProductAreaModel::getProductName, productNames)).eq(DeviceProductAreaModel::getIsDelete, (Object)false)).list();
    }

    @Override
    public List<DeviceProductAreaModel> listValidDeviceProductAreaByMacAndProductIds(String mac, List<Integer> productIds) {
        if (StringUtils.isBlank((CharSequence)mac) || org.apache.commons.collections.CollectionUtils.isEmpty(productIds)) {
            return new ArrayList<DeviceProductAreaModel>();
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(DeviceProductAreaModel::getMac, (Object)mac)).in(DeviceProductAreaModel::getProductId, productIds)).eq(DeviceProductAreaModel::getIsDelete, (Object)false)).list();
    }

    @Override
    public List<DeviceProductAreaModel> listValidDeviceProductAreaByDeptAndTag(List<Pair<Integer, Integer>> uniqueDepTagPairs) {
        if (uniqueDepTagPairs == null || uniqueDepTagPairs.isEmpty()) {
            return new ArrayList<DeviceProductAreaModel>();
        }
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)queryWrapper.eq(DeviceProductAreaModel::getProductType, (Object)0)).eq(DeviceProductAreaModel::getIsDelete, (Object)false);
        queryWrapper.and(wrapper -> {
            for (Pair pair : uniqueDepTagPairs) {
                wrapper.or(w -> {
                    LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)w.eq(DeviceProductAreaModel::getDepId, pair.getKey())).eq(DeviceProductAreaModel::getTagId, pair.getValue());
                });
            }
        });
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public Set<Integer> listAllTagIdsByDeptIds(List<Integer> depIds) {
        if (depIds == null || depIds.isEmpty()) {
            return Collections.emptySet();
        }
        List deviceList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(DeviceProductAreaModel::getDepId, depIds)).eq(DeviceProductAreaModel::getProductType, (Object)0)).eq(DeviceProductAreaModel::getIsDelete, (Object)false)).list();
        return deviceList.stream().map(DeviceProductAreaModel::getTagId).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    @Override
    public Map<Integer, List<Integer>> listTagIdMapByDeptIds(List<Integer> depIds) {
        if (depIds == null || depIds.isEmpty()) {
            return Collections.emptyMap();
        }
        List deviceList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(DeviceProductAreaModel::getDepId, depIds)).eq(DeviceProductAreaModel::getProductType, (Object)0)).eq(DeviceProductAreaModel::getIsDelete, (Object)false)).list();
        return deviceList.stream().filter(item -> item.getDepId() != null && item.getTagId() != null).collect(Collectors.groupingBy(DeviceProductAreaModel::getDepId, Collectors.mapping(DeviceProductAreaModel::getTagId, Collectors.toList())));
    }

    @Override
    public Map<Integer, String> getProductAreaIdAndProductNameMap(List<Integer> productAreaIds) {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        List<DeviceProductAreaModel> validDeviceProductAreas = this.getValidDeviceProductAreaByIds(productAreaIds);
        if (org.apache.commons.collections.CollectionUtils.isEmpty(validDeviceProductAreas)) {
            return result;
        }
        List<Integer> productIds = validDeviceProductAreas.stream().map(DeviceProductAreaModel::getProductId).distinct().collect(Collectors.toList());
        Map<Integer, String> productIdAndProductNameMap = this.productService.getProductIdAndProductNameMap(productIds);
        validDeviceProductAreas.forEach(e -> {
            Integer productAreaId = e.getId();
            String productName = (String)productIdAndProductNameMap.get(e.getProductId());
            result.put(productAreaId, productName);
        });
        return result;
    }

    @Override
    public List<DeviceProductAreaModel> getValidDeviceProductAreaByIds(List<Integer> ids) {
        ArrayList<DeviceProductAreaModel> result = new ArrayList<DeviceProductAreaModel>();
        if (org.apache.commons.collections.CollectionUtils.isEmpty(ids)) {
            return result;
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(DeviceProductAreaModel::getId, ids)).eq(DeviceProductAreaModel::getProductType, (Object)0)).eq(DeviceProductAreaModel::getIsDelete, (Object)false)).list();
    }

    @Override
    public Map<Integer, Integer> getProductAreaIdAndShelfIdMap(List<Integer> productAreaIds, Boolean enableTouch) {
        HashMap<Integer, Integer> result = new HashMap<Integer, Integer>();
        if (org.apache.commons.collections.CollectionUtils.isEmpty(productAreaIds)) {
            return result;
        }
        Boolean enableTouchTag = Optional.ofNullable(enableTouch).orElse(false);
        List deviceProductAreas = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(DeviceProductAreaModel::getId, productAreaIds)).eq(DeviceProductAreaModel::getIsDelete, (Object)false)).eq(DeviceProductAreaModel::getEnableTouch, (Object)enableTouchTag)).list();
        return deviceProductAreas.stream().collect(Collectors.toMap(DeviceProductAreaModel::getId, m -> m.getShelfId() == null ? -1 : m.getShelfId(), (oldValue, newValue) -> oldValue));
    }
}

