/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.passenger.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ovopark.passenger.common.QueryParam;
import com.ovopark.passenger.common.util.NumberUtils;
import com.ovopark.passenger.dwell.valueobject.DwellTimeData;
import com.ovopark.passenger.mapper.DwellTimeHourlyMapper;
import com.ovopark.passenger.model.DwellTimeHourlyModel;
import com.ovopark.passenger.service.DwellTimeHourlyService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class DwellTimeHourlyServiceImpl
extends ServiceImpl<DwellTimeHourlyMapper, DwellTimeHourlyModel>
implements DwellTimeHourlyService {
    @Resource
    private DwellTimeHourlyMapper dwellTimeHourlyMapper;

    @Override
    public List<DwellTimeData> listDwellTimeData(QueryParam queryParam) {
        ArrayList<DwellTimeData> res = new ArrayList<DwellTimeData>();
        switch (queryParam.getGroupBy()) {
            case 0: {
                DwellTimeData sumDwellTimeData = this.dwellTimeHourlyMapper.getSumDwellTimeData(queryParam);
                res.addAll(Optional.ofNullable(sumDwellTimeData).map(Collections::singletonList).orElse(Collections.emptyList()));
                break;
            }
            case 1: {
                res.addAll(this.dwellTimeHourlyMapper.listDwellTimeDataGroupByTimeType(queryParam));
                break;
            }
            case 2: {
                res.addAll(this.dwellTimeHourlyMapper.listDwellTimeDataGroupByDepId(queryParam));
                break;
            }
            case 3: {
                res.addAll(this.dwellTimeHourlyMapper.listDwellTimeDataGroupByDepIdAndTimeType(queryParam));
                break;
            }
            default: {
                res.addAll(Collections.emptyList());
            }
        }
        res.forEach(dwellTimeData -> dwellTimeData.setAvgDwellTime(Integer.valueOf(NumberUtils.getDivide((Number)dwellTimeData.getSumDwellTime(), (Number)dwellTimeData.getInCount(), (int)0).intValue())));
        return res;
    }
}

