/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.passenger.service.impl;

import com.ovopark.api.DeviceStatusApi;
import com.ovopark.api.EnterpriseDeviceApi;
import com.ovopark.passenger.service.FeignService;
import com.ovopark.pojo.BaseResult;
import com.ovopark.pojo.DeviceStatusPojo;
import com.ovopark.pojo.dto.DeviceStatusDto;
import com.ovopark.util.DeviceUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FeignServiceImpl
implements FeignService {
    @Autowired
    private DeviceStatusApi deviceStatusApi;
    @Autowired
    private EnterpriseDeviceApi enterpriseDeviceApi;

    @Override
    public DeviceStatusPojo getFlowDeviceByMac(String mac) {
        List<DeviceStatusPojo> devices = this.listValidDeviceByMac(mac);
        if (CollectionUtils.isNotEmpty(devices)) {
            for (DeviceStatusPojo device : devices) {
                if (!DeviceUtils.isPassengerFlowDevice((Integer)device.getdType()).booleanValue()) continue;
                return device;
            }
        }
        return null;
    }

    @Override
    public List<DeviceStatusDto> listCrossMirrorDeviceByMac(String mac) {
        com.ovopark.pojo.dto.BaseResult res = this.deviceStatusApi.listCrossMirrorDeviceByMac(mac);
        if (res != null && !res.getIsError().booleanValue() && res.getData() != null) {
            return (List)res.getData();
        }
        return new ArrayList<DeviceStatusDto>();
    }

    @Override
    public List<DeviceStatusPojo> listValidDeviceByMac(String mac) {
        BaseResult deviceRes = this.enterpriseDeviceApi.getValidDeviceByMac(mac);
        if (!deviceRes.getIsError().booleanValue() && deviceRes.getData() != null) {
            return (List)deviceRes.getData();
        }
        return new ArrayList<DeviceStatusPojo>();
    }
}

