/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.passenger.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ovopark.passenger.mapper.FilaPushTimePointMapper;
import com.ovopark.passenger.model.FilaPushTimePointModel;
import com.ovopark.passenger.service.FilaPushTimePointService;
import com.ovopark.passenger.util.TimeUtils;
import java.util.Date;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class FilaPushTimePointServiceImpl
extends ServiceImpl<FilaPushTimePointMapper, FilaPushTimePointModel>
implements FilaPushTimePointService {
    private static final Logger log = LoggerFactory.getLogger(FilaPushTimePointServiceImpl.class);

    @Override
    public boolean update(Integer depId, Date recordTime) {
        Date realTime;
        Date realTimePoint;
        Date realPreviousTimePoint;
        if (depId == null || recordTime == null) {
            return false;
        }
        Date recordTimePoint = TimeUtils.getEntire20minTimePoint(recordTime);
        if (Objects.equals(recordTimePoint, realPreviousTimePoint = TimeUtils.addMinute(realTimePoint = TimeUtils.getEntire20minTimePoint(realTime = new Date()), -20)) && TimeUtils.getMinute(realTime) % 20 < 6) {
            this.merge(depId, recordTimePoint, realPreviousTimePoint);
            return true;
        }
        this.merge(depId, recordTimePoint, realTimePoint);
        return true;
    }

    private void merge(Integer depId, Date recordTime, Date realTime) {
        FilaPushTimePointModel po = this.getUniquePo(depId, recordTime, realTime);
        if (po == null) {
            po = new FilaPushTimePointModel().setDepId(depId).setRecordTime(recordTime).setRealTime(realTime);
            try {
                this.save((Object)po);
            }
            catch (Exception e) {
                log.warn("\u4fdd\u5b58\u5931\u8d25", (Throwable)e);
            }
        }
    }

    private FilaPushTimePointModel getUniquePo(Integer depId, Date recordTime, Date realTime) {
        QueryWrapper wrapper = new QueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.lambda().eq(FilaPushTimePointModel::getDepId, (Object)depId)).eq(FilaPushTimePointModel::getRecordTime, (Object)recordTime)).eq(FilaPushTimePointModel::getRealTime, (Object)realTime);
        return (FilaPushTimePointModel)((Object)this.getOne((Wrapper)wrapper));
    }
}

