/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.passenger.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ovopark.passenger.mapper.PassengerFixDataMapper;
import com.ovopark.passenger.model.PassengerFixDataModel;
import com.ovopark.passenger.service.PassengerFixDataService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="passengerFixDataService")
public class PassengerFixDataServiceImpl
extends ServiceImpl<PassengerFixDataMapper, PassengerFixDataModel>
implements PassengerFixDataService {
    @Resource
    private PassengerFixDataMapper passengerFixDataMapper;

    @Override
    public List<PassengerFixDataModel> listModifyData(Integer depId, String mac, Integer productId, String stime, String etime) {
        if (depId == null || mac == null || stime == null || etime == null) {
            return new ArrayList<PassengerFixDataModel>();
        }
        return this.passengerFixDataMapper.listModifyData(depId, mac, productId, stime, etime);
    }

    @Override
    public List<PassengerFixDataModel> listByOperateId(Integer operateId) {
        if (operateId == null) {
            return new ArrayList<PassengerFixDataModel>();
        }
        return ((LambdaQueryChainWrapper)this.lambdaQuery().eq(PassengerFixDataModel::getOperateId, (Object)operateId)).list();
    }

    @Override
    public void insert(Integer operateId, Date time, Integer flow, Integer initialFlow, Integer type, Boolean isRevert) {
        PassengerFixDataModel record = new PassengerFixDataModel();
        record.setOperateId(operateId);
        record.setTime(time);
        record.setFlow(flow);
        record.setInitialFlow(initialFlow);
        record.setType(type);
        record.setIsRevert(isRevert);
        this.save((Object)record);
    }

    @Override
    public void updateByIds(List<Integer> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        this.passengerFixDataMapper.updateByIds(ids);
    }

    @Override
    public List<Integer> listIdByMacAndDateAndType(String mac, Date time, Integer type) {
        if (mac == null || time == null || type == null) {
            return new ArrayList<Integer>();
        }
        return this.passengerFixDataMapper.listIdByMacAndDateAndType(mac, time, type);
    }

    @Override
    public boolean removeByOperateId(Integer operateId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(PassengerFixDataModel::getOperateId, (Object)operateId);
        return this.passengerFixDataMapper.delete((Wrapper)queryWrapper) >= 0;
    }
}

