/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.passenger.service.impl;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ovopark.passenger.mapper.ProductAreaTouchAreaConfigMapper;
import com.ovopark.passenger.model.ProductAreaTouchAreaConfigModel;
import com.ovopark.passenger.pojo.dto.ProductAreaTouchAreaConfigDto;
import com.ovopark.passenger.service.ProductAreaTouchAreaConfigService;
import com.ovopark.pojo.UserPojo;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ProductAreaTouchAreaConfigServiceImpl
extends ServiceImpl<ProductAreaTouchAreaConfigMapper, ProductAreaTouchAreaConfigModel>
implements ProductAreaTouchAreaConfigService {
    private static final Logger log = LoggerFactory.getLogger(ProductAreaTouchAreaConfigServiceImpl.class);
    @Resource
    private ProductAreaTouchAreaConfigService productAreaTouchAreaConfigService;

    @Override
    public void saveProductAreaTouchAreas(UserPojo user, ProductAreaTouchAreaConfigDto dto) {
        Integer depId = dto.getDepId();
        Integer productAreaId = dto.getProductAreaId();
        List<Integer> touchAreaIds = dto.getTouchAreaIds();
        if (Objects.isNull(depId) || Objects.isNull(productAreaId) || CollectionUtils.isEmpty(touchAreaIds)) {
            return;
        }
        LocalDateTime now = LocalDateTime.now();
        List<ProductAreaTouchAreaConfigModel> productAreaTouchAreaConfigs = this.productAreaTouchAreaConfigService.getProductAreaTouchAreaConfigs(touchAreaIds);
        for (Integer touchAreaId : touchAreaIds) {
            boolean bond = productAreaTouchAreaConfigs.stream().anyMatch(p -> Objects.equals(p.getTouchId(), touchAreaId));
            if (bond) {
                log.info("saveProductAreaTouchAreas touchAreaId->{} already bond", (Object)touchAreaId);
                continue;
            }
            ProductAreaTouchAreaConfigModel model = new ProductAreaTouchAreaConfigModel();
            model.setDepId(depId);
            model.setProductAreaId(productAreaId);
            model.setTouchId(touchAreaId);
            model.setIsDelete(false);
            model.setCreatorId(user.getUserId());
            model.setCreateTime(now);
            this.save((Object)model);
        }
    }

    @Override
    public void unbindProductAreaTouchAreas(UserPojo user, List<Integer> productAreaTouchAreaConfigIds) {
        if (CollectionUtils.isEmpty(productAreaTouchAreaConfigIds)) {
            return;
        }
        List models = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(ProductAreaTouchAreaConfigModel::getId, productAreaTouchAreaConfigIds)).eq(ProductAreaTouchAreaConfigModel::getIsDelete, (Object)false)).list();
        if (CollectionUtils.isEmpty((Collection)models)) {
            return;
        }
        LocalDateTime now = LocalDateTime.now();
        for (ProductAreaTouchAreaConfigModel model : models) {
            model.setIsDelete(true);
            model.setDeleteUserId(user.getUserId());
            model.setDeleteTime(now);
            this.updateById((Object)model);
        }
    }

    @Override
    public List<ProductAreaTouchAreaConfigModel> getProductAreaTouchAreasByDepId(Integer depId) {
        List<ProductAreaTouchAreaConfigModel> result = new ArrayList<ProductAreaTouchAreaConfigModel>();
        if (Objects.isNull(depId)) {
            return result;
        }
        result = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(ProductAreaTouchAreaConfigModel::getDepId, (Object)depId)).eq(ProductAreaTouchAreaConfigModel::getIsDelete, (Object)false)).list();
        return result;
    }

    @Override
    public List<ProductAreaTouchAreaConfigModel> getProductAreaTouchAreaConfigs(List<Integer> touchIds) {
        List<ProductAreaTouchAreaConfigModel> result = new ArrayList<ProductAreaTouchAreaConfigModel>();
        if (CollectionUtils.isEmpty(touchIds)) {
            return result;
        }
        result = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(ProductAreaTouchAreaConfigModel::getTouchId, touchIds)).eq(ProductAreaTouchAreaConfigModel::getIsDelete, (Object)false)).list();
        return result;
    }
}

