/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.passenger.service.impl;

import com.alicp.jetcache.Cache;
import com.alicp.jetcache.anno.CreateCache;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ovopark.passenger.mapper.PushTaskMapper;
import com.ovopark.passenger.model.PushTaskModel;
import com.ovopark.passenger.pojo.bo.PushTaskBo;
import com.ovopark.passenger.service.PushTaskService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class PushTaskServiceImpl
extends ServiceImpl<PushTaskMapper, PushTaskModel>
implements PushTaskService {
    private static final Logger log = LoggerFactory.getLogger(PushTaskServiceImpl.class);
    @Resource
    private PushTaskMapper pushTaskMapper;
    @CreateCache(name="PushTaskServiceImpl.listPushTaskBoByEnterpriseId", expire=300)
    private Cache<Integer, List<PushTaskBo>> pushTaskCache;

    @Override
    public List<PushTaskBo> listPushTaskBoByPushTarget(Integer enterpriseId, Integer depId) {
        if (enterpriseId == null || depId == null) {
            return Collections.emptyList();
        }
        List<PushTaskBo> pushTaskBos = this.listPushTaskBoByEnterpriseId(enterpriseId);
        if (CollectionUtils.isEmpty(pushTaskBos)) {
            return Collections.emptyList();
        }
        ArrayList<PushTaskBo> res = new ArrayList<PushTaskBo>();
        Map<Integer, List<PushTaskBo>> collect = pushTaskBos.stream().collect(Collectors.groupingBy(PushTaskBo::getId));
        collect.forEach((id, pushTaskBoList) -> {
            PushTaskBo pushTaskBo = (PushTaskBo)pushTaskBoList.get(0);
            if (pushTaskBo.getDepId() == null) {
                res.add(pushTaskBo);
            } else if (pushTaskBoList.stream().anyMatch(t -> depId.equals(t.getDepId()))) {
                pushTaskBo.setDepId(depId);
                res.add(pushTaskBo);
            }
        });
        return res;
    }

    public List<PushTaskBo> listPushTaskBoByEnterpriseId(Integer enterpriseId) {
        if (enterpriseId == null) {
            return Collections.emptyList();
        }
        List<PushTaskBo> pushTaskBos = (List<PushTaskBo>)this.pushTaskCache.get((Object)enterpriseId);
        if (pushTaskBos != null) {
            return pushTaskBos;
        }
        log.info("listPushTaskBoByEnterpriseId,enterpriseId={}", (Object)enterpriseId);
        pushTaskBos = this.pushTaskMapper.listPushTaskBoByEnterpriseId(enterpriseId);
        this.pushTaskCache.put((Object)enterpriseId, pushTaskBos);
        return pushTaskBos;
    }
}

