/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.passenger.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.fasterxml.jackson.core.type.TypeReference;
import com.ovopark.device.cloud.common.model.mo.DevicesMo;
import com.ovopark.device.common.util.JsonUtils;
import com.ovopark.device.common.util.LogUtil;
import com.ovopark.passenger.common.util.DateUtils;
import com.ovopark.passenger.common.util.NumberUtils;
import com.ovopark.passenger.exception.ResultCodeEnum;
import com.ovopark.passenger.feign.DepartmentFeign;
import com.ovopark.passenger.feign.DeviceFeign;
import com.ovopark.passenger.mapper.DeviceOccupancyRegional5minMapper;
import com.ovopark.passenger.mapper.OccupancyRegionalPlanMapper;
import com.ovopark.passenger.mapper.OccupancyVirtualSpaceMapper;
import com.ovopark.passenger.mapper.OccupancyVirtualSpacePointsMapper;
import com.ovopark.passenger.model.DeviceOccupancyRegional5minModel;
import com.ovopark.passenger.model.OccupancyRegionalPlanModel;
import com.ovopark.passenger.model.OccupancyVirtualSpaceModel;
import com.ovopark.passenger.model.OccupancyVirtualSpacePointsModel;
import com.ovopark.passenger.occupancy.DeviceOccupancyRegional5minRepository;
import com.ovopark.passenger.occupancy.entity.OccupancyRegional5min;
import com.ovopark.passenger.occupancy.entity.OccupancyRegionalHourlyRepository;
import com.ovopark.passenger.pojo.Authenticator;
import com.ovopark.passenger.pojo.enums.InterfaceAllowsTypeEnum;
import com.ovopark.passenger.pojo.mo.RegionalPlanInParamMo;
import com.ovopark.passenger.pojo.vo.AddRegionalPlanInParamVo;
import com.ovopark.passenger.pojo.vo.OccupancyVirtualSpaceInParam;
import com.ovopark.passenger.pojo.vo.OccupancyVirtualSpaceListOutParamVo;
import com.ovopark.passenger.pojo.vo.OccupancyVirtualSpacePointsInParam;
import com.ovopark.passenger.pojo.vo.RealTimeOccupancyRegionalDataVo;
import com.ovopark.passenger.pojo.vo.RegionalPlanListHistoryVo;
import com.ovopark.passenger.pojo.vo.RegionalPlanListOutParamVo;
import com.ovopark.passenger.pojo.vo.VirtualSpacePointsVo;
import com.ovopark.passenger.service.RealTimeOccupancyService;
import com.ovopark.pojo.BaseResult;
import com.ovopark.pojo.dto.DepartmentDto;
import com.ovopark.pojo.dto.EnterpriseDepartmentsDto;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class RealTimeOccupancyServiceImpl
implements RealTimeOccupancyService {
    private static final Logger log = LoggerFactory.getLogger(RealTimeOccupancyServiceImpl.class);
    @Autowired
    private OccupancyRegionalPlanMapper regionalPlanMapper;
    @Autowired
    private OccupancyVirtualSpaceMapper occupancyVirtualSpaceMapper;
    @Autowired
    private OccupancyVirtualSpacePointsMapper occupancyVirtualSpacePointsMapper;
    @Autowired
    private DeviceOccupancyRegional5minMapper deviceOccupancyRegional5minMapper;
    @Resource
    private DeviceFeign deviceFeign;
    @Resource
    private DepartmentFeign departmentFeign;
    @Resource
    private OccupancyRegionalHourlyRepository occupancyRegionalHourlyRepository;
    @Resource
    private DeviceOccupancyRegional5minRepository occupancyRegional5minRepository;

    @Override
    public BaseResult<RegionalPlanInParamMo> regionalPlan(RegionalPlanInParamMo regionalPlanInParamMo) {
        List regionalPlanList = regionalPlanInParamMo.getRegionalPlanList();
        if (CollectionUtils.isEmpty((Collection)regionalPlanList)) {
            this.regionalPlanMapper.update(null, (Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().set(OccupancyRegionalPlanModel::getIsDel, (Object)1)).eq(OccupancyRegionalPlanModel::getDeviceId, (Object)regionalPlanInParamMo.getDeviceId()));
            return BaseResult.success((Object)new RegionalPlanInParamMo());
        }
        List occupancyRegionalPlans = this.regionalPlanMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().select(new SFunction[]{OccupancyRegionalPlanModel::getId}).eq(OccupancyRegionalPlanModel::getDeviceId, (Object)regionalPlanInParamMo.getDeviceId())).eq(OccupancyRegionalPlanModel::getIsDel, (Object)0));
        List integerList = occupancyRegionalPlans.stream().map(OccupancyRegionalPlanModel::getId).collect(Collectors.toList());
        List collect = regionalPlanList.stream().filter(a -> a.getRegionalPlanId() != null).collect(Collectors.toList());
        List integerList1 = collect.stream().map(RegionalPlanInParamMo.RegionalPlan::getRegionalPlanId).collect(Collectors.toList());
        integerList.stream().filter(a -> !integerList1.contains(a)).forEach(a -> this.regionalPlanMapper.update(null, (Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().set(OccupancyRegionalPlanModel::getIsDel, (Object)1)).eq(OccupancyRegionalPlanModel::getId, a)));
        for (RegionalPlanInParamMo.RegionalPlan regionalPlan : collect) {
            this.regionalPlanMapper.update(null, (Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().set(OccupancyRegionalPlanModel::getRegionalPlanName, (Object)regionalPlan.getRegionalPlanName())).set(OccupancyRegionalPlanModel::getPoints, (Object)JSONObject.toJSONString((Object)regionalPlan.getList()))).set(OccupancyRegionalPlanModel::getUpdateTime, (Object)LocalDateTime.now())).eq(OccupancyRegionalPlanModel::getId, (Object)regionalPlan.getRegionalPlanId()));
        }
        List collect1 = regionalPlanList.stream().filter(a -> a.getRegionalPlanId() == null).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(collect1)) {
            DepartmentDto department = this.departmentFeign.getById(regionalPlanInParamMo.getDepId());
            for (RegionalPlanInParamMo.RegionalPlan regionalPlan : collect1) {
                if (regionalPlan.getRegionalPlanId() != null) continue;
                AddRegionalPlanInParamVo addRegionalPlanInParamVo = new AddRegionalPlanInParamVo();
                addRegionalPlanInParamVo.setRegionalPlanName(regionalPlan.getRegionalPlanName());
                addRegionalPlanInParamVo.setPoints(regionalPlan.getList());
                addRegionalPlanInParamVo.setDeviceId(regionalPlanInParamMo.getDeviceId());
                addRegionalPlanInParamVo.setDepId(regionalPlanInParamMo.getDepId());
                addRegionalPlanInParamVo.setEnterpriseId(Optional.ofNullable(department).map(DepartmentDto::getGroupId).orElse(null));
                this.addressRegionalPlan(addRegionalPlanInParamVo);
            }
        }
        List occupancyRegionalPlansList = this.regionalPlanMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(OccupancyRegionalPlanModel::getDeviceId, (Object)regionalPlanInParamMo.getDeviceId())).eq(OccupancyRegionalPlanModel::getIsDel, (Object)0));
        RegionalPlanInParamMo regionalPlanInParamMos = new RegionalPlanInParamMo();
        ArrayList<RegionalPlanInParamMo.RegionalPlan> responseList = new ArrayList<RegionalPlanInParamMo.RegionalPlan>();
        for (OccupancyRegionalPlanModel occupancyRegionalPlan : occupancyRegionalPlansList) {
            RegionalPlanInParamMo.RegionalPlan regionalPlan;
            regionalPlan = new RegionalPlanInParamMo.RegionalPlan();
            regionalPlan.setRegionalPlanId(occupancyRegionalPlan.getId());
            regionalPlan.setRegionalPlanName(occupancyRegionalPlan.getRegionalPlanName());
            List algoSupportResDmsDeviceBaseRes = null;
            try {
                algoSupportResDmsDeviceBaseRes = (List)JsonUtils.objectMapper.readValue(occupancyRegionalPlan.getPoints(), (TypeReference)new TypeReference<List<List<Double>>>(){});
            }
            catch (IOException e) {
                log.error(LogUtil.getStackTraceInfo((Exception)e));
                return null;
            }
            regionalPlan.setList(algoSupportResDmsDeviceBaseRes);
            responseList.add(regionalPlan);
            regionalPlanInParamMos.setDepId(occupancyRegionalPlan.getDepId());
            regionalPlanInParamMos.setDeviceId(occupancyRegionalPlan.getDeviceId());
        }
        regionalPlanInParamMos.setRegionalPlanList(responseList);
        return BaseResult.success((Object)regionalPlanInParamMos);
    }

    @Override
    public BaseResult getRegionalPlanList(Integer depId, Integer deviceId, String searchName) {
        LambdaQueryWrapper eq = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().select(new SFunction[]{OccupancyRegionalPlanModel::getId, OccupancyRegionalPlanModel::getRegionalPlanName, OccupancyRegionalPlanModel::getPoints, OccupancyRegionalPlanModel::getRegulation, OccupancyRegionalPlanModel::getDeviceId}).eq(OccupancyRegionalPlanModel::getDepId, (Object)depId)).eq(OccupancyRegionalPlanModel::getIsDel, (Object)0);
        if (searchName != null) {
            eq.like(OccupancyRegionalPlanModel::getRegionalPlanName, (Object)searchName);
        }
        List regionalPlans = this.regionalPlanMapper.selectList((Wrapper)eq);
        List<Integer> integerList = regionalPlans.stream().map(OccupancyRegionalPlanModel::getDeviceId).collect(Collectors.toList());
        Map deviceMap = null;
        if (!CollectionUtils.isEmpty(integerList)) {
            List<DevicesMo> devices = this.deviceFeign.listDeviceMoByIds(integerList);
            deviceMap = devices.stream().collect(Collectors.toMap(DevicesMo::getId, Function.identity()));
        }
        ArrayList<RegionalPlanListOutParamVo> regionalPlanListOutParamVos = new ArrayList<RegionalPlanListOutParamVo>();
        Map<Integer, List<OccupancyRegionalPlanModel>> collected = regionalPlans.stream().collect(Collectors.groupingBy(OccupancyRegionalPlanModel::getDeviceId));
        for (Integer integer : collected.keySet()) {
            RegionalPlanListOutParamVo regionalPlanListOutParamVo = new RegionalPlanListOutParamVo();
            List<OccupancyRegionalPlanModel> occupancyRegionalPlans = collected.get(integer);
            if (!CollectionUtils.isEmpty(occupancyRegionalPlans)) {
                if (deviceMap != null && deviceMap.get(integer) != null) {
                    regionalPlanListOutParamVo.setDeviceName(((DevicesMo)deviceMap.get(integer)).getName());
                }
                List<RegionalPlanListOutParamVo.RegionalPlanListOutParamInnerVo> list = RealTimeOccupancyServiceImpl.getRegionalPlanListOutParamInnerVos(occupancyRegionalPlans);
                regionalPlanListOutParamVo.setDepId(depId);
                regionalPlanListOutParamVo.setList(list);
                regionalPlanListOutParamVo.setDeviceId(integer);
            }
            regionalPlanListOutParamVos.add(regionalPlanListOutParamVo);
        }
        return BaseResult.success(regionalPlanListOutParamVos);
    }

    private static List<RegionalPlanListOutParamVo.RegionalPlanListOutParamInnerVo> getRegionalPlanListOutParamInnerVos(List<OccupancyRegionalPlanModel> occupancyRegionalPlans) {
        ArrayList<RegionalPlanListOutParamVo.RegionalPlanListOutParamInnerVo> list = new ArrayList<RegionalPlanListOutParamVo.RegionalPlanListOutParamInnerVo>();
        for (OccupancyRegionalPlanModel regionalPlan : occupancyRegionalPlans) {
            RegionalPlanListOutParamVo.RegionalPlanListOutParamInnerVo innerVo = new RegionalPlanListOutParamVo.RegionalPlanListOutParamInnerVo();
            innerVo.setRegionalPlanId(regionalPlan.getId());
            innerVo.setRegionalPlanName(regionalPlan.getRegionalPlanName());
            innerVo.setRegulation(regionalPlan.getRegulation());
            innerVo.setPoints(regionalPlan.getPoints());
            list.add(innerVo);
        }
        return list;
    }

    private void updateRegionalPlan(AddRegionalPlanInParamVo addRegionalPlanInParamVo) {
        OccupancyRegionalPlanModel regionalPlan = (OccupancyRegionalPlanModel)this.regionalPlanMapper.selectById(addRegionalPlanInParamVo.getRegionalPlanId());
        if (regionalPlan != null) {
            this.regionalPlanMapper.update(null, (Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().set(OccupancyRegionalPlanModel::getRegionalPlanName, (Object)addRegionalPlanInParamVo.getRegionalPlanName())).set(OccupancyRegionalPlanModel::getPoints, addRegionalPlanInParamVo.getPoints())).set(OccupancyRegionalPlanModel::getUpdateTime, (Object)LocalDateTime.now())).eq(OccupancyRegionalPlanModel::getId, (Object)addRegionalPlanInParamVo.getRegionalPlanId()));
        }
    }

    private Integer addressRegionalPlan(AddRegionalPlanInParamVo addRegionalPlanInParamVo) {
        List regionalPlans = this.regionalPlanMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().select(new SFunction[]{OccupancyRegionalPlanModel::getId}).eq(OccupancyRegionalPlanModel::getDepId, (Object)addRegionalPlanInParamVo.getDepId())).eq(OccupancyRegionalPlanModel::getRegionalPlanName, (Object)addRegionalPlanInParamVo.getRegionalPlanName())).eq(OccupancyRegionalPlanModel::getIsDel, (Object)0));
        if (!CollectionUtils.isEmpty((Collection)regionalPlans)) {
            log.info("addressRegionalPlan \u533a\u57df\u89c4\u5212\u540d\u79f0\u91cd\u590d", (Object)JSONObject.toJSONString((Object)addRegionalPlanInParamVo));
            return null;
        }
        OccupancyRegionalPlanModel regionalPlan = new OccupancyRegionalPlanModel();
        regionalPlan.setRegulation(0);
        regionalPlan.setEnterpriseId(addRegionalPlanInParamVo.getEnterpriseId());
        regionalPlan.setDeviceId(addRegionalPlanInParamVo.getDeviceId());
        regionalPlan.setDepId(addRegionalPlanInParamVo.getDepId());
        regionalPlan.setRegionalPlanName(addRegionalPlanInParamVo.getRegionalPlanName());
        regionalPlan.setPoints(addRegionalPlanInParamVo.getPoints() + "");
        LocalDateTime now = LocalDateTime.now();
        regionalPlan.setCreateTime(now);
        regionalPlan.setUpdateTime(now);
        regionalPlan.setIsDel(0);
        this.regionalPlanMapper.insert(regionalPlan);
        return regionalPlan.getId();
    }

    @Override
    public BaseResult occupancyVirtualSpace(OccupancyVirtualSpaceInParam occupancyVirtualSpaceInParam) {
        if (occupancyVirtualSpaceInParam.getInterfaceAllowsType().intValue() == InterfaceAllowsTypeEnum.ADD.getIndex()) {
            return this.addOccupancyVirtualSpace(occupancyVirtualSpaceInParam);
        }
        if (occupancyVirtualSpaceInParam.getInterfaceAllowsType().intValue() == InterfaceAllowsTypeEnum.DELETE.getIndex()) {
            this.occupancyVirtualSpaceMapper.update(null, (Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().set(OccupancyVirtualSpaceModel::getIsDel, (Object)1)).eq(OccupancyVirtualSpaceModel::getId, (Object)occupancyVirtualSpaceInParam.getVirtualSpaceId()));
        }
        if (occupancyVirtualSpaceInParam.getInterfaceAllowsType().intValue() == InterfaceAllowsTypeEnum.UPDATE.getIndex()) {
            List occupancyVirtualSpaces = this.occupancyVirtualSpaceMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().select(new SFunction[]{OccupancyVirtualSpaceModel::getId}).eq(OccupancyVirtualSpaceModel::getDepId, (Object)occupancyVirtualSpaceInParam.getDepId())).eq(OccupancyVirtualSpaceModel::getVirtualSpaceName, (Object)occupancyVirtualSpaceInParam.getVirtualSpaceName())).eq(OccupancyVirtualSpaceModel::getIsDel, (Object)0)).ne(OccupancyVirtualSpaceModel::getId, (Object)occupancyVirtualSpaceInParam.getVirtualSpaceId()));
            if (!CollectionUtils.isEmpty((Collection)occupancyVirtualSpaces)) {
                log.info("\u4fee\u6539\u865a\u62df\u7a7a\u95f4\u540d\u79f0\u91cd\u590d{}", (Object)JSONObject.toJSONString((Object)occupancyVirtualSpaceInParam));
                return BaseResult.error((Object)"", (String)ResultCodeEnum.VIRTUALSPACENAME_EXIST.getCode(), (String)ResultCodeEnum.VIRTUALSPACENAME_EXIST.getMessage());
            }
            this.occupancyVirtualSpaceMapper.update(null, (Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().set(OccupancyVirtualSpaceModel::getVirtualSpaceName, (Object)occupancyVirtualSpaceInParam.getVirtualSpaceName())).set(OccupancyVirtualSpaceModel::getVirtualSpacePic, (Object)occupancyVirtualSpaceInParam.getVirtualSpacePic())).eq(OccupancyVirtualSpaceModel::getId, (Object)occupancyVirtualSpaceInParam.getVirtualSpaceId()));
        }
        return BaseResult.success((Object)true);
    }

    private BaseResult addOccupancyVirtualSpace(OccupancyVirtualSpaceInParam occupancyVirtualSpaceInParam) {
        List occupancyVirtualSpaces = this.occupancyVirtualSpaceMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().select(new SFunction[]{OccupancyVirtualSpaceModel::getId}).eq(OccupancyVirtualSpaceModel::getDepId, (Object)occupancyVirtualSpaceInParam.getDepId())).eq(OccupancyVirtualSpaceModel::getVirtualSpaceName, (Object)occupancyVirtualSpaceInParam.getVirtualSpaceName())).eq(OccupancyVirtualSpaceModel::getIsDel, (Object)0));
        if (!CollectionUtils.isEmpty((Collection)occupancyVirtualSpaces)) {
            log.info("addOccupancyVirtualSpace \u865a\u62df\u7a7a\u95f4\u540d\u79f0\u91cd\u590d{}", (Object)JSONObject.toJSONString((Object)occupancyVirtualSpaceInParam));
            return BaseResult.error((Object)"", (String)ResultCodeEnum.VIRTUALSPACENAME_EXIST.getCode(), (String)ResultCodeEnum.VIRTUALSPACENAME_EXIST.getMessage());
        }
        OccupancyVirtualSpaceModel occupancyVirtualSpace = new OccupancyVirtualSpaceModel();
        occupancyVirtualSpace.setVirtualSpaceName(occupancyVirtualSpaceInParam.getVirtualSpaceName());
        occupancyVirtualSpace.setVirtualSpacePic(occupancyVirtualSpaceInParam.getVirtualSpacePic());
        LocalDateTime now = LocalDateTime.now();
        occupancyVirtualSpace.setCreateTime(now);
        occupancyVirtualSpace.setUpdateTime(now);
        occupancyVirtualSpace.setIsDel(0);
        occupancyVirtualSpace.setDepId(occupancyVirtualSpaceInParam.getDepId());
        occupancyVirtualSpace.setDeviceId(occupancyVirtualSpaceInParam.getDeviceId());
        this.occupancyVirtualSpaceMapper.insert(occupancyVirtualSpace);
        return BaseResult.success((Object)true);
    }

    @Override
    public BaseResult getOccupancyVirtualSpaceList(Integer depId, Integer deviceId, String searchName) {
        LambdaQueryWrapper eq = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().select(new SFunction[]{OccupancyVirtualSpaceModel::getId, OccupancyVirtualSpaceModel::getVirtualSpaceName, OccupancyVirtualSpaceModel::getVirtualSpacePic}).eq(OccupancyVirtualSpaceModel::getDepId, (Object)depId)).eq(OccupancyVirtualSpaceModel::getIsDel, (Object)0);
        if (searchName != null) {
            eq.like(OccupancyVirtualSpaceModel::getVirtualSpaceName, (Object)searchName);
        }
        eq.orderByDesc(OccupancyVirtualSpaceModel::getCreateTime);
        List occupancyVirtualSpaces = this.occupancyVirtualSpaceMapper.selectList((Wrapper)eq);
        List<OccupancyVirtualSpaceListOutParamVo> occupancyVirtualSpaceMethod = this.getOccupancyVirtualSpaceMethod(occupancyVirtualSpaces);
        return BaseResult.success(occupancyVirtualSpaceMethod);
    }

    @Override
    public BaseResult getOccupancyVirtualSpaceByVirtualSpaceId(Integer virtualSpaceId) {
        LambdaQueryWrapper eq = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().select(new SFunction[]{OccupancyVirtualSpaceModel::getId, OccupancyVirtualSpaceModel::getVirtualSpaceName, OccupancyVirtualSpaceModel::getVirtualSpacePic}).eq(OccupancyVirtualSpaceModel::getId, (Object)virtualSpaceId)).eq(OccupancyVirtualSpaceModel::getIsDel, (Object)0);
        List occupancyVirtualSpaces = this.occupancyVirtualSpaceMapper.selectList((Wrapper)eq);
        List<OccupancyVirtualSpaceListOutParamVo> occupancyVirtualSpaceMethod = this.getOccupancyVirtualSpaceMethod(occupancyVirtualSpaces);
        return BaseResult.success(occupancyVirtualSpaceMethod);
    }

    private List<OccupancyVirtualSpaceListOutParamVo> getOccupancyVirtualSpaceMethod(List<OccupancyVirtualSpaceModel> occupancyVirtualSpaces) {
        List integerList = occupancyVirtualSpaces.stream().map(OccupancyVirtualSpaceModel::getId).collect(Collectors.toList());
        Map<Integer, List<OccupancyVirtualSpacePointsModel>> integerListMap = null;
        Map integerOccupancyRegionalPlanMap = null;
        Map<Integer, List<OccupancyRegional5min>> regionalPlanIdMap = null;
        if (!CollectionUtils.isEmpty(integerList)) {
            List occupancyVirtualSpacePoints = this.occupancyVirtualSpacePointsMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().select(new SFunction[]{OccupancyVirtualSpacePointsModel::getVirtualSpaceId, OccupancyVirtualSpacePointsModel::getVirtualSpacePoints, OccupancyVirtualSpacePointsModel::getCaptionPoints, OccupancyVirtualSpacePointsModel::getRegionalPlanId}).in(OccupancyVirtualSpacePointsModel::getVirtualSpaceId, integerList)).eq(OccupancyVirtualSpacePointsModel::getIsDel, (Object)0));
            integerListMap = occupancyVirtualSpacePoints.stream().collect(Collectors.groupingBy(OccupancyVirtualSpacePointsModel::getVirtualSpaceId));
            List regionalPlanIds = occupancyVirtualSpacePoints.stream().filter(a -> a.getRegionalPlanId() != null).map(OccupancyVirtualSpacePointsModel::getRegionalPlanId).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(regionalPlanIds)) {
                List occupancyRegionalPlans = this.regionalPlanMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().select(new SFunction[]{OccupancyRegionalPlanModel::getId, OccupancyRegionalPlanModel::getRegionalPlanName, OccupancyRegionalPlanModel::getRegulation}).in(OccupancyRegionalPlanModel::getId, regionalPlanIds)).eq(OccupancyRegionalPlanModel::getIsDel, (Object)0));
                integerOccupancyRegionalPlanMap = occupancyRegionalPlans.stream().collect(Collectors.toMap(OccupancyRegionalPlanModel::getId, Function.identity()));
                Date now = Authenticator.getInstance().now();
                String stime = (String)DateUtils.getDayStartTimeAndEndTimeByNow((Date)now).getLeft();
                String etime = (String)DateUtils.getDayStartTimeAndEndTimeByNow((Date)now).getRight();
                List regional5minList = this.occupancyRegional5minRepository.getOccupancyRegional5minListByRegionalPlanIds(regionalPlanIds, stime, etime);
                regionalPlanIdMap = regional5minList.stream().collect(Collectors.groupingBy(OccupancyRegional5min::getRegionalPlanId));
            }
        }
        ArrayList<OccupancyVirtualSpaceListOutParamVo> occupancyVirtualSpaceListOutParamVos = new ArrayList<OccupancyVirtualSpaceListOutParamVo>();
        for (OccupancyVirtualSpaceModel occupancyVirtualSpace : occupancyVirtualSpaces) {
            OccupancyVirtualSpaceListOutParamVo occupancyVirtualSpaceListOutParamVo = new OccupancyVirtualSpaceListOutParamVo();
            occupancyVirtualSpaceListOutParamVo.setVirtualSpaceName(occupancyVirtualSpace.getVirtualSpaceName());
            occupancyVirtualSpaceListOutParamVo.setVirtualSpacePic(occupancyVirtualSpace.getVirtualSpacePic());
            occupancyVirtualSpaceListOutParamVo.setVirtualSpaceId(occupancyVirtualSpace.getId());
            if (integerListMap != null && integerListMap.get(occupancyVirtualSpace.getId()) != null) {
                ArrayList<OccupancyVirtualSpaceListOutParamVo.OccupancyVirtualSpacePoints> oList = new ArrayList<OccupancyVirtualSpaceListOutParamVo.OccupancyVirtualSpacePoints>();
                ArrayList<String> captionPoints = new ArrayList<String>();
                List<OccupancyVirtualSpacePointsModel> occupancyVirtualSpacePointsList = integerListMap.get(occupancyVirtualSpace.getId());
                if (!CollectionUtils.isEmpty(occupancyVirtualSpacePointsList)) {
                    for (OccupancyVirtualSpacePointsModel o : occupancyVirtualSpacePointsList) {
                        if (o.getRegionalPlanId() != null) {
                            OccupancyVirtualSpaceListOutParamVo.OccupancyVirtualSpacePoints occupancyVirtualSpacePoints = new OccupancyVirtualSpaceListOutParamVo().new OccupancyVirtualSpaceListOutParamVo.OccupancyVirtualSpacePoints();
                            occupancyVirtualSpacePoints.setRegionalPlanId(o.getRegionalPlanId());
                            occupancyVirtualSpacePoints.setVirtualSpacePoints(o.getVirtualSpacePoints());
                            if (integerOccupancyRegionalPlanMap != null && integerOccupancyRegionalPlanMap.get(o.getRegionalPlanId()) != null) {
                                occupancyVirtualSpacePoints.setRegionalPlanName(((OccupancyRegionalPlanModel)integerOccupancyRegionalPlanMap.get(o.getRegionalPlanId())).getRegionalPlanName());
                                occupancyVirtualSpacePoints.setRegulation(((OccupancyRegionalPlanModel)integerOccupancyRegionalPlanMap.get(o.getRegionalPlanId())).getRegulation());
                                List occupancyRegional5minList = Optional.ofNullable(regionalPlanIdMap.get(o.getRegionalPlanId())).orElse(new ArrayList());
                                occupancyVirtualSpacePoints.setTableTurnoverCount(occupancyRegional5minList.stream().mapToInt(e -> Optional.ofNullable(e.getTableTurnoverCount()).orElse(0)).sum());
                            }
                            oList.add(occupancyVirtualSpacePoints);
                        }
                        if (o.getRegionalPlanId() != null || !Objects.nonNull(o.getCaptionPoints())) continue;
                        captionPoints.add(o.getCaptionPoints());
                    }
                }
                occupancyVirtualSpaceListOutParamVo.setOccupancyVirtualSpacePoints(oList);
                occupancyVirtualSpaceListOutParamVo.setCaptionPoints(captionPoints);
            }
            occupancyVirtualSpaceListOutParamVos.add(occupancyVirtualSpaceListOutParamVo);
        }
        return occupancyVirtualSpaceListOutParamVos;
    }

    @Override
    public BaseResult addOccupancyVirtualSpacePoints(OccupancyVirtualSpacePointsInParam occupancyVirtualSpacePointsInParam) {
        LocalDateTime now;
        OccupancyVirtualSpacePointsModel occupancyVirtualSpacePoints;
        OccupancyVirtualSpaceModel occupancyVirtualSpace = (OccupancyVirtualSpaceModel)this.occupancyVirtualSpaceMapper.selectById(occupancyVirtualSpacePointsInParam.getVirtualSpaceId());
        if (occupancyVirtualSpace == null || occupancyVirtualSpace != null && occupancyVirtualSpace.getIsDel() == 1) {
            log.info("addOccupancyVirtualSpacePoints \u865a\u62df\u7a7a\u95f4\u4e0d\u5b58\u5728", (Object)JSONObject.toJSONString((Object)occupancyVirtualSpacePointsInParam));
            return BaseResult.error((Object)"", (String)ResultCodeEnum.VIRTUALSPACE_NONEXIST.getCode(), (String)ResultCodeEnum.VIRTUALSPACE_NONEXIST.getMessage());
        }
        this.occupancyVirtualSpacePointsMapper.update(null, (Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().set(OccupancyVirtualSpacePointsModel::getIsDelPre, (Object)1)).eq(OccupancyVirtualSpacePointsModel::getVirtualSpaceId, (Object)occupancyVirtualSpacePointsInParam.getVirtualSpaceId()));
        for (VirtualSpacePointsVo virtualSpacePoint : occupancyVirtualSpacePointsInParam.getVirtualSpacePoints()) {
            occupancyVirtualSpacePoints = new OccupancyVirtualSpacePointsModel();
            now = LocalDateTime.now();
            occupancyVirtualSpacePoints.setCreateTime(now);
            occupancyVirtualSpacePoints.setUpdateTime(now);
            occupancyVirtualSpacePoints.setIsDel(0);
            occupancyVirtualSpacePoints.setVirtualSpaceId(occupancyVirtualSpacePointsInParam.getVirtualSpaceId());
            occupancyVirtualSpacePoints.setRegionalPlanId(virtualSpacePoint.getRegionalPlanId());
            occupancyVirtualSpacePoints.setVirtualSpacePoints(JSONObject.toJSONString((Object)virtualSpacePoint.getVirtualSpacePoints()));
            this.occupancyVirtualSpacePointsMapper.insert(occupancyVirtualSpacePoints);
        }
        for (Object captionPoint : occupancyVirtualSpacePointsInParam.getCaptionPoints()) {
            occupancyVirtualSpacePoints = new OccupancyVirtualSpacePointsModel();
            now = LocalDateTime.now();
            occupancyVirtualSpacePoints.setCreateTime(now);
            occupancyVirtualSpacePoints.setUpdateTime(now);
            occupancyVirtualSpacePoints.setIsDel(0);
            occupancyVirtualSpacePoints.setVirtualSpaceId(occupancyVirtualSpacePointsInParam.getVirtualSpaceId());
            occupancyVirtualSpacePoints.setCaptionPoints(JSONObject.toJSONString((Object)captionPoint));
            this.occupancyVirtualSpacePointsMapper.insert(occupancyVirtualSpacePoints);
        }
        this.occupancyVirtualSpacePointsMapper.update(null, (Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().set(OccupancyVirtualSpacePointsModel::getIsDel, (Object)1)).eq(OccupancyVirtualSpacePointsModel::getVirtualSpaceId, (Object)occupancyVirtualSpacePointsInParam.getVirtualSpaceId())).eq(OccupancyVirtualSpacePointsModel::getIsDelPre, (Object)1));
        return BaseResult.success((Object)true);
    }

    @Override
    public void delRegionalPlanByDeviceId(Integer deviceId) {
        this.regionalPlanMapper.update(null, (Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().set(OccupancyRegionalPlanModel::getIsDel, (Object)1)).eq(OccupancyRegionalPlanModel::getDeviceId, (Object)deviceId));
    }

    @Override
    public List<RegionalPlanListHistoryVo> getRegionalPlanListHistory(List<Integer> regionalPlanIds, String date) {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        LocalDateTime startTime = LocalDateTime.parse(date + " 00:00:00", dateTimeFormatter);
        LocalDateTime endTime = LocalDateTime.parse(date + " 23:59:59", dateTimeFormatter);
        LambdaUpdateWrapper wrapper = (LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().in(DeviceOccupancyRegional5minModel::getRegionalPlanId, regionalPlanIds)).between(DeviceOccupancyRegional5minModel::getTimePoint, (Object)startTime, (Object)endTime);
        Map historyTimeMap = this.deviceOccupancyRegional5minMapper.selectList((Wrapper)wrapper).stream().collect(Collectors.groupingBy(DeviceOccupancyRegional5minModel::getTimePoint, Collectors.mapping(v -> {
            RegionalPlanListOutParamVo.RegionalPlanListOutParamInnerVo vo = new RegionalPlanListOutParamVo.RegionalPlanListOutParamInnerVo();
            vo.setRegionalPlanId(v.getRegionalPlanId());
            vo.setRegulation(v.getOccupants());
            vo.setTableTurnoverCount(v.getTableTurnoverCount());
            return vo;
        }, Collectors.toList())));
        historyTimeMap.forEach((timePoint, list) -> {
            Set existingRegionalPlanIds = list.stream().map(RegionalPlanListOutParamVo.RegionalPlanListOutParamInnerVo::getRegionalPlanId).collect(Collectors.toSet());
            regionalPlanIds.forEach(id -> {
                if (!existingRegionalPlanIds.contains(id)) {
                    RegionalPlanListOutParamVo.RegionalPlanListOutParamInnerVo vo = new RegionalPlanListOutParamVo.RegionalPlanListOutParamInnerVo();
                    vo.setRegionalPlanId((Integer)id);
                    vo.setRegulation(0);
                    vo.setTableTurnoverCount(0);
                    list.add(vo);
                }
            });
        });
        return historyTimeMap.entrySet().stream().map(entry -> {
            LocalDateTime timePoint = (LocalDateTime)entry.getKey();
            List list = (List)entry.getValue();
            RegionalPlanListHistoryVo vo = new RegionalPlanListHistoryVo();
            vo.setTimePoint(timePoint.format(dateTimeFormatter));
            vo.setRegionalPlanList(list);
            return vo;
        }).sorted(Comparator.comparing(RegionalPlanListHistoryVo::getTimePoint)).collect(Collectors.toList());
    }

    @Override
    public RealTimeOccupancyRegionalDataVo getRealTimeOccupancyRegionalDataVo(Integer depId) {
        RealTimeOccupancyRegionalDataVo result = new RealTimeOccupancyRegionalDataVo();
        List<OccupancyRegionalPlanModel> occupancyRegionalPlans = this.getOccupancyRegionalPlans(depId);
        if (CollectionUtils.isEmpty(occupancyRegionalPlans)) {
            return result;
        }
        Integer allRegionalPeopleNum = occupancyRegionalPlans.stream().mapToInt(OccupancyRegionalPlanModel::getRegulation).sum();
        int hasPeopleRegionalNum = (int)occupancyRegionalPlans.stream().filter(a -> a.getRegulation() > 0).count();
        int allRegionalNum = occupancyRegionalPlans.size();
        BigDecimal occupancyRate = NumberUtils.calculateRate((Number)hasPeopleRegionalNum, (Number)allRegionalNum, (Integer)2, (boolean)false);
        result.setAllRegionalPeopleNum(allRegionalPeopleNum).setHasPeopleRegionalNum(hasPeopleRegionalNum).setAllRegionalNum(allRegionalNum).setOccupancyRate(occupancyRate);
        return result;
    }

    private List<OccupancyRegionalPlanModel> getOccupancyRegionalPlans(Integer depId) {
        List<OccupancyRegionalPlanModel> result = new ArrayList<OccupancyRegionalPlanModel>();
        if (Objects.isNull(depId)) {
            return result;
        }
        result = this.regionalPlanMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(OccupancyRegionalPlanModel::getDepId, (Object)depId)).eq(OccupancyRegionalPlanModel::getIsDel, (Object)0));
        return result;
    }

    @Override
    public List<EnterpriseDepartmentsDto> getDepIdsBy5min(Date startTime, Date endTime) {
        if (Objects.isNull(startTime) || Objects.isNull(endTime)) {
            return new ArrayList<EnterpriseDepartmentsDto>();
        }
        QueryWrapper wrapper = new QueryWrapper();
        ((LambdaQueryWrapper)wrapper.lambda().between(DeviceOccupancyRegional5minModel::getTimePoint, (Object)startTime, (Object)endTime)).groupBy(DeviceOccupancyRegional5minModel::getDepId);
        wrapper.select(new String[]{"dep_id, max(enterprise_id) enterprise_id"});
        Map<Integer, List<DeviceOccupancyRegional5minModel>> enerpriseIdMap = this.deviceOccupancyRegional5minMapper.selectList((Wrapper)wrapper).stream().collect(Collectors.groupingBy(DeviceOccupancyRegional5minModel::getEnterpriseId));
        return enerpriseIdMap.entrySet().stream().map(entry -> {
            Integer enterpriseId = (Integer)entry.getKey();
            List depIds = ((List)entry.getValue()).stream().map(DeviceOccupancyRegional5minModel::getDepId).collect(Collectors.toList());
            EnterpriseDepartmentsDto dto = new EnterpriseDepartmentsDto();
            dto.setEnterpriseId(enterpriseId);
            dto.setDepIds(depIds);
            return dto;
        }).collect(Collectors.toList());
    }
}

